<?php
/**
 * OpenID Auth Module
 * 
 * @version $Rev$
 * @author "OpenID Auth Module" Development Committee
 *         Original author Nat Sakimura
 * @license GPL
 * @link $URL$
 */
$modversion['name'] = _MI_OPENID_NAME;
$modversion['version'] = 0.29;
$modversion['description'] = _MI_OPENID_DESC;
$modversion['credits'] = '"OpenID Auth Module" Development Committee<br />
Original author Nat Sakimura( http://www.sakimura.org/ )<br />';
$modversion['help'] = "openid.html";
$modversion['license'] = "GPL see LICENSE";
$modversion['official'] = 0;
$modversion['image'] = "images/openid_slogo.png";
$modversion['dirname'] = "openid";

// Admin things
$modversion['hasAdmin'] = 1;
$modversion['adminindex'] = "admin/index.php";
$modversion['adminmenu'] = "include/admin_menu.php";

// Sql file (must contain sql generated by phpMyAdmin or phpPgAdmin)
// All tables should not have any prefix!
$modversion['sqlfile']['mysql'] = "sql/mysql.sql";
//$modversion['sqlfile']['postgresql'] = "sql/pgsql.sql";

// Tables created by sql file (without prefix!)
$modversion['tables'][] = 'openid_identifier';
$modversion['tables'][] = 'openid_assoc';
$modversion['tables'][] = 'openid_nonce';
$modversion['tables'][] = 'openid_filter';
$modversion['tables'][] = 'openid_extension';
$modversion['tables'][] = 'openid_buttons';

// Blocks
$modversion['blocks'] = array();
$modversion['blocks'][1] = array(
    'file'      => 'openid_login.php',
    'name'      => _MI_OPENID_BNAME1,
    'description'   => 'Shows OpenID Login box',
    'show_func' => 'b_openid_login_show',
    'edit_func' => 'b_openid_login_edit',
    'template'  => 'openidurl.html',
    'options'   => _MI_OPENID_BLOCK_LABEL . '|1',
    'visible_any'   => true
);

// Menu
$modversion['hasMain'] = 1;
$modversion['read_any'] = true;

// Search
$modversion['hasSearch'] = 1;
$modversion['search']['file'] = 'include/search.php';
$modversion['search']['func'] = 'openid_search';

// Comments
$modversion['hasComments'] = 0;

// Templates
$modversion['templates'][1]['file'] = 'openid_consumer.html';
$modversion['templates'][1]['description'] = 'OpenID Consumer Screen';
$modversion['templates'][2]['file'] = 'openid_new_user.html';
$modversion['templates'][2]['description'] = 'New OpenID User Dialog';
$modversion['templates'][3]['file'] = 'openid_admin_default.html';
$modversion['templates'][3]['description'] = 'Template for admin panel';

// Config
$modversion['hasconfig'] = 1;
$modversion['config'] = array();

$modversion['config'][] = array(
 'name'     => 'allow_register',
 'title'    => '_MI_OPENID_CONF_ALLOW_REGISTER',
 'description'  => '_MI_OPENID_CONF_ALW_RG_DESC',
 'formtype' => 'yesno',
 'valuetype'    => 'int',
 'default'  => 1
);

$modversion['config'][] = array(
 'name'		=> 'filter_level',
 'title'	=> '_MI_OPENID_FILTER_LEVEL',
 'description'	=> '',
 'formtype'	=> 'select',
 'valuetype'	=> 'int',
 'default'	=> 0,
 'options'	=> array('_MI_OPENID_FILTER_NON' => 0,
                    '_MI_OPENID_FILTER_ALLOW_DEFAULT' => 1,
                    '_MI_OPENID_FILTER_DENY_DEFAULT' => 2)
);

$modversion['config'][] = array(
 'name'		=> 'default_group',
 'title'	=> '_MI_OPENID_DEFAULT_GROUP',
 'description'	=> '_MI_OPENID_DEFAULT_GROUP_DESC',
 'formtype'	=> 'group_multi',
 'valuetype'	=> 'array',
 'default'	=> XOOPS_GROUP_USERS,
 'options'	=> array()
);

$modversion['config'][] = array(
 'name'     => 'mode_policy',
 'title'    => '_MI_OPENID_CONF_MPOLICY',
 'description'  => '_MI_OPENID_CONF_MPOLICY_DESC',
 'formtype' => 'select',
 'valuetype'    => 'int',
 'default'  => 0,
 'options'  => array(
    '_MI_OPENID_CONF_USERS_CHOICE' => 0,
    '_MI_OPENID_CONF_PRIVATE' => 1,
    '_MI_OPENID_CONF_OPEN2MEMBER' => 2,
    '_MI_OPENID_CONF_PUBLIC' => 3)
);

$modversion['config'][] = array(
 'name'     => 'openid_rand_souce',
 'title'    => '_MI_OPENID_RAND_SOURCE',
 'description'  => '_MI_OPENID_RAND_SOURCE_DESC',
 'formtype' => 'textbox',
 'valuetype'    => 'string',
 'default'  => '/dev/urandom'
);

$modversion['config'][] = array(
 'name'		=> 'curl_cainfo_file',
 'title'	=> '_MI_OPENID_CAINFO_FILE',
 'description'	=> '_MI_OPENID_CAINFO_FILE_DESC',
 'formtype'	=> 'textbox',
 'valuetype'	=> 'string',
 'default'	=> ''
);

$modversion['onUpdate'] = 'include/onupdate.php' ;

// keep block's options
if (!defined('XOOPS_CUBE_LEGACY') && substr(XOOPS_VERSION, 6, 3) < 2.1 && !empty($_POST['fct']) && !empty($_POST['op']) && $_POST['fct'] == 'modulesadmin' && $_POST['op'] == 'update_ok' && $_POST['dirname'] == $modversion['dirname']) {
    include dirname(__FILE__) . '/include/x20_keepblockoptions.inc.php';
}
?>