<?php

require_once dirname(dirname(dirname(__FILE__))) . '/class/core/ActionBase.class.php';

class Xoonips_PolicyItemSortAction extends Xoonips_ActionBase {

	protected function doInit(&$request, &$response) {

		//title
		$title = _AM_XOONIPS_POLICY_ITEMSORT_LIST_TITLE;
		$description = _AM_XOONIPS_POLICY_ITEMSORT_LIST_DESC;

		// breadcrumbs
		$breadcrumbs = $this->setBreadcrumbs(true);

		$token_ticket = $this->createToken($this->modulePrefix('admin_policy_itemsort_default'));

		$sortBean = Xoonips_BeanFactory::getBean('ItemTypeSortBean', $this->dirname, $this->trustDirname);

		// get common viewdata
		$viewData = array();

		$viewData['token_ticket'] = $token_ticket;
		$viewData['breadcrumbs'] = $breadcrumbs;
		$viewData['title'] = $title;
		$viewData['description'] = $description;
		$viewData['itemsort_list'] = $sortBean->select();
		$viewData['dirname'] = $this->dirname;

		$response->setViewData($viewData);
		$response->setForward('init_success');
		return true;
	}

	protected function doEdit(&$request, &$response) {

		//title
		$title = _AM_XOONIPS_POLICY_ITEMSORT_EDIT_TITLE;

		// breadcrumbs
		$breadcrumbs = $this->setBreadcrumbs(false);

		$request = new Xoonips_Request();
		$mode = $request->getParameter('mode');

		// token ticket
		if ($mode == 1) {
			$token_ticket = $this->createToken($this->modulePrefix('admin_policy_itemsort_edit'));
		} else {
			$token_ticket = $this->createToken($this->modulePrefix('admin_policy_itemsort_delete'));
		}
		$sort_id = $request->getParameter('sort_id');
		if (is_null($sort_id)) {
			$sort_id = 0;
		}

		$sortBean = Xoonips_BeanFactory::getBean('ItemTypeSortBean', $this->dirname, $this->trustDirname);

		// get common viewdata
		$viewData = array();

		$viewData['breadcrumbs'] = $breadcrumbs;
		$viewData['title'] = $title;
		$viewData['token_ticket'] = $token_ticket;
		$viewData['mode'] = $mode;
		$viewData['itemsort_sort'] = $sortBean->select($sort_id);
		$viewData['itemsort_detail_list'] = $sortBean->getDetailList($sort_id);
		$viewData['dirname'] = $this->dirname;

		$response->setViewData($viewData);
		$response->setForward('edit_success');
		return true;
	}

	protected function doSave(&$request, &$response) {
		if (!$this->validateToken($this->modulePrefix('admin_policy_itemsort_edit'))) {
			$response->setSystemError('Ticket error');
			return false;
		}

		//title
		$title = _AM_XOONIPS_POLICY_ITEMSORT_EDIT_TITLE;

		// breadcrumbs
		$breadcrumbs = $this->setBreadcrumbs(false);

		$sort_id = $request->getParameter('sort_id');

		return $this->saveItemsortInfo($request, $response);
	}

	protected function doDelete(&$request, &$response) {
		$sort_id = $request->getParameter('sort_id');

		$sortBean = Xoonips_BeanFactory::getBean('ItemTypeSortBean', $this->dirname, $this->trustDirname);

		if (!$this->validateToken($this->modulePrefix('admin_policy_itemsort_delete'))) {
			$response->setSystemError('Ticket error');
			return false;
		} elseif (count($sortBean->select($sort_id)) == 0) {
			$errors = new Xoonips_Errors();
			$parameters = array();
			$parameters[] = _AM_XOONIPS_POLICY_ITEMSORT_ITEM;
			$erros->addError('_AM_XOONIPS_ERROR_ALREADY_DELETED', '', $parameters);
			$response->setSystemError($errors->getView($this->dirname, true));
			return false;
		} else {
			$sortDetailBean = Xoonips_BeanFactory::getBean('ItemTypeSortDetailBean', $this->dirname, $this->trustDirname);

			// start transaction
	  		$this->startTransaction();
			if (!$sortDetailBean->delete($sort_id)) {
				$response->setSystemError(_AM_XOONIPS_ERROR_DBDELETED_FAILED);
				return false;
			}
			if (!$sortBean->delete($sort_id)) {
				$response->setSystemError(_AM_XOONIPS_ERROR_DBDELETED_FAILED);
				return false;
			}
		}
		$viewData['url'] = XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemsort.php';
		$viewData['redirect_msg'] = _AM_XOONIPS_MSG_DBDELETED;
		$response->setViewData($viewData);
		$response->setForward("delete_success");
		return true;
	}

	private function saveItemsortInfo(&$request, &$response) {
		$itemsort_id = $request->getParameter('sort_id');
		$itemsort_title = $request->getParameter('itemsort_title');

		$sortBean = Xoonips_BeanFactory::getBean('ItemTypeSortBean', $this->dirname, $this->trustDirname);

		$errors = new Xoonips_Errors();
		$parameters = array();
		$parameters[] = _AM_XOONIPS_POLICY_ITEMSORT_ITEM;
		// check if title is empty
		if (empty($itemsort_title) || trim($itemsort_title) === '') {
			$errors->addError('_AM_XOONIPS_ERROR_REQUIRED', '', $parameters);
		}
		if (strlen($itemsort_title) > 255) {
			$parameters[] = 255;
			$errors->addError('_AM_XOONIPS_ERROR_MAXLENGTH', '', $parameters);
		}
		// uppdate
		if (!empty($itemsort_id)) {
			$sortInfo = $sortBean->select($itemsort_id);
			if (count($sortInfo) === 0) {
				$erros->addError('_AM_XOONIPS_ERROR_ALREADY_DELETED', '', $parameters);
			}
			if ($sortInfo[0]['title'] != $itemsort_title && count($sortBean->selectByTitle($itemsort_title)) > 0) {
				$errors->addError('_AM_XOONIPS_ERROR_DUPLICATE_MSG', '', $parameters);
			}
		// add
		} else {
			if (count($sortBean->selectByTitle($itemsort_title)) > 0) {
				$errors->addError('_AM_XOONIPS_ERROR_DUPLICATE_MSG', '', $parameters);
			}
		}

		$itemsort_item_type_id = $request->getParameter('itemsort_item_type_id');
		$itemsort_detail_item = $request->getParameter('itemsort_detail_item');

		if ($errors->hasError()) {
			$itemsort_sort = array(array('sort_id' => $itemsort_id, 'title' => $itemsort_title));
			$itemsort_detail_list = $sortBean->getDetailList($itemsort_id);
			$pos = 0;
			foreach ($itemsort_detail_list as &$itemsort_detail) {
				foreach ($itemsort_detail as &$optiondata) {
					$optiondata['selected_item_field_detail_id'] = null;
					if ($optiondata['item_field_detail_id'] == $itemsort_detail_item[$pos]) {
						$optiondata['selected_item_field_detail_id'] = $itemsort_detail_item[$pos];
					}
				}
				$pos = $pos + 1;
			}

			// token ticket
			$token_ticket = $this->createToken( $this->modulePrefix('admin_policy_itemsort_edit') );

			$viewData['errors'] = $errors->getView($this->dirname);
			$viewData['breadcrumbs'] = $this->setBreadcrumbs(false);
			$viewData['title'] = _AM_XOONIPS_POLICY_ITEMSORT_EDIT_TITLE;
			$viewData['token_ticket'] = $token_ticket;
			$viewData['mode'] = 1;
			$viewData['itemsort_sort'] = $itemsort_sort;
			$viewData['itemsort_detail_list'] = $itemsort_detail_list;
			$viewData['dirname'] = $this->dirname;

			$response->setViewData($viewData);
			$response->setForward('edit_success');

			return true;
		}


		$sortBean = Xoonips_BeanFactory::getBean('ItemTypeSortBean', $this->dirname, $this->trustDirname);
		$sortDetailBean = Xoonips_BeanFactory::getBean('ItemTypeSortDetailBean', $this->dirname, $this->trustDirname);

		// start transaction
		$this->startTransaction();
		//add
		if (empty($itemsort_id)) {
			if (!$sortBean->insert($itemsort_title, $itemsort_id)) {
				$this->showError($response, _AM_XOONIPS_ERROR_DBUPDATE_FAILED);
				return false;
			}
		//update
		} else {
			if (!$sortBean->update($itemsort_id, $itemsort_title)) {
				$this->showError($response, _AM_XOONIPS_ERROR_DBUPDATE_FAILED);
				return false;
			}
		}
		if (!$sortDetailBean->delete($itemsort_id)) {
			$this->showError($response, _AM_XOONIPS_ERROR_DBUPDATE_FAILED);
			return false;
		}
		for ($i = 0; $i < count($itemsort_item_type_id); $i++) {
			if (empty($itemsort_detail_item[$i])) {
				$itemsort_detail_item[$i] = 'NULL';
			}
			if (!$sortDetailBean->insert($itemsort_id, $itemsort_item_type_id[$i], $itemsort_detail_item[$i])) {
				$this->showError($response, _AM_XOONIPS_ERROR_DBUPDATE_FAILED);
				return false;
			}
		}
		$this->showError($response, _AM_XOONIPS_MSG_DBUPDATED);
		return true;
	}

	private function showError(&$response, $msg) {
		$viewData['url'] = XOOPS_URL . '/modules/' . $this->dirname . '/admin/policy_itemsort.php';
		$viewData['redirect_msg'] = $msg;
		$response->setViewData($viewData);
		$response->setForward('save_success');
	}

	private function setBreadcrumbs($isTop) {
		$breadcrumbs = array(
			array(
		        'name' => _AM_XOONIPS_TITLE,
		        'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/index.php',
			),
			array(
		        'name' => _AM_XOONIPS_POLICY_TITLE,
		        'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy.php',
			),
			array(
		        'name' => _AM_XOONIPS_POLICY_ITEM_TITLE,
		        'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_item.php',
			),
		);
		if (!$isTop) {
			$breadcrumbs[] = array(
		        'name' =>_AM_XOONIPS_POLICY_ITEMSORT_TITLE,
		        'url' => XOOPS_URL.'/modules/'.$this->dirname.'/admin/policy_itemsort.php',
			);
			$breadcrumbs[] = array(
    	        'name' =>_AM_XOONIPS_POLICY_ITEMSORT_EDIT_TITLE,
			);
		} else {
			$breadcrumbs[] = array(
    	        'name' =>_AM_XOONIPS_POLICY_ITEMSORT_TITLE,
			);
		}
		return $breadcrumbs;
	}
}

