<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

if(!defined('XLEPROGRESS_TRUST_PATH'))
{
    define('XLEPROGRESS_TRUST_PATH', XOOPS_TRUST_PATH . '/modules/xleprogress');
}

require_once XLEPROGRESS_TRUST_PATH . '/class/XleprogressUtils.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Utils.class.php';

/**
 * Xleprogress_AssetPreloadBase
**/
class Xleprogress_AssetPreloadBase extends XCube_ActionFilter
{
	public $mDirname = null;

	/**
     * prepare
     * 
     * @param   string  $dirname
     * 
     * @return  void
    **/
    public static function prepare(/*** string ***/ $dirname)
    {
		Xoonips_Utils::loadMessage('xleprogress');
		Xoonips_Utils::loadModinfoMessage('xleprogress');
    	$root =& XCube_Root::getSingleton();
        $instance = new Xleprogress_AssetPreloadBase($root->mController);
        $instance->mDirname = $dirname;
        $root->mController->addActionFilter($instance);
    }

    /**
     * _setup
     * 
     * @param   void
     * 
     * @return  bool
    **/
    public static function _setup()
    {
        $root =& XCube_Root::getSingleton();
        $instance = new self($root->mController);
        $root->mController->addActionFilter($instance);
        return true;
    }

    /**
     * preBlockFilter
     * 
     * @param   void
     * 
     * @return  void
    **/
    public function preBlockFilter()
    {
        $this->mRoot->mDelegateManager->add('Module.xleprogress.Global.Event.GetAssetManager','Xleprogress_AssetPreloadBase::getManager');
        $this->mRoot->mDelegateManager->add('Legacy_Utils.CreateModule','Xleprogress_AssetPreloadBase::getModule');
        $this->mRoot->mDelegateManager->add('Legacy_Utils.CreateBlockProcedure','Xleprogress_AssetPreloadBase::getBlock');
        $file = XLEPROGRESS_TRUST_PATH . '/class/DelegateFunctions.class.php';
        $this->mRoot->mDelegateManager->add('Legacy_Workflow.AddItem','Xleprogress_DelegateFunctions::addItem', $file);
        $this->mRoot->mDelegateManager->add('Legacy_Workflow.DeleteItem','Xleprogress_DelegateFunctions::deleteItem', $file);
        $this->mRoot->mDelegateManager->add('Legacy_Workflow.GetHistory','Xleprogress_DelegateFunctions::getHistory', $file);
        $this->mRoot->mDelegateManager->add('Legacy_Workflow.GetCurrentCertifyUsers','Xleprogress_DelegateFunctions::getCurrentCertifyUsers', $file);
        $this->mRoot->mDelegateManager->add('Legacy_Workflow.GetAllCertifyUsers','Xleprogress_DelegateFunctions::getAllCertifyUsers', $file);
        $this->mRoot->mDelegateManager->add('Legacy_Workflow.AutoReject','Xleprogress_DelegateFunctions::autoReject', $file);
        $this->mRoot->mDelegateManager->add('Legacy_Workflow.AutoCertify','Xleprogress_DelegateFunctions::autoCertify', $file);
        $this->mRoot->mDelegateManager->add('Legacy_Workflow.CountMyTask','Xleprogress_DelegateFunctions::countMyTask', $file);
        $this->mRoot->mDelegateManager->add('Legacy_Workflow.CheckAuthen','Xleprogress_DelegateFunctions::checkAuthen', $file);
        $this->mRoot->mDelegateManager->add('Legacy_Workflow.CheckApproval','Xleprogress_DelegateFunctions::checkApproval', $file);
    }

    /**
     * getManager
     * 
     * @param   Xleprogress_AssetManager  &$obj
     * @param   string  $dirname
     * 
     * @return  void
    **/
    public static function getManager(/*** Xleprogress_AssetManager ***/ &$obj,/*** string ***/ $dirname)
    {
        require_once XLEPROGRESS_TRUST_PATH . '/class/AssetManager.class.php';
        $obj = Xleprogress_AssetManager::getInstance($dirname);
    }

    /**
     * getModule
     * 
     * @param   Legacy_AbstractModule  &$obj
     * @param   XoopsModule  $module
     * 
     * @return  void
    **/
    public static function getModule(/*** Legacy_AbstractModule ***/ &$obj,/*** XoopsModule ***/ $module)
    {
        if($module->getInfo('trust_dirname') == 'xleprogress')
        {
            require_once XLEPROGRESS_TRUST_PATH . '/class/Module.class.php';
            $obj = new Xleprogress_Module($module);
        }
    }

    /**
     * getBlock
     * 
     * @param   Legacy_AbstractBlockProcedure  &$obj
     * @param   XoopsBlock  $block
     * 
     * @return  void
    **/
    public static function getBlock(/*** Legacy_AbstractBlockProcedure ***/ &$obj,/*** XoopsBlock ***/ $block)
    {
        $moduleHandler =& Xleprogress_Utils::getXoopsHandler('module');
        $module =& $moduleHandler->get($block->get('mid'));
        if(is_object($module) && $module->getInfo('trust_dirname') == 'xleprogress')
        {
            require_once XLEPROGRESS_TRUST_PATH . '/blocks/' . $block->get('func_file');
            $className = 'Xleprogress_' . substr($block->get('show_func'), 4);
            $obj = new $className($block);
        }
    }
}

?>
