/*
 * Javascript Library
 */
if (typeof(UserEdit) == 'undefined') UserEdit = function() {};
/** 
 * constructor
 *
 * @access public
 * @return object instance
 */
UserEdit.edit = function(xoops_url, dirname, form, action) {
	this.xoops_url = xoops_url;
	if (dirname != null) {
		this.dirname = dirname;
	} else {
		this.dirname = 'user';
	}
	this.form = this.dirname + '_' + form;
	this.target = '#' + this.dirname + '_targetItemId'; 
	this.action = action;
	return this;
}

UserEdit.edit.prototype = {	
	//change check box
	changeCheckBox: function(chk, targetName) {
		var target = document.getElementById(targetName);
		if (chk.checked == true) {
			target.value = '1';
		} else {
			target.value = '0';
		}
	},
	// change other radio box
	changeRadioBox: function(radio, targetName) {
		var target = document.getElementById(targetName);
		if (radio.checked == true) {
			target.value = radio.value;
		}
	},	
	// change GroupName
	changeGroupName: function(group, targetName) {
		var target = document.getElementById(targetName);
		target.value = '';
		for ( var i = 0; i < group.length; i++) {
			if (group.options[i].selected == true) {
				target.value += group.options[i].value + ',';
			}
		}
		if (group.selected == true) {
			target.value = group.value + ',';
		}
	},	
	addFieldGroup: function(id) {
		var formobj = jQuery('#' + this.form);
		formobj.find(this.target).val(id);
		formobj.attr('action', this.action + '.php?op=addFieldGroup');
		formobj.submit();
	},
	// item del request
	deleteFieldGroup: function(id) {
		var formobj = jQuery('#' + this.form);
		formobj.find(this.target).val(id);
		formobj.attr('action', this.action + '.php?op=deleteFieldGroup');
		formobj.submit();
	},
	//change date
	changeDate: function(id) {
		var formobj = jQuery('#' + this.form);
		var length = id.length;
		id = id.substring(0, length - 2);
		id = id.replace(/:/g, '\\:');
		var year_id = id + '_y';
		var yearValue = formobj.find('#' + year_id).val();
		var month_id = id + '_m';
		var monthValue = formobj.find('#' + month_id).val();
		var day_id = id + '_d';
		var dayValue = formobj.find('#' + day_id).val();
		if (yearValue == '' && monthValue == '' && dayValue == '') {
			formobj.find('#' + id).val('');
		} else {
			var DateValue = yearValue + '-' + monthValue + '-' + dayValue;
			formobj.find('#' + id).val(DateValue);
		}
	},
	sortable: function() {
		jQuery('.' + this.dirname + '_sortableDiv').sortable();
		jQuery('.' + this.dirname + '_sortable tbody').sortable({handle: 'td:first'});
	}
}
jQuery(function(){
	jQuery('#user_avatarSelect').change(function(){
		var url = jQuery('#user_avatarHidden').val() + jQuery('#user_avatarSelect').val();
		var imgAvatar = '';
		if (jQuery('#user_avatarSelect').val()=='' || jQuery('#user_avatarSelect').val()=='blank.gif') {
			url = '';
		} else {
			imgAvatar = '<img src="'+url+'">';	
		}
		jQuery('#user_avatarImg').html(imgAvatar);
	 });
});
