<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/WorkflowBase.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanFactory.class.php';

class Xoonips_WorkflowGroupItems extends Xoonips_WorkflowBase {

	public function doCertify($indexItemLinkId, &$result, $comment) {
		$result[0] = true;
		$indexItemLinkBean = null;
		list($itemId, $indexId, $groupId) = $this->getTargetGroupId($indexItemLinkId, $indexItemLinkBean);
		if ($groupId == 0 || !$indexItemLinkBean->update($indexId, $itemId, XOONIPS_CERTIFIED)) {
			$result[0] = false;
		}
		
		if ($result[0]) {
			$groupBean = Xoonips_BeanFactory::getBean('GroupsBean', XCUBE_CORE_USER_MODULE_NAME);
			$itemBean = Xoonips_BeanFactory::getBean('ItemVirtualBean', $this->dirname, $this->trustDirname);
			$fileBean = Xoonips_BeanFactory::getBean('ItemFileBean', $this->dirname, $this->trustDirname);
			$groupInfo = $groupBean->getGroup($groupId);
			if ($groupInfo['item_number_limit'] > 0 && $itemBean->countGroupItems($groupId) >= $groupInfo['item_number_limit']) {
				$result[0] = false;
				$result[1] = _MD_XOONIPS_ITEM_WARNING_ITEM_NUMBER_LIMIT;
			}
		}
		if ($result[0]) {
			if ($groupInfo['item_storage_limit'] > 0 && $fileBean->countGroupFileSizes($groupId) >= $groupInfo['item_storage_limit']) {
				$result[0] = false;
				$result[1] = _MD_XOONIPS_ITEM_WARNING_ITEM_NUMBER_LIMIT;
			}	
		}
		if ($result[0]) {
			if ($groupBean->isPublic($groupId)) {
				$itemStatusBean = Xoonips_BeanFactory::getBean('OaipmhItemStatusBean', $this->dirname, $this->trustDirname);
				if (!$itemStatusBean->updateItemStatus($itemId)) {
					$result[0] = false;
				}
			}
		}
		if (!$result[0]) {
			$indexItemLinkBean->update($indexId, $itemId, XOONIPS_CERTIFY_REQUIRED);
			return;
		}
		//event log
		$this->log->recordCertifyGroupItemEvent($indexId, $itemId);
		
		//send to item users
		$groupsUsersLinkBean = Xoonips_BeanFactory::getBean('GroupsUsersLinkBean', XCUBE_CORE_USER_MODULE_NAME);
		$itemUsersBean = Xoonips_BeanFactory::getBean('ItemUsersLinkBean', $this->dirname, $this->trustDirname);
		$itemUsersInfo = $itemUsersBean->getItemUsersInfo($itemId);
		foreach ($groupsUsersLinkBean->getAdminUserIds($groupId) as $id) {
			$sendToUsers[$id] = $id; 
		}
		foreach ($itemUsersInfo as $itemUser) {
			$sendToUsers[$itemUser['uid']] = $itemUser['uid'];
		}
		XCube_DelegateUtils::call('Legacy_Workflow.GetAllCertifyUsers', Xoonips_Enum::certifyGroupItems($this->dirname), new XCube_Ref($sendToUsers));
		$this->notification->groupItemCertified($itemId, $indexId, $groupId, $sendToUsers, $comment);
	}

	public function doProgress($indexItemLinkId, &$result, $comment) {
		$result[0] = false;
		$indexItemLinkBean = null;
		list($itemId, $indexId, $groupId) = $this->getTargetGroupId($indexItemLinkId, $indexItemLinkBean);
		if ($groupId == 0) {
			return;
		}
		$sendToUsers = array();
		XCube_DelegateUtils::call('Legacy_Workflow.GetCurrentCertifyUsers', Xoonips_Enum::certifyGroupItems($this->dirname), $indexItemLinkId, new XCube_Ref($sendToUsers));
		$this->notification->groupItemCertifyRequest($itemId, $indexId, $groupId, $sendToUsers);
		$result[0] = true;
	}

	public function doRefuse($indexItemLinkId, &$result, $comment) {
		$result[0] = false;
		$indexItemLinkBean = null;
		list($itemId, $indexId, $groupId) = $this->getTargetGroupId($indexItemLinkId, $indexItemLinkBean);
		if ($groupId == 0 || !$indexItemLinkBean->deleteByid($indexId, $itemId)) {
			return false;
		}
		$result[0] = true;

		//event log
		$this->log->recordRejectGroupItemEvent($indexId, $itemId);
		
		//send to item user
		$groupsUsersLinkBean = Xoonips_BeanFactory::getBean('GroupsUsersLinkBean', XCUBE_CORE_USER_MODULE_NAME);
		$itemUsersBean = Xoonips_BeanFactory::getBean('ItemUsersLinkBean', $this->dirname, $this->trustDirname);
		$itemUsersInfo = $itemUsersBean->getItemUsersInfo($itemId);
		foreach ($groupsUsersLinkBean->getAdminUserIds($groupId) as $id) {
			$sendToUsers[$id] = $id; 
		}
		foreach ($itemUsersInfo as $itemUser) {
			$sendToUsers[$itemUser['uid']] = $itemUser['uid'];
		}
		XCube_DelegateUtils::call('Legacy_Workflow.GetAllCertifyUsers', Xoonips_Enum::certifyGroupItems($this->dirname), new XCube_Ref($sendToUsers));
		$this->notification->groupItemRejected($itemId, $indexId, $groupId, $sendToUsers, $comment);
	}
	
	public function getDetailView($indexItemLinkId) {
		$workflow = Xoonips_WorkflowFactory::getWorkflow('WorkflowPublicItems', $this->dirname, $this->trustDirname);
		return $workflow->getDetailView($indexItemLinkId);
	}
	
	public function getTargetGroupId($indexItemLinkId, &$indexItemLinkBean) {
		$workflow = Xoonips_WorkflowFactory::getWorkflow('WorkflowPublicItems', $this->dirname, $this->trustDirname);
		list($itemId, $indexId) = $workflow->getItemAndIndexId($indexItemLinkId, $indexItemLinkBean);
		if ($itemId != 0) {
			$indexBean = Xoonips_BeanFactory::getBean('IndexBean', $this->dirname, $this->trustDirname);
			$indexInfo = $indexBean->getIndex($indexId);
			if ($indexInfo) {
				$groupId = $indexInfo['groupid'];
			} else {
				$groupId = 0;
			}
		} else {
			$groupId = 0;
		}
		return array($itemId, $indexId, $groupId);
	}
}

