<?php
global $MAIN_FILE;
require_once $MAIN_FILE;
require_once XOOPS_TRUST_PATH.'/modules/xdbmigrate/cmd/item_type/xdbmigrate_itemtype_base.inc.php';

class xnpmemo extends xdbmigrate_itemtype_base {

  function __construct() {
    
  }
  
  /**
   * Initialize 
   */
  public function init($db) {
    parent::init($db);
    $this->set_ng_item_name('Memo');
    $this->add_file_mapping_array('memo_file', 'files');
    
    #Description migrate to ...
    $this->set_description('outline');
    
    #Duplicate Table
    $this->add_dup_table('xnpmemo_item_detail');
  }
  
 /**
   *
   * This function get xnpmemo_item_detail table info.
   * 
   * @param int $item_id
   * @return Success:xnpmemo_item_detail Array includes fields, Fail:FALSE 
   */
  protected function get_xnpmemo_item_detail($item_id){
    $tbl = get_WK_tbl('xnpmemo_item_detail');
    $sql = "select item_link from {$tbl} where memo_id={$item_id}";
    $result_array = $this->db->query($sql);
    if(count($result_array) == 1){
      return $result_array[0]['item_link'];
    }
    return FALSE;    
  }
  
  /**
   * Do migaration.
   * 
   * @param array $item xoonips_basic_item
   * @return Success:0,Fail:Negative number
   */
  public function migrate($item) {
    #xoonips_item
    $item_id = $item['item_id'];
    $item_detail = $this->get_xnpmemo_item_detail($item_id);
    if($item_detail === FALSE || $item_detail === null){
      return -errmsg(APP_MIGRATE, 'E1801',$item_id);
    }
    
    $result_array = $this->get_table_column_by_item('item_link',  $this->get_ng_item_name());
    if($result_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E1802');
    }
    $rc = $this->insert_any($result_array,$item_id,$item_detail);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E1803',$item_id);
    }
    return 0;
  }
}
