<?php

/**
 * Item related functions
 * 
 */

require_once $MAIN_FILE;
require_once XOOPS_TRUST_PATH.'/modules/xdbmigrate/cmd/inc/migrate_db.inc.php';

class item {
  public function migrate($db) {
    global $RUN_LOG;
    
    # listing xoonips_item_basic
    $item_basic = get_WK_tbl('xoonips_item_basic');
    $item_type  = get_WK_tbl('xoonips_item_type');
    $sql_item_basic = 'select * from '.$item_basic.','.$item_type.
            ' where '.$item_type.'.item_type_id ='.$item_basic.'.item_type_id'.
            ' order by item_id';
    $wk_array = $db->query($sql_item_basic);
    foreach ($wk_array as $value) {
      if($value['item_type_id'] == 1){
        continue;
      }
      #item_type file exists?

      $fname = 'item_type/'.$value['name'].'.inc.php';
      if(!file_exists($fname)){
        echo "{$fname} not exist\n";
        continue;
      }
      require_once $fname;
      
      #class exists?
      $classname = $value['name'];
      if(!class_exists($classname)){
        echo "class {$classname} not exist\n";
        continue;     
      }
      $c = new $classname;
      $c->init($db);
      $rc = $c->migrate_xoonips_item($value);
      if($rc < 0)return $rc;
      $logmsg = sprintf("ITEM_TYPE:item_type=%s item_id=%d\n",$value['name'],$value['item_id']);
      fprintf(STDERR,$logmsg);
      if(!is_null($RUN_LOG)){
        error_log(date('Y/m/d H:i:s').' '.$logmsg,3,$RUN_LOG);
      }
    }
    
    return 0;
  }
}
