<?php

/**
 * User related functions
 * 
 */

require_once $MAIN_FILE;
require_once XOOPS_TRUST_PATH.'/modules/xdbmigrate/cmd/inc/migrate_db.inc.php';

class groups {
  
  private $db;
  private $ng_gid;
  private $old_xoonips_moderator_gid = null;
  private $new_xoonips_moderator_gid = null;
  function __construct() {
    
  }
  

  /**
   * This function get current auto_inc (groupid).
   * 
   * 
   * @return Success:>0 current auto_inc,Fail:-1
   */
  private function current_auto_inc() {
    $tbl = get_tbl('groups');
    $sql = "show table status like '{$tbl}'" ;
    $reults=$this->db->query($sql);
    if($reults !== FALSE){
      return $reults[0]['Auto_increment'];
    }
    return -1;
  }

  /**
   * Get xoonips_group
   * 
   * @return int Success:>0,Fail:FALSE
   */
  private function get_xoonips_group(){
    $tbl = get_WK_tbl('xoonips_groups');
    $sql = "select gid from {$tbl}";
    $reults=$this->db->query($sql);
    if($reults !== FALSE){
      return $reults;
    }
    return FALSE;
  }

  /**
   * count moderator on group table.
   * 
   * @return int 0:not duplicate n>1:duplicate moderator gid
   */
  private function count_moderator() {
    $tbl = get_tbl("groups");
    $sql = "select count(groupid) as count,max(groupid) as max,min(groupid) as min from {$tbl} WHERE name='moderator'";
    $result = $this->db->query($sql);
    if(is_array($result) && $result[0]['count'] > 1){
      return $result[0];
    }
    return 0;
  }
  
  /**
   * delete modatror
   * 
   * @param string $tbl group or groups_users_link
   * @param int    $gid gid,get from count_moderator
   * @return boolean Success:true,Fail:false
   */
  private function delete_moderator($tbl,$gid) {
    $deltbl = get_tbl($tbl);
    $sql = "delete from {$deltbl} where groupid={$gid}";
    return $this->db->exec($sql);
  }
  
  /**
   * xleprogress_approval exist?
   * 
   * @return boolean exist:true,not exist:false
   */
  private function exist_xleprogress_approval() {
    $tbl = get_tbl('xleprogress_approval');
    $sql = "SHOW TABLES  LIKE '{$tbl}'";
    $result = $this->db->query($sql);
    if(is_array($result) && count($result)>0){
      return true;
    }
    return false;
  }


  private function update_xleprogress_approval_groupid() {
    $tbl  = get_tbl('xleprogress_approval');
    $sql = "update {$tbl} set groupid = {$this->old_xoonips_moderator_gid} where groupid={$this->new_xoonips_moderator_gid}";
    return $this->db->exec($sql);
  }

  /**
   * if moderator duplicated,this fuction delete the latter moderator.
   * It means next generation XooNIps create moderator.
   */
  private function find_delete_duplicated_moderator() {
    #check duplicate moderator
    $result = $this->count_moderator();
    
    if(!is_array($result))return;
    $this->old_xoonips_moderator_gid = $result['max'];
    $this->new_xoonips_moderator_gid = $result['min'];
    $rc = $this->delete_moderator('groups_users_link',$this->old_xoonips_moderator_gid);
    if($rc == false)return;
    $rc = $this->delete_moderator('groups',$this->old_xoonips_moderator_gid);
    if($rc == false)return;
    if($this->exist_xleprogress_approval()){
      $rc = $this->update_xleprogress_approval_groupid();
    }
  }

  /**
   * xoonips_groups migrate to groups.
   * 
   * @return boolean Success:true,Fail:false 
   */
  private function migrate_group()
  {
    $this->ng_gid = $this->current_auto_inc();  #start NG gid
    if($this->ng_gid === -1)return false;
    
    $tbl = get_tbl('groups');
    $wk_tbl = get_WK_tbl('xoonips_groups');
      
    # xoonips_group table which not exist in group table Insert to group table.
    $sql = "insert into {$tbl} (activate,groupid,name,description,group_type,index_id) ".
    "select 1,gid+{$this->ng_gid},gname,gdesc,'User',group_index_id from {$wk_tbl} where gid in (".
    "select gid from {$wk_tbl}  where gid not in (".
    "select distinct gid from {$wk_tbl} as xg , {$tbl} as g where xg.gname = g.name))";
    return $this->db->exec($sql);    
  }
  
  public function get_last_autoinc() {
    return $this->ng_gid;
  }
  
  public function get_old_moderator_gid(){
    return $this->old_xoonips_moderator_gid;
  }
  public function get_new_moderator_gid(){
    return $this->new_xoonips_moderator_gid;
  }
  
  private function check_migrated() {
    $tbl = get_tbl('groups');
    $wk_tbl = get_WK_tbl('xoonips_groups');
    $sql = "select count(*) as cnt from {$tbl} where name in (select gname from {$wk_tbl}) ";
    $result = $this->db->query($sql);
    if(is_array($result) && $result[0]['cnt'] > 0){
      return true;
    }
    return false;
  }
  
  /**
   * Do migration.
   * 
   * @param  object dbobj.
   * @return int Sucess:0,Fail:0>
   */
  public function migrate($db) {
    $this->db = $db;
    
    if($this->check_migrated() == true){
      return -errmsg(APP_MIGRATE,'E3101');
    }
    $this->migrate_group();
    
    #delete to duplicat Moderator group.
    $this->find_delete_duplicated_moderator();
    
  
    return 0;
  }

}
