<?php
/**
 * xoonips_event_log tables migrate functions.
 * 
 */

require_once $MAIN_FILE;
require_once XOOPS_TRUST_PATH.'/modules/xdbmigrate/cmd/inc/migrate_db.inc.php';

class event_log
{
  private $db;
  private $last_autoinc = null;
  function __construct() {
    
  }
  
  /**
   * migrate xoonips_event_log
   * 
   * @return Boolean Success:true Fail:false
   */
  private function migrate_event_log() {
    $tbl   = get_tbl('xoonips_event_log');
    $wktbl = get_WK_tbl('xoonips_event_log');
    $sql = "insert into {$tbl} (event_type_id,timestamp,exec_uid,remote_host,index_id,item_id,file_id,uid,groupid,search_keyword,additional_info) ".
            "select event_type_id,timestamp,exec_uid,remote_host,index_id,item_id,file_id,uid,gid,search_keyword,additional_info from {$wktbl}";
    return $this->db->exec($sql);
  }
  
  /**
   * groupid update on xoonips_event_log
   * 
   * @return Boolean Success:true Fail:false
   */
  private function update_gid() {
    $tbl   = get_tbl('xoonips_event_log');
    $sql = "update {$tbl} set groupid = groupid + {$this->last_autoinc} where groupid > 0";
    return $this->db->exec($sql);
  }


  /**
   * Set groups object
   * 
   * @param object $groups 
   */
  public function set_groups_obj(&$groups)
  {
    $this->last_autoinc = $groups->get_last_autoinc();
  }  
  /**
   * Do migration.
   * 
   * @return int Sucess:0,Fail:0>
   */
  public function migrate($db) {
    $this->db = $db;
    $rc = $this->migrate_event_log();
    if($rc === false){
      return -errmsg(APP_MIGRATE, 'E2901');
    }
    $rc = $this->update_gid();
    if($rc === false){
      return -errmsg(APP_MIGRATE, 'E2902');
    }  
    return 0;
  }
};

?>
