<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/WorkflowBase.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanFactory.class.php';
require_once dirname(dirname(__FILE__)) . '/core/User.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Utils.class.php';

class User_WorkflowUser extends Xoonips_WorkflowBase {

	public function doCertify($uid, &$result, $comment) {
		$result[0] = false;
		$result[1] = _MD_USER_MESSAGE_ACCOUNT_CERTIFIED;
		$xoopsUser = new XoopsUser($uid);
		$userBean = Xoonips_BeanFactory::getBean('UsersBean', $this->dirname, $this->trustDirname);
		$user = $userBean->getUserBasicInfo($uid);
		if (!$user) {
			return;
		}
		/*$result = array();
		XCube_DelegateUtils::call('Module.User.GetMessageSign', new XCube_Ref($result));
		foreach ($result as $messageSign) {
			$myxoopsConfig = $messageSign;
		}*/
		$myxoopsConfig = Xoonips_Utils::getXoopsConfigs(XOOPS_CONF);
		$myxoopsConfigUser = Xoonips_Utils::getXoopsConfigs(XOOPS_CONF_USER);
		$user_certify_date = $myxoopsConfigUser['user_certify_date'];
		$deleteUserInfo = new XoopsUser($uid);
		//certify time out
		if ($user_certify_date > 0) {
			$time = (time()- $user['user_regdate']) / (24 * 60 * 60);
			if ($time > $user_certify_date) {
				if (!$userBean->deleteUsers($uid)) {	
					return false;
				}
				$groupUserLinkBean = Xoonips_BeanFactory::getBean('GroupsUsersLinkBean', $this->dirname, $this->trustDirname);
				if (!$groupUserLinkBean->deleteByUid($uid)) {
					return false;
				}
				XCube_DelegateUtils::call('Module.User.Event.User.Delete', $xoopsUser);
				
				$result[1] = _MD_USER_MESSAGE_ACTIVATE_TIMEOUT;
				//send mail to user
				$xoopsMailer =& getMailer();
				$xoopsMailer->useMail();
				$xoopsMailer->setTemplateDir(Xoonips_Utils::mailTemplateDir($this->dirname, $this->trustDirname));
				$xoopsMailer->setTemplate('user_certify_timeout.tpl');
				$xoopsMailer->assign('USERNAME', $user['uname']);
				$xoopsMailer->assign('SITENAME', $myxoopsConfig['sitename']);
				$xoopsMailer->assign('ADMINMAIL', $myxoopsConfig['adminmail']);
				$xoopsMailer->assign('SITEURL', XOOPS_URL . '/');
				$xoopsMailer->setToUsers($deleteUserInfo);
				$xoopsMailer->setFromEmail($myxoopsConfig['adminmail']);
				$xoopsMailer->setFromName($myxoopsConfig['sitename']);
				$xoopsMailer->setSubject(_MD_USER_MESSAGE_ACTIVATE_TIMEOUT);
				$xoopsMailer->send();
				
				$ret = '';
				XCube_DelegateUtils::call('Legacy_Workflow.AutoReject', new XCube_Ref($ret), Xoonips_Enum::certifyUsers(), $uid);
				return false;
			}
		}

		if (!$userBean->certifiyUser($user)) {
			return false;
		}		
		$sendToUsers = array();
		XCube_DelegateUtils::call('Legacy_Workflow.GetAllCertifyUsers', Xoonips_Enum::certifyUsers(), new XCube_Ref($sendToUsers));
		$this->notification->accountCertified($uid, $sendToUsers, $comment);
		//enent_log
		XCube_DelegateUtils::call('Module.User.Event.User.Certify', $xoopsUser);
		
		//send mail to user
	 	$xoopsMailer =& getMailer();
	 	$xoopsMailer->useMail();
	 	$xoopsMailer->setTemplateDir(Xoonips_Utils::mailTemplateDir($this->dirname, $this->trustDirname));
	 	$xoopsMailer->setTemplate('user_account_certified_notify_for_user.tpl');
	 	$xoopsMailer->assign('SITENAME', $myxoopsConfig['sitename']);
	 	$xoopsMailer->assign('ADMINMAIL', $myxoopsConfig['adminmail']);
	 	$xoopsMailer->assign('SITEURL', XOOPS_URL . '/');
		$xoopsMailer->assign('USER_UNAME', $user['uname']);
	    $xoopsMailer->assign('USER_DIVISION', $user['division']);
	    $xoopsMailer->assign('USER_NAME', $user['name']);
	    $xoopsMailer->assign('USER_EMAIL', $user['email']);
	    $xoopsMailer->assign('USER_COMPANY_NAME', $user['company']);
	    $xoopsMailer->assign('USER_ADDRESS', $user['user_from']);
	    $xoopsMailer->assign('USER_COUNTRY', $user['country']); 
	    $xoopsMailer->assign('USER_DETAIL_URL', XOOPS_URL . '/userinfo.php?uid=' . $uid);
		if (isset($_SESSION['xoopsUserId'])) {
			$certifyUserInfo = $userBean->getUserBasicInfo($_SESSION['xoopsUserId']);
			$certifyUser = $certifyUserInfo['uname'];
		} else {
			$certifyUser = '';
		}
		$xoopsMailer->assign('CERTIFY_USER', $certifyUser);
	 	$xoopsMailer->setToUsers(new XoopsUser($uid));
	 	$xoopsMailer->setFromEmail($myxoopsConfig['adminmail']);
	 	$xoopsMailer->setFromName($myxoopsConfig['sitename']);
	 	$xoopsMailer->setSubject(_MD_USER_MESSAGE_ACCOUNT_CERTIFIED_NOTIFYSBJ);
	 	if ($xoopsMailer->send()) {
	 		$result[1] = _MD_USER_MESSAGE_ACTIVATED_BY_ADMIN_CERTIFIED_AUTO;
	 	} else {
	 		$result[1] = _MD_USER_MESSAGE_ACTIVATED_BY_ADMIN_CERTIFIED_AUTO_MAILNG;
	 	}
		$result[0] = true;	
	}

	public function doProgress($uid, &$result, $comment) {
		$sendToUsers = array();
		XCube_DelegateUtils::call('Legacy_Workflow.GetCurrentCertifyUsers', Xoonips_Enum::certifyUsers(), $uid, new XCube_Ref($sendToUsers));
	    $this->notification->accountCertifyRequest($uid, $sendToUsers);
   		$result[0] = true;
	}

	public function doRefuse($uid, &$result, $comment) {
		$result[0] = false;
		$userBean = Xoonips_BeanFactory::getBean('UsersBean', $this->dirname, $this->trustDirname);
		$user = $userBean->getUserBasicInfo($uid);
		if (!$user) {
			return;
		}
		/*$result = array();
		XCube_DelegateUtils::call('Module.User.GetMessageSign', new XCube_Ref($result));
		foreach ($result as $messageSign) {
			$myxoopsConfig = $messageSign;
		}*/
		$myxoopsConfig = Xoonips_Utils::getXoopsConfigs(XOOPS_CONF);
		if (!$userBean->deleteUsers($uid)) {
			return false;
		}
		if (!$userBean->deleteGroupsUsersByUid($uid)) {
			return false;
		}
		$groupUserLinkBean = Xoonips_BeanFactory::getBean('GroupsUsersLinkBean', $this->dirname, $this->trustDirname);
		if (!$groupUserLinkBean->deleteByUid($uid)) {
			return false;
		}

		$xoopsUser = new XoopsUser($uid);
		global $xoopsDB;
		$tblName = $xoopsDB->prefix($this->dirname . '_field_detail');
		$sql = "select table_name from $tblName where table_name<>'users'";
		$sqlResult = $xoopsDB->queryF($sql);
		if (!$sqlResult) {
			return false;
		}
		while ($row = $xoopsDB->fetchArray($sqlResult)) {
			$tableName = $row['table_name'];
			if (strPos($tableName, $this->dirname . '_extend') !== false) {
				if (!$userBean->deleteUserExtend($tableName, $uid)) {
					return false;
				}
			}
		}
		$sendToUsers = array();
		XCube_DelegateUtils::call('Legacy_Workflow.GetAllCertifyUsers', Xoonips_Enum::certifyUsers(), new XCube_Ref($sendToUsers));
		$this->notification->accountUncertified($user, $sendToUsers, $comment);
		
		XCube_DelegateUtils::call('Module.User.Event.User.Delete', $xoopsUser);
		XCube_DelegateUtils::call('Module.User.Event.User.Reject', $xoopsUser);
		//
	    // notify a uncertified to the user by e-mail
	    //
	    $xoopsMailer =& getMailer();
	    $xoopsMailer->useMail();
	    $xoopsMailer->setTemplateDir(Xoonips_Utils::mailTemplateDir($this->dirname, $this->trustDirname));
	    $xoopsMailer->setTemplate('user_account_uncertified_notify.tpl');
	    $xoopsMailer->assign('SITENAME', $myxoopsConfig['sitename']);
	    $xoopsMailer->assign('ADMINMAIL', $myxoopsConfig['adminmail']);
	    $xoopsMailer->assign('SITEURL', XOOPS_URL . '/');
	    $xoopsMailer->assign('UNCERTIFY_COMMENT', $comment);
	    $xoopsMailer->assign('USER_UNAME', $user['uname']);
	    $xoopsMailer->assign('USER_DIVISION', $user['division']);
	    $xoopsMailer->assign('USER_NAME', $user['name']);
	    $xoopsMailer->assign('USER_EMAIL', $user['email']);
	    $xoopsMailer->assign('USER_COMPANY_NAME', $user['company_name']);
	    $xoopsMailer->assign('USER_ADDRESS', $user['user_from']);
	    $xoopsMailer->assign('USER_COUNTRY', $user['country']);      
		if (isset($_SESSION['xoopsUserId'])) {
			$certifyUserInfo = $userBean->getUserBasicInfo($_SESSION['xoopsUserId']);
			$certifyUser = $certifyUserInfo['uname'];
		} else {
			$certifyUser = '';
		}
		$xoopsMailer->assign('CERTIFY_USER', $certifyUser);
	    $xoopsMailer->setToEmails(array($user['email']));
	    $xoopsMailer->setFromEmail($myxoopsConfig['adminmail']);
	    $xoopsMailer->setFromName($myxoopsConfig['sitename']);
	    $xoopsMailer->setSubject(_MD_USER_MESSAGE_ACCOUNT_REJECTED_NOTIFYSBJ);
		if ($xoopsMailer->send()) {
	 		$result[1] = _MD_USER_MESSAGE_MODERATOR_UNCERTIFY_SUCCESS;
	 	} else {
	 		$result[1] = sprintf(_US_ACTVMAILNG, $user['uname']);
	 	}
		$result[0] = true;
	}

	public function getDetailView($uid) {
		$user = User_User::getInstance();
		$user->setId($uid);
		$xoopsUserId = 0;
		if (isset($_SESSION['xoopsUserId'])) {
			$xoopsUserId = $_SESSION['xoopsUserId'];
		}
		global $xoopsTpl;
		$xoopsTpl->assign('detailView', $user->getDetailViewForCertify($uid, $xoopsUserId));
		return $xoopsTpl->fetch('db:' . $this->dirname . '_workflow.html');
	}
}

