<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanBase.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Utils.class.php';

/**
 * @brief operate xoonips_user_field_detail_complement_link table
 *
 */
class Xoonips_UserFieldDetailComplementLinkBean extends Xoonips_BeanBase {

	/**
	 * Constructor
	 **/
	public function Xoonips_UserFieldDetailComplementLinkBean($dirname, $trustDirname) {
		$this->Xoonips_BeanBase($dirname, $trustDirname);
		$this->setTableName('user_field_detail_complement_link', false);
	}

	/**
	 * insert user field detail complement link
	 *
	 * @param  $info: user field detail complement link info
	 * @return boolean  true:success,false:failed
	 */
	function insert($info) {
		$sql = "INSERT INTO $this->table (released, complement_id, base_user_detail_id, complement_detail_id, user_detail_id, update_id)";
		$sql .= ' VALUES (' . Xoonips_Utils::convertSQLNum($info['released']) . ','
			. Xoonips_Utils::convertSQLNum($info['complement_id']) . ','
			. Xoonips_Utils::convertSQLNum($info['base_user_detail_id']) . ','
			. Xoonips_Utils::convertSQLNum($info['complement_detail_id']) . ','
			. Xoonips_Utils::convertSQLNum($info['user_detail_id']) . ','
			. Xoonips_Utils::convertSQLNum($info['update_id']) . ')';
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return true;
	}

	/**
	 * delete by detail id
	 *
	 * @param  $detail_id,
	 * @return boolean  true:success,false:failed
	 */
	public function deleteByBothDetailId($detailId) {
		$sql = "DELETE FROM $this->table WHERE base_user_detail_id=$detailId OR user_detail_id=$detailId";
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return true;
	}

	/**
	 * delete by usertypeid
	 *
	 * @param  $usertypeid,
	 * @return boolean  true:success,false:failed
	 */
	public function deleteByUsertypeId($usertypeid) {
		$sql = "DELETE FROM $this->table WHERE user_type_id=$usertypeid" ;
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return true;
	}

	// get relation detail and detail ralation
	public function getComplementDetailAndDetailLink($complementId, $baseid) {
		$detailTable = $this->prefix($this->modulePrefix('complement_detail'));
		$sql = "SELECT rd.complement_detail_id, rd.complement_id, rd.title, dr.user_detail_id "
			." FROM " . $detailTable . " rd , " . $this->table . " dr WHERE rd.complement_detail_id=dr.complement_detail_id "
			." AND rd.complement_id=dr.complement_id AND rd.complement_id=" . $complementId
			." AND dr.base_user_detail_id=" . $baseid." ORDER BY rd.complement_detail_id";
		$result = $this->execute($sql);
		$ret = array();
		if (!$result) {
			return $ret;
		}
		while ($row = $this->fetchArray($result)) {
			$ret[] = $row;
		}
		$this->freeRecordSet($result);
		return $ret;
	}

	public function getInfoByUsertypeIdAndComplementId($usertypeid, $complementId, $basedetailid) {
		$sql = "SELECT * FROM " . $this->table . " WHERE user_type_id=".$usertypeid
			. " AND complement_id=" . $complementId . " AND base_user_detail_id=" . $basedetailid;
		$result = $this->execute($sql);
		$ret = array();
		if (!$result) {
			return $ret;
		}
		while ($row = $this->fetchArray($result)) {
			$ret[] = $row;
		}
		$this->freeRecordSet($result);
		return $ret;
	}

	/**
	 * do copy by id
	 *
	 * @param  $usertypeId, $map
	 * @return boolean true:success,false:failed
	 */
	public function copyById($usertypeId, &$map, $update = false, $import = false) {

		// get copy information
		$complementObj = $this->getFieldDetailComplementByUsertypeId($usertypeId);
		if ($complementObj === false) return false;

		// do copy by obj
		return $this->copyByObj($complementObj, $map, $update, $import);
	}

	/**
	 * do copy by obj
	 *
	 * @param  $complementObj, $map
	 * @return boolean true:success,false:failed
	 */
	public function copyByObj($complementObj, &$map, $update, $import) {

		// insert copy
		foreach ($complementObj as $complement) {

			$complement['released'] = $import ? $complement['released'] : 0;
			$complement['user_type_id'] = $map['usertype'][$complement['user_type_id']];
			$complement['base_user_detail_id'] = $map['detail'][$complement['base_user_detail_id']];
			$complement['user_detail_id'] =  $map['detail'][$complement['user_detail_id']];
			$complement['update_id'] = $update ? $complement['seq_id'] : NULL;
			if (!$this->insert($complement)) return false;
		}
		return true;
	}

	/**
	 * do copy by id
	 *
	 * @param  $usertypeId, $map
	 * @return boolean true:success,false:failed
	 */
	public function copyByIdNG($userfieldId, &$map, $update = false, $import = false) {

		// get copy information
		$complementObj = $this->getFieldDetailComplementByUserfieldId($userfieldId);
		if ($complementObj === false) return false;

		// do copy by obj
		return $this->copyByObjNG($complementObj, $map, $update, $import);
	}

	/**
	 * do copy by obj
	 *
	 * @param  $complementObj, $map
	 * @return boolean true:success,false:failed
	 */
	public function copyByObjNG($complementObj, &$map, $update, $import) {

		// insert copy
		foreach ($complementObj as $complement) {

			$complement['released'] = $import ? $complement['released'] : 0;
			$complement['base_user_detail_id'] = $map['detail'][$complement['base_user_detail_id']];
			$complement['user_detail_id'] =  $map['detail'][$complement['user_detail_id']];
			$complement['update_id'] = $update ? $complement['seq_id'] : NULL;
			if (!$this->insert($complement)) return false;
		}
		return true;
	}

	/**
	 * get UserFieldDetailComplementLink
	 *
	 * @param int $userfieldId:userfield id
	 * @return array
	 */
	function getFieldDetailComplementByUserfieldId($userfieldId) {
		$sql = "SELECT * FROM $this->table WHERE user_detail_id=$userfieldId order by seq_id";
		$result = $this->execute($sql);
		if (!$result) return false;
		$ret = array();
		while ($row = $this->fetchArray($result)) {
			$ret[] = $row;
		}
		$this->freeRecordSet($result);
		return $ret;
	}

}
?>
