<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XLEPROGRESS_TRUST_PATH . '/class/AbstractListAction.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/Enum.class.php';

/**
 * Xleprogress_ApprovalListAction
**/
class Xleprogress_ApprovalListAction extends Xleprogress_AbstractListAction
{
	/**
	 * &_getHandler
	 * 
	 * @param	void
	 * 
	 * @return	Xleprogress_ApprovalHandler
	**/
	protected function &_getHandler()
	{
		$handler =& $this->mAsset->getObject('handler', 'Approval');
		return $handler;
	}

	/**
	 * &_getFilterForm
	 * 
	 * @param	void
	 * 
	 * @return	Xleprogress_ApprovalFilterForm
	**/
	protected function &_getFilterForm()
	{
		$filter =& $this->mAsset->getObject('filter', 'Approval',false);
		$filter->prepare($this->_getPageNavi(), $this->_getHandler());
		return $filter;
	}

	/**
	 * getDefaultView
	 * 
	 * @param	void
	 * 
	 * @return	Enum
	**/
	public function getDefaultView()
	{
		$list = array();
		$typeHandler =& $this->mAsset->getObject('handler', 'type');
		$list = $typeHandler->getTypeList();
		$handler = $this->_getHandler();
		foreach($list as $type){
			$cri = new CriteriaCompo();
			$cri->add(new Criteria('type_id', $type->get('type_id')));
			$cri->setSort('step', 'ASC');
			$objs = $handler->getObjects($cri);
			if(count($objs)==0){
				$objs = array();
				$objs[0] = $handler->create();
				$objs[0]->set('type_id', $type->get('type_id'));
			}
			$this->mObjects[] = $objs;
		}
		return XLEPROGRESS_FRAME_VIEW_INDEX;
	}

	/**
	 * _getBaseUrl
	 * 
	 * @param	void
	 * 
	 * @return	string
	**/
	protected function _getBaseUrl()
	{
		return './index.php?action=ApprovalList';
	}

	/**
	 * executeViewIndex
	 * 
	 * @param	XCube_RenderTarget	&$render
	 * 
	 * @return	void
	**/
	public function executeViewIndex(/*** XCube_RenderTarget ***/ &$render)
	{
		$render->setTemplateName($this->mAsset->mDirname . '_approval_list.html');
		foreach($this->mObjects as $obj){
			$obj[0]->loadType();
			foreach($obj as $o){
				$o->loadGroup();
			}
		}
		$render->setAttribute('objects', $this->mObjects);
		$render->setAttribute('dirname', $this->mAsset->mDirname);
		$render->setAttribute('xleprogressGroup', Xoonips_Enum::XLEPROGRESS_GROUP);		
	}
}
?>
