CREATE TABLE {prefix}_{dirname}_mailjob (
  mailjob_id int(10) NOT NULL auto_increment,
  title varchar(255) NOT NULL default '',
  body text NOT NULL,
  from_name varchar(255) default NULL,
  from_email varchar(255) default NULL,
  is_pm tinyint(1) NOT NULL default '0',
  is_mail tinyint(1) NOT NULL default '0',
  create_unixtime int(10) NOT NULL default '0',
  PRIMARY KEY (mailjob_id)
) ENGINE=MyISAM;

CREATE TABLE {prefix}_{dirname}_mailjob_link (
  mailjob_id int(10) NOT NULL default '0',
  uid mediumint(8) NOT NULL default '0',
  retry tinyint(3) NOT NULL default '0',
  message varchar(255) default NULL,
  PRIMARY KEY (mailjob_id, uid)
) ENGINE=MyISAM;
# --------------------------------------------------------
DROP TABLE IF EXISTS `{prefix}_{dirname}_data_type`;
DROP TABLE IF EXISTS `{prefix}_{dirname}_view_type`;
DROP TABLE IF EXISTS `{prefix}_{dirname}_view_data_relation`;
DROP TABLE IF EXISTS `{prefix}_{dirname}_field_group`;
DROP TABLE IF EXISTS `{prefix}_{dirname}_field_detail`;
DROP TABLE IF EXISTS `{prefix}_{dirname}_field_value_set`;
DROP TABLE IF EXISTS `{prefix}_{dirname}_complement`;
DROP TABLE IF EXISTS `{prefix}_{dirname}_complement_detail`;
DROP TABLE IF EXISTS `{prefix}_{dirname}_field_detail_complement_link`;

# --------------------------------------------------------

#
# ADD column for table `groups`
#

ALTER TABLE `{prefix}_groups`
 ADD `activate` tinyint(1) unsigned NOT NULL default '0' AFTER `groupid`,
 ADD `icon` varchar(255) default NULL AFTER `description`,
 ADD `mime_type` varchar(255) default NULL AFTER `icon`,
 ADD `is_public` tinyint(1) unsigned NOT NULL default '0' AFTER `mime_type`,
 ADD `can_join` tinyint(1) unsigned NOT NULL default '0' AFTER `is_public`,
 ADD `is_hidden` tinyint(1) unsigned NOT NULL default '0' AFTER `can_join`,
 ADD `member_accept` tinyint(1) unsigned NOT NULL default '0' AFTER `is_hidden`,
 ADD `item_accept` tinyint(1) unsigned NOT NULL default '0' AFTER `member_accept`,
 ADD `item_number_limit` int(10) unsigned default NULL AFTER `item_accept`,
 ADD `index_number_limit` int(10) unsigned default NULL AFTER `item_number_limit`,
 ADD `item_storage_limit` int(10) default NULL AFTER `index_number_limit`,
 ADD `index_id` int(10) unsigned NOT NULL default '0' AFTER `item_storage_limit`;

# --------------------------------------------------------

#
# ADD column for table `groups_users_link`
#

ALTER TABLE `{prefix}_groups_users_link`
 ADD `activate` tinyint(1) unsigned NOT NULL default '0' AFTER `linkid`,
 ADD `is_admin` tinyint(1) unsigned NOT NULL default '0';

# --------------------------------------------------------

#
# Table structure for table `{prefix}_{dirname}_data_type`
#

CREATE TABLE `{prefix}_{dirname}_data_type` (
  `data_type_id` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(30) NOT NULL,
  `module` varchar(255) default NULL,
  PRIMARY KEY (`data_type_id`)
) ENGINE=InnoDB;

# --------------------------------------------------------

#
# Table structure for table `{prefix}_{dirname}_view_type`
#

CREATE TABLE `{prefix}_{dirname}_view_type` (
  `view_type_id` int(10) unsigned NOT NULL auto_increment,
  `preselect` tinyint(1) unsigned NOT NULL default '0',
  `multi` tinyint(1) unsigned NOT NULL default '0',
  `name` varchar(30) NOT NULL,
  `module` varchar(255) default NULL,
  PRIMARY KEY (`view_type_id`)
) ENGINE=InnoDB;

# --------------------------------------------------------

#
# Table structure for table `{prefix}_{dirname}_view_data_relation`
#

CREATE TABLE `{prefix}_{dirname}_view_data_relation` (
  `view_type_id` int(10) unsigned NOT NULL default '0',
  `data_type_id` int(10) unsigned NOT NULL default '0',
  `data_length` smallint(5) NOT NULL default '0',
  `data_decimal_places` tinyint(2) NOT NULL default '0',
  PRIMARY KEY `view_type_id` (`view_type_id`, `data_type_id`)
) ENGINE=InnoDB;

# --------------------------------------------------------

#
# Table structure for table `user_field_group`
#

CREATE TABLE `{prefix}_{dirname}_field_group` (
  `group_id` int(10) unsigned NOT NULL auto_increment,
  `preselect` tinyint(1) unsigned NOT NULL default '0',
  `released` tinyint(1) unsigned NOT NULL default '0',
  `weight` smallint(3) unsigned NOT NULL,
  `name` varchar(255) NOT NULL default '',
  `xml` varchar(30) NOT NULL default '',
  `occurrence` tinyint(1) NOT NULL default '0',
  `update_id` int(10) unsigned default NULL,
  PRIMARY KEY (`group_id`),
  KEY `update_id` (`update_id`)
) ENGINE=InnoDB;

# --------------------------------------------------------

#
# Table structure for table `user_field_detail`
#

CREATE TABLE `{prefix}_{dirname}_field_detail` (
  `user_detail_id` int(10) unsigned NOT NULL auto_increment,
  `preselect` tinyint(1) unsigned NOT NULL default '0',
  `released` tinyint(1) unsigned NOT NULL default '0',
  `table_name` varchar(50) NOT NULL default '',
  `column_name` varchar(50) NOT NULL default '',
  `group_id` int(10) unsigned NOT NULL,
  `weight` smallint(3) unsigned NOT NULL,
  `name` varchar(255) NOT NULL default '',
  `xml` varchar(30) NOT NULL default '',
  `view_type_id` int(10) unsigned NOT NULL,
  `data_type_id` int(10) unsigned NOT NULL,
  `data_length` smallint(5) NOT NULL default '0',
  `data_decimal_places` tinyint(2) NOT NULL default '0',
  `default_value` varchar(100) default NULL,
  `list` varchar(50) default NULL,
  `essential` tinyint(1) unsigned NOT NULL default '0',
  `list_display` tinyint(1) unsigned NOT NULL default '0',
  `list_sort_key` tinyint(1) unsigned NOT NULL default '0',
  `list_width` smallint(3) unsigned NOT NULL default '0',
  `detail_display` tinyint(1) unsigned NOT NULL default '0',
  `registry_user` tinyint(1) unsigned NOT NULL default '0',
  `edit_user` tinyint(1) unsigned NOT NULL default '0',
  `target_user` tinyint(1) unsigned NOT NULL default '0',
  `scope_search` tinyint(1) unsigned NOT NULL default '0',
  `nondisplay` tinyint(1) unsigned NOT NULL default '0',
  `update_id` int(10) unsigned default NULL,
  PRIMARY KEY (`user_detail_id`),
  KEY `weight` (`group_id`, `weight`),
  KEY `update_id` (`update_id`)
) ENGINE=InnoDB;

# --------------------------------------------------------

#
# Table structure for table `user_field_value_set`
#

CREATE TABLE `{prefix}_{dirname}_field_value_set` (
  `select_name` varchar(50) NOT NULL default '',
  `title_id` varchar(30) NOT NULL default '',
  `title` varchar(255) NOT NULL default '',
  `weight` smallint(3) NOT NULL default '0',
  PRIMARY KEY (`select_name`, `title_id`),
  KEY `select_name` (`select_name`, `weight`)
) ENGINE=MyISAM;

# --------------------------------------------------------

#
# Table structure for table `{prefix}_{dirname}_complement`
#

CREATE TABLE `{prefix}_{dirname}_complement` (
  `complement_id` int(10) unsigned NOT NULL auto_increment,
  `view_type_id` int(10) unsigned NOT NULL default '0',
  `title` varchar(30) NOT NULL default '',
  `module` varchar(255) default NULL,
  PRIMARY KEY (`complement_id`),
  KEY `view_type_id` (`view_type_id`)
) ENGINE=InnoDB;

# --------------------------------------------------------

#
# Table structure for table `{prefix}_{dirname}_complement_detail`
#

CREATE TABLE `{prefix}_{dirname}_complement_detail` (
  `complement_detail_id` int(10) unsigned NOT NULL auto_increment,
  `complement_id` int(10) unsigned NOT NULL default '0',
  `code` varchar(30) NOT NULL default '',
  `title` varchar(255) NOT NULL default '',
  PRIMARY KEY (`complement_detail_id`),
  KEY `complement_id` (`complement_id`, `complement_detail_id`)
) ENGINE=InnoDB;

# --------------------------------------------------------

#
# Table structure for table `{prefix}_{dirname}_field_detail_complement_link`
#

CREATE TABLE `{prefix}_{dirname}_field_detail_complement_link` (
  `seq_id` int(10) unsigned NOT NULL auto_increment,
  `complement_id` int(10) unsigned NOT NULL default '0',
  `base_user_detail_id` int(10) unsigned NOT NULL default '0',
  `complement_detail_id` int(10) unsigned NOT NULL default '0',
  `user_detail_id` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY (`seq_id`)
) ENGINE=InnoDB;

# --------------------------------------------------------

#
# Table structure for table `{prefix}_{dirname}_field_group_field_detail_link`
#

CREATE TABLE `{prefix}_{dirname}_field_group_field_detail_link` (
  `user_field_group_field_detail_id` int(10) unsigned NOT NULL auto_increment,
  `group_id` int(10) unsigned NOT NULL default '0',
  `user_detail_id` int(10) unsigned NOT NULL default '0',
  `edit_weight` smallint(3) unsigned NOT NULL,
  `edit` tinyint(1) unsigned NOT NULL default '0',
  `weight` smallint(3) unsigned NOT NULL,
  `released` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY (`user_field_group_field_detail_id`)
) ENGINE=InnoDB;

