<?php

require_once XOOPS_ROOT_PATH . "/header.php";
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Request.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Response.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Utils.class.php';

Xoonips_Utils::loadMessage(Xoonips_Utils::getDirname());
Xoonips_Utils::denyGuestAccess();
$request = new Xoonips_Request();
$response = new Xoonips_Response();

$actionName = $request->getParameter('action');
if($actionName==null){
	$actionName = "default";
}

$op = $request->getParameter('op');
if ($op == null) {
	$op = 'init';
}
// user search
if($actionName=="userSearch"){		
	// check request
	if (!in_array($op, array('init', 'search', 'sort'))) {
	    die('illegal reuest');
	}
	
	// set action map
	$actionMap = array();
	$actionMap['init_success'] = 'user_search.html';
	$actionMap['success'] = 'user_list.html';
	$actionMap['inputError'] = 'user_search.html';
	require_once 'actions/UserSearchAction.class.php';
	//do action
	$action = new User_UserSearchAction();
	$action->doAction($request, $response);
	
	// forward
	$response->forward($actionMap);
}
else if($actionName=="userInfo"){	
	require_once USER_TRUST_PATH . "/class/ActionFrame.class.php";
	$root =& XCube_Root::getSingleton();
	$moduleRunner = new User_ActionFrame(false);
	$moduleRunner->setActionName("UserInfo");	
	$root->mController->mExecute->add(array(&$moduleRunner, 'execute'));	
	$root->mController->execute();		
}
else if($actionName=="userSu"){			
	// check op request
	if (!in_array($op, array('init', 'su', 'end'))) {
		die('illegal reuest');
	}	
	// set action map
	$actionMap = array();
	$actionMap['init_success'] = 'user_su.html';
	require_once 'actions/UserSuAction.class.php';
	//do action
	$action = new User_UserSuAction();
	$action->doAction($request, $response);	
	// forward
	$response->forward($actionMap);
}
else if($actionName=="userActivate"){	
	require_once USER_TRUST_PATH . "/class/ActionFrame.class.php";
	$root =& XCube_Root::getSingleton();
	$moduleRunner = new User_ActionFrame(false);
	$moduleRunner->setActionName("UserActivate");	
	$root->mController->mExecute->add(array(&$moduleRunner, 'execute'));	
	$root->mController->execute();		
}
else if($actionName=="groupList"){			
	// check request
	if (!in_array($op, array('init', 'join', 'leave', 'delete'))) {
		die('illegal reuest');
	}	
	// set action map
	$actionMap['init_success'] = 'user_grouplist.html';
	$actionMap['join_success'] = 'redirect_header';
	$actionMap['leave_success'] = 'redirect_header';
	$actionMap['delete_success'] = 'redirect_header';
	require_once 'actions/GroupListAction.class.php';
	//do action
	$action = new User_GroupListAction();
	$action->doAction($request, $response);	
	// forward
	$response->forward($actionMap);
}
else if($actionName=="groupRegister"){			
	// check request
	if (!in_array($op, array('init', 'search', 'register'))) {
		die('illegal reuest');
	}
	
	// set action map
	$actionMap['init_success'] = 'user_groupregister.html';
	$actionMap['search_success'] = 'user_groupregister.html';
	$actionMap['input_error'] = 'user_groupregister.html';
	$actionMap['register_success'] = 'redirect_header';
	require_once 'actions/GroupRegisterAction.class.php';
	//do action
	$action = new User_GroupRegisterAction();
	$action->doAction($request, $response);	
	// forward
	$response->forward($actionMap);
}
else if($actionName=="groupEdit"){			
	// check request
	if (!in_array($op, array('init', 'search', 'update'))) {
		die('illegal reuest');
	}
	
	// set action map
	$actionMap['init_success'] = 'user_groupedit.html';
	$actionMap['search_success'] = 'user_groupedit.html';
	$actionMap['input_error'] = 'user_groupedit.html';
	$actionMap['update_success'] = 'redirect_header';
	require_once 'actions/GroupEditAction.class.php';
	//do action
	$action = new User_GroupEditAction();
	$action->doAction($request, $response);	
	// forward
	$response->forward($actionMap);
}
else if($actionName=="groupMember"){			
	// check request
	if (!in_array($op, array('init', 'search', 'update'))) {
		die('illegal reuest');
	}
	
	// set action map
	$actionMap['init_success'] = 'user_groupmember.html';
	$actionMap['search_success'] = 'user_groupmember.html';
	$actionMap['input_error'] = 'user_groupmember.html';
	$actionMap['update_success'] = 'redirect_header';
	require_once 'actions/GroupMemberAction.class.php';
	//do action
	$action = new User_GroupMemberAction();
	$action->doAction($request, $response);	
	// forward
	$response->forward($actionMap);
}
else if($actionName=="groupInfo"){			
	// check request
	if (!in_array($op, array('init'))) {
		die('illegal reuest');
	}
	
	// set action map
	$actionMap['init_success'] = 'user_groupinfo.html';
	require_once 'actions/GroupInfoAction.class.php';
	//do action
	$action = new User_GroupInfoAction();
	$action->doAction($request, $response);	
	// forward
	$response->forward($actionMap);
}
else{
	require_once USER_TRUST_PATH . "/class/ActionFrame.class.php";
	$root =& XCube_Root::getSingleton();
	$moduleRunner = new User_ActionFrame(false);
	$moduleRunner->setActionName($actionName);	
	$root->mController->mExecute->add(array(&$moduleRunner, 'execute'));	
	$root->mController->execute();		
}
require_once XOOPS_ROOT_PATH . "/footer.php";
?>
