<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/WorkflowBase.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanFactory.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/WorkflowFactory.class.php';
require_once dirname(dirname(__FILE__)) . '/core/User.class.php';

class User_WorkflowGroupOpen extends Xoonips_WorkflowBase {

	public function doCertify($gid, &$result, $comment) {
		$result[0] = false;
		$groupBean = Xoonips_BeanFactory::getBean('GroupsBean', $this->dirname, $this->trustDirname);
		if (!$groupBean->groupsOpen($gid)) {
			return false;
		}
		$group_handler =& xoops_gethandler('group');
		$xoopsGroup = $group_handler->get($gid);
		$result[0] = true;
		//event log
		$user = User_User::getInstance();
		$user->doGroupOpened($gid, $xoopsGroup, false, $comment);	
	}

	public function doProgress($gid, &$result, $comment) {
		$sendToUsers = array();
		XCube_DelegateUtils::call('Legacy_Workflow.GetCurrentCertifyUsers', Xoonips_Enum::certifyGroupOpen(), $gid, new XCube_Ref($sendToUsers));
		$this->notification->groupOpenRequest($gid, $sendToUsers);
		$result[0] = true;
	}

	public function doRefuse($gid, &$result, $comment) {
		$result[0] = false;
		$groupBean = Xoonips_BeanFactory::getBean('GroupsBean', $this->dirname, $this->trustDirname);
		if (!$groupBean->groupsClose($gid)) {
			return false;
		}
		$group_handler =& xoops_gethandler('group');
		$xoopsGroup = $group_handler->get($gid);
		$result[0] = true;
		//event log
		XCube_DelegateUtils::call('Module.User.Event.Group.OpenReject', $xoopsGroup);

		//send to group admins and certifyUsers
		$groupUserLinkBean = Xoonips_BeanFactory::getBean('GroupsUsersLinkBean', $this->dirname, $this->trustDirname);
		foreach ($groupUserLinkBean->getAdminUserIds($gid) as $id) {
			$sendToUsers[$id] = $id; 
		}
		XCube_DelegateUtils::call('Legacy_Workflow.GetAllCertifyUsers', Xoonips_Enum::certifyGroupOpen(), new XCube_Ref($sendToUsers));
		$this->notification->groupOpenRejected($gid, $sendToUsers, $comment);
	}
	
	public function getDetailView($gid) {
		$workflow = Xoonips_WorkflowFactory::getWorkflow('WorkflowGroupRegister', $this->dirname, $this->trustDirname);
		return $workflow->getDetailView($gid);
	}	
}
?>
