<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/WorkflowBase.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanFactory.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/WorkflowFactory.class.php';
require_once dirname(dirname(__FILE__)) . '/core/User.class.php';

class User_WorkflowGroupJoin extends Xoonips_WorkflowBase {
	
	public function doCertify($linkId, &$result, $comment) {
		$result[0] = false;
		$groupsUsersLinkBean = null;
		list($gid, $uid) = $this->getTargetGroupId($linkId, $groupsUsersLinkBean);
		if ($uid == 0 || !$groupsUsersLinkBean->certify($gid, $uid)) {
			return false;
		}
		$result[0] = true;
		$group_handler =& xoops_gethandler('group');
		$xoopsGroup = $group_handler->get($gid);
		//event log
		$user = User_User::getInstance();
		$user->doGroupJoined($gid, $uid, $xoopsGroup, false, $comment);
	}

	public function doProgress($linkId, &$result, $comment) {
		$result[0] = false;
		$groupsUsersLinkBean = null;
		list($gid, $uid) = $this->getTargetGroupId($linkId, $groupsUsersLinkBean);
		if ($uid == 0) {
			return false;
		}
		$sendToUsers = array();
		XCube_DelegateUtils::call('Legacy_Workflow.GetCurrentCertifyUsers', Xoonips_Enum::certifyGroupJoin(), $linkId, new XCube_Ref($sendToUsers));
		$this->notification->groupJoinRequest($gid, $uid, $sendToUsers);
		$result[0] = true;
	}
	
	public function doRefuse($linkId, &$result, $comment) {
		$result[0] = false;
		$groupsUsersLinkBean = null;
		list($gid, $uid) = $this->getTargetGroupId($linkId, $groupsUsersLinkBean);
		if ($uid == 0 || !$groupsUsersLinkBean->delete($gid, $uid)) {
			return false;
		}

		$result[0] = true;

		$group_handler =& xoops_gethandler('group');
		$xoopsGroup = $group_handler->get($gid);
		$xoopsUser = new XoopsUser($uid);
		//event log
		XCube_DelegateUtils::call('Module.User.Event.Group.Member.JoinReject', $xoopsUser, $xoopsGroup);

		//send to group admins and certifyUsers
		$sendToUsers[$uid] = $uid;
		foreach ($groupsUsersLinkBean->getAdminUserIds($gid) as $id) {
			$sendToUsers[$id] = $id; 
		}
		XCube_DelegateUtils::call('Legacy_Workflow.GetAllCertifyUsers', Xoonips_Enum::certifyGroupJoin(), new XCube_Ref($sendToUsers));
		$this->notification->groupJoinRejected($gid, $uid, $sendToUsers, $comment);
	}
	
	public function getDetailView($linkId) {
		$groupsUsersLinkBean = null;
		list($gid, $uid) = $this->getTargetGroupId($linkId, $groupsUsersLinkBean);
		if ($uid == 0) {
			return false;
		}
		$user = User_User::getInstance();
		$user->setId($uid);
		$xoopsUserId = 0;
		if (isset($_SESSION['xoopsUserId'])) {
			$xoopsUserId = $_SESSION['xoopsUserId'];
		}
		global $xoopsTpl;
		$xoopsTpl->assign('detailView', $user->getDetailViewForCertify($uid, $xoopsUserId));
		return $xoopsTpl->fetch('db:' . $this->dirname . '_workflow.html');
	}
	
	public function getTargetGroupId($linkId, &$groupsUsersLinkBean) {
		$groupsUsersLinkBean = Xoonips_BeanFactory::getBean('GroupsUsersLinkBean', $this->dirname, $this->trustDirname);
		$row = $groupsUsersLinkBean->getGroupUserLinkInfoByLinkId($linkId);
		if (count($row) > 0) {
			return array($row['groupid'], $uid = $row['uid']);
		} else {
			return array(0, 0);
		}
	}
}
?>
