<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/WorkflowBase.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanFactory.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/WorkflowFactory.class.php';
require_once dirname(dirname(__FILE__)) . '/core/User.class.php';

class User_WorkflowGroupDelete extends Xoonips_WorkflowBase {

	public function doCertify($gid, &$result, $comment) {
		$result[0] = false;
		$groupBean = Xoonips_BeanFactory::getBean('GroupsBean', $this->dirname, $this->trustDirname);
		$group = $groupBean->getGroup($gid);	
		$group_handler =& xoops_gethandler('group');
		$xoopsGroup = $group_handler->get($gid);	
	
		$user = User_User::getInstance();
		$message = '';
		if (!$user->doGroupDeleted($group, $xoopsGroup, false, $message, $comment)) {
			$result[1] = $message;
			return false;
		}
		
		$result[0] = true;
	}

	public function doProgress($gid, &$result, $comment) {
		$sendToUsers = array();
		XCube_DelegateUtils::call('Legacy_Workflow.GetCurrentCertifyUsers', Xoonips_Enum::certifyGroupDelete(), $gid, new XCube_Ref($sendToUsers));
		$this->notification->groupDeleteRequest($gid, $sendToUsers);
		$result[0] = true;
	}

	public function doRefuse($gid, &$result, $comment) {
		$result[0] = false;
		$groupBean = Xoonips_BeanFactory::getBean('GroupsBean', $this->dirname, $this->trustDirname);
		$group_handler =& xoops_gethandler('group');
		$xoopsGroup = $group_handler->get($gid);
		if (!$groupBean->groupsCertify($gid)) {
			return false;
		}
		$result[0] = true;
		//event log
		XCube_DelegateUtils::call('Module.User.Event.Group.DeleteReject', $xoopsGroup);
		
		//send to group admins and certifyUsers
		$groupUserLinkBean = Xoonips_BeanFactory::getBean('GroupsUsersLinkBean', $this->dirname, $this->trustDirname);
		foreach ($groupUserLinkBean->getAdminUserIds($gid) as $id) {
			$sendToUsers[$id] = $id; 
		}
		XCube_DelegateUtils::call('Legacy_Workflow.GetAllCertifyUsers', Xoonips_Enum::certifyGroupDelete(), new XCube_Ref($sendToUsers));
		$this->notification->groupDeleteRejected($gid, $sendToUsers, $comment);
	}
	
	public function getDetailView($id) {
		$workflow = Xoonips_WorkflowFactory::getWorkflow('WorkflowGroupRegister', $this->dirname, $this->trustDirname);
		return $workflow->getDetailView($id);
	}
}
?>
