<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/ViewTypeText.class.php';

class User_ViewTypeMaximumIndexes extends Xoonips_ViewTypeText {

	public function setTemplate() {
		$this->template = $this->dirname . '_viewtype_maximumindexes.html';
	}

	public function getInputView($field, $value, $groupLoopId) {
		$fieldName = $this->getFieldName($field, $groupLoopId);
		$this->getXoopsTpl()->assign('viewType', 'input');
		$this->getXoopsTpl()->assign('len', $field->getLen());
		$this->getXoopsTpl()->assign('fieldName', $fieldName);
		$this->getXoopsTpl()->assign('value', $value);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}

	/**
	 *
	 * get registry view
	 *
	 * @param object $field
	 * @return array
	 */
	public function getRegistryView($field) {
		$result = array();
		XCube_DelegateUtils::call('Module.User.GetUserMaximumResources', new XCube_Ref($result), null);
		if (count($result) > 0) {
			foreach ($result as $key => $limit) {
				$value = $limit['indexNumberLimit'];
			}
		} else {
			$value = $field->getDefault();
		}
		return $this->getInputView($field, $value, 1);
	}

	public function getDisplayView($field, $value, $groupLoopId) {
		$data = '';
		if (is_array($value)) {
			foreach ($value as $v) {
				$data = $data . $v . ',';
			}
			$data = substr($data, 0, strlen($data) - 1);
		} else {
			$data = $value;
		}
		$fieldName = $this->getFieldName($field, $groupLoopId);
		$this->getXoopsTpl()->assign('viewType', 'confirm');
   		$this->getXoopsTpl()->assign('fieldName', $fieldName);
		$this->getXoopsTpl()->assign('value', $data);
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}
	
	public function getDetailDisplayView($field, $value, $display) {
		$data = '';
		if (is_array($value)) {
			foreach ($value as $v) {
				$data = $data . $v . ',';
			}
			$data = substr($data, 0, strlen($data) - 1);
		} else {
			$data = $value;
		}
   		$this->getXoopsTpl()->assign('viewType', 'detail');
   	    $this->getXoopsTpl()->assign('value', $data);   
		return $this->getXoopsTpl()->fetch('db:'. $this->template);
	}
}
?>
