<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanBase.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Utils.class.php';

/**
 * @brief operate user_field_detail_complement_link table
 *
 */
class User_FieldDetailComplementLinkBean extends Xoonips_BeanBase {

	/**
	 * Constructor
	 **/
	public function User_FieldDetailComplementLinkBean($dirname, $trustDirname) {
		$this->Xoonips_BeanBase($dirname, $trustDirname);
		$this->setTableName('field_detail_complement_link', true);
	}

	/**
	 * insert item field detail complement link
	 *
	 * @param  $info: item field detail complement link info
	 * @return boolean  true:success,false:failed
	 */
	function insert($info) {
		$sql = "INSERT INTO $this->table (complement_id, base_user_detail_id, complement_detail_id, user_detail_id)";
		$sql .= ' VALUES (' . Xoonips_Utils::convertSQLNum($info['complement_id']) . ','
			. Xoonips_Utils::convertSQLNum($info['base_user_detail_id']) . ','
			. Xoonips_Utils::convertSQLNum($info['complement_detail_id']) . ','
			. Xoonips_Utils::convertSQLNum($info['user_detail_id']) . ')';
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		return true;
	}

	/**
	 * do copy by obj
	 *
	 * @param  $complementObj, $map
	 * @return boolean true:success,false:failed
	 */
	public function copyByObj($complementObj, &$map, $update, $import) {

		// insert copy
		foreach ($complementObj as $complement) {

			$complement['released'] = $import ? $complement['released'] : 0;
			$complement['base_user_detail_id'] = $map['detail'][$complement['base_user_detail_id']];
			$complement['user_detail_id'] =  $map['detail'][$complement['user_detail_id']];
			$complement['update_id'] = $update ? $complement['seq_id'] : NULL;
			if (!$this->insert($complement)) return false;
		}
		return true;
	}
}
?>
