<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOOPS_ROOT_PATH . '/core/XCube_PageNavigator.class.php';
require_once USER_TRUST_PATH . '/admin/forms/GroupMemberEditForm.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanFactory.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/Errors.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/Enum.class.php';
require_once USER_TRUST_PATH . '/class/core/User.class.php';

if (!defined('USER_GROUPMEMBER_DEFAULT_PERPAGE')) {
	define ('USER_GROUPMEMBER_DEFAULT_PERPAGE', 10);
}

/***
 * @internal
 * This function keeps difficult problems that this depens on the column's
 * block of X2 theme format.
 */
class User_GroupMemberAction extends User_Action
{
	/**
	 * Target group object
	 * 
	 * @var UserGroupsObject
	 */
	var $mGroup = null;
	
	/**
	 * group member list.
	 */
	var $mUsers = array();
	var $mPageNavi = null;

	/**
	 * No group member list.
	 */
	var $mNoUsers = array();
	var $mNoPageNavi = null;
	
	var $mActionForm = null;

	function prepare(&$controller, &$xoopsUser, $moduleConfig)
	{
		//
		// TODO Because this action has two form, we should prepare two action forms.
		//
		$this->mActionForm = new User_GroupMemberEditForm();
		$this->mActionForm->prepare();
	}

	function getDefaultView(&$controller, &$xoopsUser)
	{
		$this->_loadGroup();
		if (!is_object($this->mGroup)) {
			return USER_FRAME_VIEW_ERROR;
		}

		$memberHandler =& xoops_gethandler('member');
		$groupid = $this->mGroup->getVar('groupid');

		//
		// Get member list
		//
		$total = $memberHandler->getUserCountByGroup($groupid);

		$this->mPageNavi = new XCube_PageNavigator("./index.php?action=GroupMember", XCUBE_PAGENAVI_START | XCUBE_PAGENAVI_PERPAGE);	// TODO get controller->getUrl() ?
		$this->mPageNavi->setTotalItems($total);
		$this->mPageNavi->addExtra('groupid', $groupid);
		$this->mPageNavi->setPerpage(USER_GROUPMEMBER_DEFAULT_PERPAGE);

		$this->mPageNavi->fetch();
		
		$this->mUsers =& $memberHandler->getUsersByGroup($groupid, true, $this->mPageNavi->getPerpage(), $this->mPageNavi->getStart());

		//
		// Get no member list
		//
		$total = $memberHandler->getUserCountByNoGroup($groupid);

		$this->mNoPageNavi=new XCube_PageNavigator("./index.php?action=GroupMember", XCUBE_PAGENAVI_START | XCUBE_PAGENAVI_PERPAGE);	// TODO get controller->getUrl() ?
		$this->mNoPageNavi->setTotalItems($total);
		$this->mNoPageNavi->addExtra('groupid', $groupid);
		$this->mNoPageNavi->setPrefix('no');
		$this->mNoPageNavi->setPerpage(USER_GROUPMEMBER_DEFAULT_PERPAGE);

		$this->mNoPageNavi->fetch();
		
		$this->mNoUsers =& $memberHandler->getUsersByNoGroup($groupid, true, $this->mNoPageNavi->getPerpage(), $this->mNoPageNavi->getStart());

		if ($this->mGroup->get('group_type') == Xoonips_Enum::GROUP_TYPE) {
			$userBean = Xoonips_BeanFactory::getBean('UsersBean', $this->dirname, $this->trustDirname);
			$groupUserLinkBean = Xoonips_BeanFactory::getBean('GroupsUsersLinkBean', $this->dirname, $this->trustDirname);			
			$managers = $userBean->getUsersGroups($groupid, true);
			$uids = array();
			foreach ($managers as $manager) {
				$uids[$manager['uid']] = $manager;
			}
			//$this->mUsers = $this->deleteManagersFromUsers($this->mUsers, $uids);
			$groupUser = $groupUserLinkBean->getGroupUserLinkInfoByGroupId($groupid);
			$groupUsers = array();
			foreach ($this->mUsers as $user) {	
				$groupUsers[$user->get('uid')] = array('user' => $user, 'groupUser' => $groupUser[$user->get('uid')]);
			}
			$this->mUsers = $groupUsers;
			//$this->mNoUsers = $this->deleteManagersFromUsers($this->mNoUsers, $uids);
		}
		return USER_FRAME_VIEW_INDEX;
	}

	function deleteManagersFromUsers($users, $managers) {
		$mUsers = array();
		foreach ($users as $user) {
			if (!isset($managers[$user->get('uid')])) {
				$mUsers[] = $user;
			}
		}
		return $mUsers;
	}

	function execute(&$controller, &$xoopsUser)
	{
		$this->_loadGroup();
		if (!is_object($this->mGroup)) {
			return USER_FRAME_VIEW_ERROR;
		}
		
		$this->mActionForm->fetch();
		$this->mActionForm->validate();
		
		if ($this->mActionForm->hasError()) {
			return $this->getDefaultView($controller, $xoopsUser);
		}

		$memberHandler =& xoops_gethandler('member');
		$userHandler =& xoops_getmodulehandler('users');

		if ($this->mGroup->get('group_type') == Xoonips_Enum::GROUP_TYPE) {
	  		$transaction = Xoonips_Transaction::getInstance();
  			$transaction->start();
			$userlogic = User_User::getInstance();
			$addUsers = array();
			$delUsers = array();
			foreach($this->mActionForm->get('uid') as $uid => $value) {
				if ($value == 1) {
					$addUsers[] = $uid;
				} elseif ($value == 2) {
					$delUsers[] = array('uid' => $uid);
				}
			}
			$message = '';
			if (!$userlogic->doGroupMember($this->mGroup->get('groupid'), $delUsers, $addUsers, $message)) {
				$this->mActionForm->addErrorMessage($message);
			}
			if ($this->mActionForm->hasError()) {
				$transaction->rollback();
			} else {
				$transaction->commit();
			}
		} else {
			foreach($this->mActionForm->get('uid') as $uid => $value) {
				$user =& $userHandler->get($uid);
			
				if (is_object($user)) {
					if ($value == 1) {
						$memberHandler->addUserToGroup($this->mGroup->get('groupid'), $uid);
					} elseif ($value == 2) {
						$memberHandler->removeUserFromGroup($this->mGroup->get('groupid'), $uid);
					}
				}
			}
		}
		
		return $this->getDefaultView($controller, $xoopsUser);
	}

	function _loadGroup()
	{
		if (!is_object($this->mGroup)) {
			$id = xoops_getrequest('groupid');

			$handler =& xoops_getmodulehandler('groups');
			$this->mGroup =& $handler->get($id);
		}
	}

	function executeViewIndex(&$controller, &$xoopsUser, &$render)
	{
		$render->setTemplateName('group_member.html');
		$render->setAttribute('group', $this->mGroup);

		$render->setAttribute('users', $this->mUsers);
		$render->setAttribute('grpUsCertified', Xoonips_Enum::GRP_US_CERTIFIED);
		$render->setAttribute('grpUsJoinRequired', Xoonips_Enum::GRP_US_JOIN_REQUIRED);
		$render->setAttribute('grpUsLeaveRequired', Xoonips_Enum::GRP_US_LEAVE_REQUIRED);
		$render->setAttribute('grpUser', Xoonips_Enum::GRP_USER);
		$render->setAttribute('pageNavi', $this->mPageNavi);

		$render->setAttribute('noUsers', $this->mNoUsers);
		$render->setAttribute('noPageNavi', $this->mNoPageNavi);
		
		$render->setAttribute('actionForm', $this->mActionForm);
	}
}

?>
