<?php

require_once dirname(dirname(__FILE__)) . '/class/core/ActionBase.class.php';

class User_GroupInfoAction extends User_ActionBase {

	protected function doInit(&$request, &$response) {
		$viewData = array();
		$groupbean = Xoonips_BeanFactory::getBean('GroupsBean', $this->dirname, $this->trustDirname);
		$userbean = Xoonips_BeanFactory::getBean('UsersBean', $this->dirname, $this->trustDirname);
		$groupuserlinkbean = Xoonips_BeanFactory::getBean('GroupsUsersLinkBean', $this->dirname, $this->trustDirname);
		$groupId = $request->getParameter('groupid');
		$group = $groupbean->getGroup($groupId);
		$file_path = XOOPS_ROOT_PATH . '/uploads/user/group/' . $groupId;
		$showThumbnail = false;
		if (file_exists($file_path)) {
			$showThumbnail = true;
		}
		
		if (empty($group)) {
			$response->setSystemError(_MD_USER_MESSAGE_GROUP_EMPTY);
			return false;
		}

		$group_handler =& xoops_gethandler('group');
		$xoopsGroup = $group_handler->get($groupId);

		$maximumResources = array();
		XCube_DelegateUtils::call('Module.User.GetGroupMaximumResources', new XCube_Ref($maximumResources), $xoopsGroup);
		if (count($maximumResources) > 0) {
			foreach ($maximumResources as $resource) {
				$maximumResource = $resource;
			}
		} else {
			$maximumResource = array('itemNumberLimit'=>0, 'indexNumberLimit'=>0, 'itemStorageLimit'=>0);
		}

		$usedResources = array();
		XCube_DelegateUtils::call('Module.User.GetGroupUsedResources', new XCube_Ref($usedResources), $xoopsGroup);
		if (count($usedResources) > 0) {
			foreach ($usedResources as $resource) {
				$usedResource = $resource;
			}
		} else {
			$usedResource = array('itemNum'=>0, 'indexNum'=>0, 'fileSize'=>0);
		}

		//get group information	
		$admins = $userbean->getUsersGroups($groupId, true);
		$members = $userbean->getUsersGroups($groupId, false);
		$thumbnail = XOOPS_URL . "/modules/$this->dirname/image.php?group_id=$groupId";
		
		//edit group member name
		$users = array();
		foreach ($members as $member) {				
			$groupUserLinkInfo = $groupuserlinkbean->getGroupUserLinkInfo($groupId, $member['uid']);
			$member['activate'] = $groupUserLinkInfo['activate'];
			$users[] = $member;
		}
		//edit group storage
		$token_ticket = $this->createToken('group_detail');
		$viewData['token_ticket'] = $token_ticket;
		$breadcrumbs = array(
			array(
				'name' => _MD_USER_LANG_GROUP_LIST,
				'url' => 'index.php?action=groupList'
			),
			array(
				'name' => _MD_USER_LANG_GROUP_INFO
			)
		);		
		$viewData['xoops_breadcrumbs'] = $breadcrumbs;
		$viewData['group'] = $group;
		$viewData['admins'] = $admins;
		$viewData['members'] = $users;
		$viewData['itemNum'] = $usedResource['itemNum'];
		$viewData['indexNum'] = $usedResource['indexNum'];
		$viewData['fileSize'] = $usedResource['fileSize'] / 1024 / 1024;
		$viewData['itemNumberLimit'] = $maximumResource['itemNumberLimit'];
		$viewData['indexNumberLimit'] = $maximumResource['indexNumberLimit'];
		$viewData['itemStorageLimit'] = $maximumResource['itemStorageLimit'] / 1024 / 1024;
		$viewData['thumbnail'] = $thumbnail;
		$viewData['showThumbnail'] = $showThumbnail;
		$response->setViewData($viewData);
		$response->setForward('init_success');
		return true;
	}
}
?>
