<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

require_once XOONIPS_CONTROL_PATH.'control_base.php';
require_once XOONIPS_CLASS_PATH.'util.php';
require_once XOONIPS_MAIN_PATH.'/class/XmlItemExport.class.php';
require_once XOONIPS_MAIN_PATH.'/class/bean/ItemVirtualBean.class.php';

class itemget extends control_base {
 
  private $domdoc;
  private $multistatus_data;
  private $status;
  const mul_resurl = 'http://xoonips.sourceforge.jp/rest/multistatus/';
  const mul_resprefix = 'M:';
  const mul_resxmlns = 'xmlns:M';
  
  public function Init() {
    $this->domdoc = new DOMDocument('1.0');
    $this->domdoc->encodeing = 'UTF-8';
    $this->domdoc->formatOutput = true;
    
    $root = $this->domdoc->createElementNS(self::mul_resurl, self::mul_resprefix.'multistatus');
    $this->multistatus_data = $this->domdoc->appendChild($root);
    $root->setAttributeNS(self::defurl, self::mul_resxmlns, self::mul_resurl);
  }
  
  private function multi_status_http_header() {
    res_code(207, null, true);
  }
    
  /**
   * itemget and another xml common routine.
   * 
   * @param object $respons_data dom object
   * @param int $code http response code
   * @param int $item_id ITEM ID
   * @param string $response responsedescription
   * @param string $xml  if exist xml ,include xml.
   */
  protected function mk_xml_ele_207($code, $item_id, $append_dom, $responsedescription, &$domdoc, &$respons_data) {
    // insert errmsg
    if ($code != 0) {
      $msg = get_code_msg($code);
      if (is_null($msg))
        return null;
      $respons_data->appendChild($domdoc->createElementNS(self::mul_resurl, self::mul_resprefix.'code', 'HTTP/1.1 '.$code.' '.$msg));
    }
    
    if ($item_id != -1) {
      $respons_data->appendChild($domdoc->createElementNS(self::mul_resurl, self::mul_resprefix.'request_id', $item_id));
    }
    
    // insert xmldomobj
    // insert responsedescription
    if (is_null($responsedescription) == false) {
      $respons_data->appendChild($domdoc->createElementNS(self::mul_resurl, self::mul_resprefix.'result', $responsedescription));
    } else if(is_null($append_dom) == false) {
      $dom_copy = $domdoc->importNode($append_dom->documentElement, true);
      $resultdom = $domdoc->createElementNS(self::mul_resurl,self::mul_resprefix.'result');
      $respons_data->appendChild($resultdom);
      $resultdom->appendChild($dom_copy);
    }
  }
  
  private function mk_multistat_dom($code = 0, $item_id = -1, $dom = null, $responsedescription = null) {
    $this->status = $this->multistatus_data->appendChild($this->domdoc->createElementNS(self::mul_resurl, self::mul_resprefix.'status'));
    $this->mk_xml_ele_207($code,$item_id,$dom,$responsedescription,$this->domdoc,$this->status);
  }

  protected function get_printable_dom() {
    $this->domdoc->encodeing = 'UTF-8';
    $this->domdoc->formatOutput = true;    
    return $this->domdoc->saveXML();
  }

  public function run($req) {
    // Can it operate permit?
    $item_id_arr = $req->get('item_id');
    $dblang = $this->get_db_lang();
    if (is_null($dblang)) {
      $this->rest_notify_err(500, 'DB language is not UTF-8 or EUC-JP.');
    }
    if (is_null($item_id_arr)) {
      res_code(400);
      $xml = $this->mk_response_xml(0, -1 , null, 'Parameter item_id not found.');
      echo $xml;
      exit();
    }else{
      $this->multi_status_http_header();
      $dirname = $trustDirname = 'xoonips';
      $itemBean = Xoonips_BeanFactory::getBean('ItemVirtualBean', $dirname, $trustDirname);
      $export = new XmlItemExport();
      $export->set_db_lang($dblang);
      foreach ($item_id_arr as $item_id) {
        // !! Change this line !!
        $rc = $itemBean->canView($item_id, $this->uid);
        if ($rc == true) {
          $xml = $export->get_dom($item_id);
          $this->mk_multistat_dom(200, $item_id, $xml);
        } else {
          $this->mk_multistat_dom(404, $item_id, null, 'Can not access your authorite.');
        }
      }
      echo $this->get_printable_dom();
    }
  }
}
