<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

/**
 * common const
**/
class Xoonips_Enum
{
	// user table activate
	const USER_NOT_ACTIVATE = 0;
	const USER_NOT_CERTIFIED = 1;
	const USER_CERTIFIED = 2;

	// user type
	const USER_TYPE_GUEST = 0;
	const USER_TYPE_USER = 1;
	const USER_TYPE_GROUPMANAGER = 2;
	const USER_TYPE_MODERATOR = 3;

	// group id
	const GRP_ID_USER = 2;

	// groups table activate
	const GRP_NOT_CERTIFIED = 0;
	const GRP_CERTIFIED = 1;
	const GRP_OPEN_REQUIRED = 2;
	const GRP_PUBLIC = 3;
	const GRP_CLOSE_REQUIRED = 4;
	const GRP_DELETE_REQUIRED = 5;
	
	// group administrator
	const GRP_ADMINISTRATOR = 1;
	const GRP_USER = 0;

	// groups users link table activate
	const GRP_US_CERTIFIED = 0;
	const GRP_US_JOIN_REQUIRED = 1;
	const GRP_US_LEAVE_REQUIRED = 2;
	
	// op type
	const OP_TYPE_LIST = 1;
	const OP_TYPE_DETAIL = 2;
	const OP_TYPE_REGISTRY = 3;
	const OP_TYPE_EDIT = 4;
	const OP_TYPE_SEARCH = 5;
	const OP_TYPE_MANAGER_EDIT = 6;
	const OP_TYPE_METAINFO = 7;
	const OP_TYPE_ITEMUSERSEDIT = 8;
	const OP_TYPE_MANAGER_REGISTRY = 9;
	const OP_TYPE_QUICKSEARCH = 10;
	const OP_TYPE_SIMPLESEARCH = 11;
	const OP_TYPE_SEARCHLIST = 12;

	// certify type
	public static function certifyUsers() {
		$handler = self::getXLeprogress();
		if ($handler) {
			$row = $handler->getIdList(new Criteria('module', XCUBE_CORE_USER_MODULE_NAME . '.WorkflowUser'));
			if (count($row) > 0) {
				return $row[0];
			} else {
				return 0;
			}
		} else {
			return 0;
		}
	}
	public static function certifyGroups() {
		$handler = self::getXLeprogress();
		if ($handler) {
			$row = $handler->getIdList(new Criteria('module', XCUBE_CORE_USER_MODULE_NAME . '.WorkflowGroupRegister'));
			if (count($row) > 0) {
				return $row[0];
			} else {
				return 0;
			}
		} else {
			return 0;
		}
	}
	public static function certifyGroupDelete() {
		$handler = self::getXLeprogress();
		if ($handler) {
			$row = $handler->getIdList(new Criteria('module', XCUBE_CORE_USER_MODULE_NAME . '.WorkflowGroupDelete'));
			if (count($row) > 0) {
				return $row[0];
			} else {
				return 0;
			}
		} else {
			return 0;
		}
	}
	public static function certifyGroupJoin() {
		$handler = self::getXLeprogress();
		if ($handler) {
			$row = $handler->getIdList(new Criteria('module', XCUBE_CORE_USER_MODULE_NAME . '.WorkflowGroupJoin'));
			if (count($row) > 0) {
				return $row[0];
			} else {
				return 0;
			}
		} else {
			return 0;
		}
	}
	public static function certifyGroupLeave() {
		$handler = self::getXLeprogress();
		if ($handler) {
			$row = $handler->getIdList(new Criteria('module', XCUBE_CORE_USER_MODULE_NAME . '.WorkflowGroupLeave'));
			if (count($row) > 0) {
				return $row[0];
			} else {
				return 0;
			}
		} else {
			return 0;
		}
	}
	public static function certifyGroupOpen() {
		$handler = self::getXLeprogress();
		if ($handler) {
			$row = $handler->getIdList(new Criteria('module', XCUBE_CORE_USER_MODULE_NAME . '.WorkflowGroupOpen'));
			if (count($row) > 0) {
				return $row[0];
			} else {
				return 0;
			}
		} else {
			return 0;
		}
	}
	public static function certifyGroupClose() {
		$handler = self::getXLeprogress();
		if ($handler) {
			$row = $handler->getIdList(new Criteria('module', XCUBE_CORE_USER_MODULE_NAME . '.WorkflowGroupClose'));
			if (count($row) > 0) {
				return $row[0];
			} else {
				return 0;
			}
		} else {
			return 0;
		}
	}
	public static function certifyPublicItems($dirname) {
		$handler = self::getXLeprogress();
		if ($handler) {
			$row = $handler->getIdList(new Criteria('module', $dirname . '.WorkflowPublicItems'));
			if (count($row) > 0) {
				return $row[0];
			} else {
				return 0;
			}
		} else {
			return 0;
		}
	}
	public static function certifyPublicItemsWithdrawal($dirname) {
		$handler = self::getXLeprogress();
		if ($handler) {
			$row = $handler->getIdList(new Criteria('module', $dirname . '.WorkflowPublicItemsWithdrawal'));
			if (count($row) > 0) {
				return $row[0];
			} else {
				return 0;
			}
		} else {
			return 0;
		}
	}
	public static function certifyGroupItems($dirname) {
		$handler = self::getXLeprogress();
		if ($handler) {
			$row = $handler->getIdList(new Criteria('module', $dirname . '.WorkflowGroupItems'));
			if (count($row) > 0) {
				return $row[0];
			} else {
				return 0;
			}
		} else {
			return 0;
		}
	}
	public static function certifyGroupItemsWithdrawal($dirname) {
		$handler = self::getXLeprogress();
		if ($handler) {
			$row = $handler->getIdList(new Criteria('module', $dirname . '.WorkflowGroupItemsWithdrawal'));
			if (count($row) > 0) {
				return $row[0];
			} else {
				return 0;
			}
		} else {
			return 0;
		}
	}

	private static function getXLeprogress() {
		if (is_dir(XOOPS_ROOT_PATH . '/modules/xleprogress')) {
			return Legacy_Utils::getModuleHandler('type', 'xleprogress');
		} else {
			return false;
		}
	}

	const ITEM_ID_SEPARATOR = ':';

	const XLEPROGRESS = 'xleprogress';
    const XLEPROGRESS_GROUP = 999999;
	const GROUP_TYPE = '';

	const XOONIPS_WINDOW_SIZE = 2;
}

?>
