<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/WorkflowBase.class.php';
require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanFactory.class.php';

class Xoonips_WorkflowGroupItemsWithdrawal extends Xoonips_WorkflowBase {

	public function doCertify($indexItemLinkId, &$result, $comment) {
		$result[0] = false;
		$indexItemLinkBean = null;
		$workflow = Xoonips_WorkflowFactory::getWorkflow('WorkflowGroupItems', $this->dirname, $this->trustDirname);
		list($itemId, $indexId, $groupId) = $workflow->getTargetGroupId($indexItemLinkId, $indexItemLinkBean);
		// delete xoonip_index_item_link info by index_id and item_id
		if ($groupId == 0 || !$indexItemLinkBean->deleteByid($indexId, $itemId)) {
			return false;
		}

		//update xoonips_oaipmh_item_status
		$openIndexIds = $indexItemLinkBean->getOpenIndexIds($itemId);
		if ($openIndexIds === false) return false;
		if (count($openIndexIds) == 0) {
			$itemStatusBean = Xoonips_BeanFactory::getBean('OaipmhItemStatusBean', $this->dirname, $this->trustDirname);
			if (!$itemStatusBean->delete($itemId)) {
				return false;
			}
		}
		$result[0] = true;

		//event log
		$this->log->recordCertifyGroupItemWithdrawalEvent($itemId, $indexId);

		//send to item users
		$groupsUsersLinkBean = Xoonips_BeanFactory::getBean('GroupsUsersLinkBean', XCUBE_CORE_USER_MODULE_NAME);
		$itemUsersBean = Xoonips_BeanFactory::getBean('ItemUsersLinkBean', $this->dirname, $this->trustDirname);
		$itemUsersInfo = $itemUsersBean->getItemUsersInfo($itemId);
		foreach ($groupsUsersLinkBean->getAdminUserIds($groupId) as $id) {
			$sendToUsers[$id] = $id; 
		}
		foreach ($itemUsersInfo as $itemUser) {
			$sendToUsers[$itemUser['uid']] = $itemUser['uid'];
		}
		XCube_DelegateUtils::call('Legacy_Workflow.GetAllCertifyUsers', Xoonips_Enum::certifyGroupItemsWithdrawal($this->dirname), new XCube_Ref($sendToUsers));
		$this->notification->groupItemWithdrawal($itemId, $indexId, $groupId, $sendToUsers, $comment);
	}

	public function doProgress($indexItemLinkId, &$result, $comment) {
		$result[0] = false;
		$indexItemLinkBean = null;
		$workflow = Xoonips_WorkflowFactory::getWorkflow('WorkflowGroupItems', $this->dirname, $this->trustDirname);
		list($itemId, $indexId, $groupId) = $workflow->getTargetGroupId($indexItemLinkId, $indexItemLinkBean);
		if ($groupId == 0) {
			return;
		}
		$sendToUsers = array();
		XCube_DelegateUtils::call('Legacy_Workflow.GetCurrentCertifyUsers', Xoonips_Enum::certifyGroupItemsWithdrawal($this->dirname), $indexItemLinkId, new XCube_Ref($sendToUsers));
		$this->notification->groupItemWithdrawalRequest($itemId, $indexId, $groupId, $sendToUsers);
		$result[0] = true;
	}

	public function doRefuse($indexItemLinkId, &$result, $comment) {
		$result[0] = false;
		$indexItemLinkBean = null;
		$workflow = Xoonips_WorkflowFactory::getWorkflow('WorkflowGroupItems', $this->dirname, $this->trustDirname);
		list($itemId, $indexId, $groupId) = $workflow->getTargetGroupId($indexItemLinkId, $indexItemLinkBean);
		// update xoonip_index_item_link
		if ($groupId == 0 || !$indexItemLinkBean->update($indexId, $itemId, 2)) {
			return false;
		}
		$groupId = $indexInfo['groupid'];

		$result[0] = true;

		//event log
		$this->log->recordRejectGroupItemWithdrawalEvent($itemId, $indexId);

		//send to item users
		$groupsUsersLinkBean = Xoonips_BeanFactory::getBean('GroupsUsersLinkBean', XCUBE_CORE_USER_MODULE_NAME);
		$itemUsersBean = Xoonips_BeanFactory::getBean('ItemUsersLinkBean', $this->dirname, $this->trustDirname);
		$itemUsersInfo = $itemUsersBean->getItemUsersInfo($itemId);
		foreach ($groupsUsersLinkBean->getAdminUserIds($groupId) as $id) {
			$sendToUsers[$id] = $id; 
		}
		foreach ($itemUsersInfo as $itemUser) {
			$sendToUsers[$itemUser['uid']] = $itemUser['uid'];
		}
		XCube_DelegateUtils::call('Legacy_Workflow.GetAllCertifyUsers', Xoonips_Enum::certifyGroupItemsWithdrawal($this->dirname), new XCube_Ref($sendToUsers));
		$this->notification->groupItemWithdrawalRejected($itemId, $indexId, $groupId, $sendToUsers, $comment);
	}

	public function getDetailView($indexItemLinkId) {
		$workflow = Xoonips_WorkflowFactory::getWorkflow('WorkflowPublicItems', $this->dirname, $this->trustDirname);
		return $workflow->getDetailView($indexItemLinkId);
	}

	public function getTargetGroupId($indexItemLinkId, &$indexItemLinkBean) {
		$workflow = Xoonips_WorkflowFactory::getWorkflow('WorkflowGroupItems', $this->dirname, $this->trustDirname);
		return $workflow->getTargetGroupId($indexItemLinkId, $indexItemLinkBean);
	}
}

