<?php

if (!defined('XOOPS_ROOT_PATH')) exit();

/**
 * Xleprogress_GroupObject
**/
class Xleprogress_GroupObject extends XoopsSimpleObject
{
	public $mDirname = null;

	/**
	 * __construct
	 * 
	 * @param	string	$dirname
	 * 
	 * @return	void
	**/
	public function __construct()
	{
		$this->initVar('groupid', XOBJ_DTYPE_INT, '', false);
		$this->initVar('activate', XOBJ_DTYPE_INT, '', false);
		$this->initVar('name', XOBJ_DTYPE_STRING, '', false, 50);
	}
	
	/**
	 * _getDirname
	 * 
	 * @param	void
	 * 
	 * @return	string
	**/
	public function getDirname()
	{
		return $this->mDirname;
	}
}

/**
 * Xleprogress_GroupHandler
**/
class Xleprogress_GroupHandler extends XoopsObjectGenericHandler
{
	public /*** string ***/ $mTable = 'groups';

	public /*** string ***/ $mPrimary = 'groupid';

	public /*** string ***/ $mClass = 'Xleprogress_GroupObject';

	/**
	 * __construct
	 * 
	 * @param	XoopsDatabase  &$db
	 * @param	string	$dirname
	 * 
	 * @return	void
	**/
	public function __construct(/*** XoopsDatabase ***/ &$db,/*** string ***/ $dirname)
	{
		$this->mTable = strtr($this->mTable,array('{dirname}' => $dirname));
		parent::XoopsObjectGenericHandler($db);
	}

	/**
	 * getGroupList
	 * 
	 * @param	string	$dirname
	 * @param	string	$target
	 * 
	 * @return	Xleprogress_GroupObject[]
	**/
	public function getGroupList()
	{
		$cri = new CriteriaCompo();
		$cri->add(new Criteria('activate',1,'>='));
		$cri->setSort('name', 'ASC');
		return $this->getObjects($cri);
	}

	/**
	 * getGroupList
	 * 
	 * @param	string	$dirname
	 * @param	string	$target
	 * 
	 * @return	Xleprogress_GroupObject[]
	**/
	public function getAdminGroup()
	{
		$cri = new CriteriaCompo();
		$cri->add(new Criteria('group_type','Admin'));
		$cri->setSort('name', 'ASC');
		return $this->getObjects($cri);
	}
}

?>

