<?php
global $MAIN_FILE;
require_once $MAIN_FILE;
require_once XOOPS_TRUST_PATH.'/modules/xdbmigrate/cmd/item_type/xdbmigrate_itemtype_base.inc.php';

class xnpsimulator extends xdbmigrate_itemtype_base {

  function __construct() {
    
  }
  
  /**
   * Initialize 
   */
  public function init($db) {
    parent::init($db);
    $this->set_ng_item_name('Simulator');
    $this->add_file_mapping_array('simulator_data', 'files');
    $this->add_file_mapping_array('preview', 'preview');
    $this->add_file_mapping_array('readme', 'readme');
    $this->add_file_mapping_array('rights', 'rights');
    
    #Description migrate to ...
    $this->set_description('outline');
    
    #Duplicate Table
    $this->add_dup_table('xnpsimulator_developer');
    $this->add_dup_table('xnpsimulator_item_detail');
  }
  
  /**
   *
   * This function get xnpsimulator_item_detail table info.
   * 
   * @param int $item_id
   * @return Success:xnpsimulator_item_detail Array includes fields, Fail:FALSE 
   */  
  protected function get_xnpsimulator_item_detail($item_id){
    $tbl = get_WK_tbl('xnpsimulator_item_detail');
    $sql = "select * from {$tbl} where simulator_id={$item_id}";
    $result_array = $this->db->query($sql);
    if(count($result_array) == 1){
      return $result_array[0];
    }
    return FALSE;    
  }
  
  /**
   *
   * This function get xnpsimulator_developer table info.
   * 
   * @param int $item_id
   * @return Success:xnpsimulator_developer Array includes fields, Fail:FALSE 
   */
  protected function get_xnpsimulator_developer($item_id){
    $tbl = get_WK_tbl('xnpsimulator_developer');
    $sql = "select * from {$tbl} where simulator_id={$item_id}";
    $result_array = $this->db->query($sql);
    if(count($result_array) > 0){
      return $result_array;
    }
    return FALSE;    
  }

  /**
   * Do migaration.
   * 
   * @param array $item xoonips_basic_item
   * @return Success:0,Fail:Negative number
   */
  public function migrate($item) {
    #xoonips_item
    $item_id = $item['item_id'];
    $item_detail = $this->get_xnpsimulator_item_detail($item_id);
    if($item_detail === FALSE || $item_detail === null){
      return -errmsg(APP_MIGRATE, 'E2301',$item_id);
    }

    #data_type
    $data_type_array = $this->get_table_column_by_item('simulator_type');
    if($data_type_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E2303');
    }
    $rc = $this->insert_any($data_type_array,$item_id,$item_detail['simulator_type']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E2304',$item_id);
    }

    #readme
    $readme_array = $this->get_table_column_by_group('readme');
    if($readme_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E2305');
    }
    $rc = $this->insert_any($readme_array,$item_id,$item_detail['readme']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E2306',$item_id);
    }
    
    #rights
    $rights_array = $this->get_table_column_by_group('rights');
    if($rights_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E2307');
    }
    $rights = $this->make_rights($item_detail);
    $rc = $this->insert_any($rights_array,$item_id,  $rights);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E2308',$item_id);
    }

    #date
    $rc = $this->migrate_simple_date($item);
    if($rc < 0)return $rc;
    
    #attachment_dl_limit
    $attdl_array = $this->get_table_column_by_item('attachment_dl_limit');
    if($attdl_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E2309');
    }
    $rc = $this->insert_any($attdl_array,$item_id,$item_detail['attachment_dl_limit']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E2310',$item_id);
    }
    
    #attachment_dl_notify
    $attnotify_array = $this->get_table_column_by_item('attachment_dl_notify');
    if($attnotify_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E2311');
    }
    $rc = $this->insert_any($attnotify_array,$item_id,$item_detail['attachment_dl_notify']);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E2312');
    }
    
    #developer
    $developers_array = $this->get_table_column_by_group('developers');
    if($developers_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E2313');
    }
    $developer = $this->get_xnpsimulator_developer($item_id);
    if($developer === FALSE){
      return -errmsg(APP_MIGRATE, 'E2302',$item_id);
    }
    foreach ($developer as $value) {
      $rc = $this->insert_any($developers_array,$item_id,$value['developer'],$value['developer_order']+1);
      if($rc === FALSE){
        return -errmsg(APP_MIGRATE, 'E2314',$item_id);
      }
    }

    return 0;
  }
}
