<?php

global $MAIN_FILE;
require_once $MAIN_FILE;
require_once XOOPS_TRUST_PATH.'/modules/xdbmigrate/cmd/item_type/xdbmigrate_itemtype_base.inc.php';

class xnparticle extends xdbmigrate_itemtype_base {

  function __construct() {
    
  }

  public function init($db) {
    parent::init($db);
    $this->set_ng_item_name('Article');
    
    #File mapping
    $this->add_file_mapping_array('article_attachment', 'files');
    $this->add_file_mapping_array('preview', 'preview');
    
    #Description migrate to ...
    $this->set_description('notes');
    
    #Duplicate Tables
    $this->add_dup_table('xnparticle_item_detail_child_uris');
    $this->add_dup_table('xnparticle_item_detail_child_id_locals');
    $this->add_dup_table('xnparticle_item_detail_child_id_uris');
    $this->add_dup_table('xnparticle_item_detail_child_id_dois');
    $this->add_dup_table('xnparticle_item_detail_child_id_isbns');
    $this->add_dup_table('xnparticle_item_detail_child_id_issns');
    $this->add_dup_table('xnparticle_item_detail_child_langs');
    $this->add_dup_table('xnparticle_item_detail_child_physical_descriptions');
    $this->add_dup_table('xnparticle_item_detail_child_ndc_classifications');
    $this->add_dup_table('xnparticle_item_detail_child_keywords');
    $this->add_dup_table('xnparticle_item_detail_child_author');
    $this->add_dup_table('xnparticle_item_detail_child_sub_title');
    $this->add_dup_table('xnparticle_item_detail');
  }

  /*************************************************************************/
  /**
   * Below functions get varius data from xnparticle.
   * 
   */

  /**
   * Common Function 
   * 
   * @param integer $item_id
   * @param string  $tbl
   * @return array:Success , FALSE:Fail
   */
  protected function xnparticle_tbl_common($item_id,$tbl){
    $wktbl = get_WK_tbl($tbl);
    $sql = "select * from ${wktbl} where article_id=${item_id}";
    $result_array = $this->db->query($sql);
    if(count($result_array) >0){
      return $result_array;
    }
    return FALSE;
  }

  /**
   * To get xnparticle_item_detail table.
   * 
   * @param integer $item_id
   * @return array:Success , FALSE:Fail
   */
  protected function get_xnparticle_item_detail($item_id){
    $rc =  $this->xnparticle_tbl_common($item_id,'xnparticle_item_detail');
    if(is_array($rc)){
        return  $rc[0];
    }
    return $rc;
  }
  
  /**
   * To get xnparticle_item_detail_child_sub_title table.
   * 
   * @param integer $item_id
   * @return array:Success , FALSE:Fail 
   */
  protected function get_xnparticle_item_detail_child_sub_title($item_id){
    return $this->xnparticle_tbl_common($item_id,'xnparticle_item_detail_child_sub_title');
  }
  
  /**
   * To get xnparticle_item_detail_child_author table.
   * 
   * @param integer $item_id
   * @return array:Success , FALSE:Fail
   */
  protected function get_xnparticle_item_detail_child_author($item_id){
    return $this->xnparticle_tbl_common($item_id,'xnparticle_item_detail_child_author');
  }

  /**
   * To get xnparticle_item_detail_child_id_dois table;
   * 
   * @param integer $item_id
   * @return array:Success , FALSE:Fail 
   */
  protected function get_xnparticle_item_detail_child_id_dois($item_id) {
    return $this->xnparticle_tbl_common($item_id,'xnparticle_item_detail_child_id_dois');
  }
  
  /**
   *xnparticle_item_detail_child_physical_descriptions
   * 
   * @param integer $item_id
   * @return array:Success , FALSE:Fail
   */
  protected function get_xnparticle_item_detail_child_physical_descriptions($item_id) {
    return $this->xnparticle_tbl_common($item_id,'xnparticle_item_detail_child_physical_descriptions');
  }

  /**
   * xnparticle_item_detail_child_keywords
   * 
   * @param integer $item_id
   * @return array:Success , FALSE:Fail
   */
  protected function get_xnparticle_item_detail_child_keywords($item_id) {
    return $this->xnparticle_tbl_common($item_id,'xnparticle_item_detail_child_keywords');
  }
  
  /**
   * xnparticle_item_detail_child_ndc_classifications
   * 
   * @param integer $item_id
   * @return array:Success , FALSE:Fail 
   */
  protected function get_xnparticle_item_detail_child_ndc_classifications($item_id) {
    return $this->xnparticle_tbl_common($item_id,'xnparticle_item_detail_child_ndc_classifications');
  }
  
  /**
   * xnparticle_item_detail_child_id_issns
   * 
   * @param integer $item_id
   * @return array:Success , FALSE:Fail  
   */
  protected function get_xnparticle_item_detail_child_id_issns($item_id) {
    return $this->xnparticle_tbl_common($item_id,'xnparticle_item_detail_child_id_issns');
  }

  /**
   * xnparticle_item_detail_child_id_isbns
   * 
   * @param integer $item_id
   * @return array:Success , FALSE:Fail  
   */  
  protected function get_xnparticle_item_detail_child_id_isbns($item_id) {
    return $this->xnparticle_tbl_common($item_id,'xnparticle_item_detail_child_id_isbns');
  }

  /**
   * xnparticle_item_detail_child_id_uris
   * 
   * @param integer $item_id
   * @return array:Success , FALSE:Fail  
   */
  protected function get_xnparticle_item_detail_child_id_uris($item_id){
    return $this->xnparticle_tbl_common($item_id,'xnparticle_item_detail_child_id_uris');
  }

  /**
   * xnparticle_item_detail_child_id_locals
   * 
   * @param integer $item_id
   * @return array:Success , FALSE:Fail  
   */
  protected function get_xnparticle_item_detail_child_id_locals($item_id) {
    return $this->xnparticle_tbl_common($item_id,'xnparticle_item_detail_child_id_locals');
  }

  /**
   * xnparticle_item_detail_child_uris
   * 
   * @param integer $item_id
   * @return array:Success , FALSE:Fail 
   */
  protected function get_xnparticle_item_detail_child_uris($item_id) {
    return $this->xnparticle_tbl_common($item_id,'xnparticle_item_detail_child_uris');
  }

  /**
   * xnparticle_item_detail_child_langs
   * 
   * @param integer $item_id
   * @return array:Success , FALSE:Fail 
   */  
  protected function get_xnparticle_item_detail_child_langs($item_id) {
    return $this->xnparticle_tbl_common($item_id,'xnparticle_item_detail_child_langs');
  }


  /*
   * 1.Implimentation junii2(Version 3.0)
   * Here,You must get xnparticle tables data from adding table or colmun.
   * 
   */
  
  
  /*************************************************************************/
  /**
   * migrate subtitle .
   * 
   * @param integer $item_id
   * @return integer 0:OK,less than 0:NG
   */
  protected function migrate_subtitle($item_id) {
    $old_subtitle_detail = $this-> get_xnparticle_item_detail_child_sub_title($item_id); #old xoonips data.
    if($old_subtitle_detail === FALSE){
      #Maybe data doesn't include xnparticle_item_detail_child_sub_title.
      return 0;
    }elseif($old_subtitle_detail === null){
      return -errmsg(APP_MIGRATE, 'E3202',$item_id);
    }
    
    $ng_subtitle_array = $this->get_table_column_by_group('sub_title'); #new xoonips data
    if($ng_subtitle_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E3203',$item_id);
    }

    foreach($old_subtitle_detail as $old_subtitle){
      foreach ($ng_subtitle_array as $ng_subtitle){
        $name = '';
        switch ($ng_subtitle['xml']) {
          case 'name':
            $name = $old_subtitle['sub_title_name'];
            break;
          case 'kana':
            $name = $old_subtitle['sub_title_kana'];
            break;
          case 'romaji':
            $name = $old_subtitle['sub_title_romaji'];
            break;
          }
          if($name !== ''){
            $order = $old_subtitle['sub_title_order']+1;
            $rc = $this->insert_any($ng_subtitle,$item_id,$name,$order);
            if($rc === FALSE){
              return -errmsg(APP_MIGRATE, 'E3204',"item_id = ${item_id} name=${name} order=${order}");
            }
          }
       }
    }
    return 0;
  }
  
  /**
   * migate author
   * 
   * @param integer$item_id
   * @return integer 0:OK,less than 0:NG
   */
  protected function migrate_author($item_id){
    $old_author_detail = $this->get_xnparticle_item_detail_child_author($item_id);
    if($old_author_detail === FALSE){
      #Maybe data doesn't include xnparticle_item_detail_child_author.
      return 0;
    }elseif($old_author_detail === null){
      return -errmsg(APP_MIGRATE, 'E3205',$item_id);
    }
    $ng_author_array = $this->get_table_column_by_group('article_authors'); #new xoonips data
    if($ng_author_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E3206',$item_id);
    }
    
    $conv = array(
       'author_id'                      => 'author_id',
       'name'                           => 'author_name',
       'kana'                           => 'author_kana',
       'romaji'                         => 'author_romaji',
       'author_affiliation'             => 'author_affiliation',
       'author_affiliation_translation' => 'author_affiliation_translation',
       'author_role'                    => 'author_role',
       'author_link'                    => 'author_link'
    );
    foreach ($old_author_detail as $old_author) {
      foreach ($ng_author_array as $ng_author) {
        $xml = $ng_author['xml'];
        if(array_key_exists($xml, $conv) == true){
          $ng_xml = $conv[$xml];
          $val = $old_author[$ng_xml];
          $order = $old_author['author_order']+1;
          $rc = $this->insert_any($ng_author,$item_id,$val,$order);
          if($rc === FALSE){
            return -errmsg(APP_MIGRATE, 'E3207',"item_id = ${item_id} val=${val} order=${order}");
          }
        }
      }
    }
    return 0;
  }
  
  /**
   * miglate publisher
   * 
   * @param integer$item_id
   * @param array $item_detail
   * @return integer 0:OK,less than 0:NG
   */
  protected function migrate_publisher($item_id,$item_detail) {
    $ng_publisher_array = $this->get_table_column_by_group('publisher');
    if($ng_publisher_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E3216');
    }
    
    $conv = array(
      'name' => 'publisher',
      'kana' => 'publisher_kana',
      'romaji' => 'publisher_romaji'
    );
    
    foreach ($ng_publisher_array as $ng_publisher) {
      $xml = $ng_publisher['xml'];
      if(array_key_exists($xml, $conv) == true){
        $ng_xml = $conv[$xml];
        $val = $item_detail[$ng_xml];
        $rc = $this->insert_any($ng_publisher,$item_id,$val);
        if($rc === FALSE){
          return -errmsg(APP_MIGRATE, 'E3217',"item_id=${item_id} val=${val}");
        }
      }
    }
    return 0;
  }

  /**
   * Article date migrate
   * 
   * @param integer $item_id
   * @param array   $item_detail 
   * @return integer 0:OK,less than 0:NG
   */
  protected function migrate_article_date($item_id,$item_detail) {
    $ng_article_date_array = $this->get_table_column_by_group('article_date');
    if($ng_article_date_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E3212');
    }    
    foreach ($ng_article_date_array as $ng_article_date){
      $xml = $ng_article_date['xml'];
      if($item_detail[$xml] !== ''){
        $val = $item_detail[$xml];
        $rc = $this->insert_any($ng_article_date,$item_id,$val);
        if($rc === FALSE){
          return -errmsg(APP_MIGRATE, 'E3213',"item_id=${item_id} val=${val}");
        }
      }
    }
    return 0;
  }

  /**
   * physical_descriptions migrate
   * 
   * @param integer $item_id
   * @return integer 0:OK,less than 0:NG
   */
  protected function migrate_physical_descriptions($item_id) {
    $old_physical_detail = $this->get_xnparticle_item_detail_child_physical_descriptions($item_id);
    if($old_physical_detail === FALSE){
      #Maybe data doesn't include xnparticle_item_detail_child_physical_descriptions.
      return 0;
    }elseif($old_physical_detail === null){
      return -errmsg(APP_MIGRATE, 'E3214',$item_id);
    }
    $ng_physical_array = $this->get_table_column_by_group('physical_descriptions');
    if($ng_physical_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E3215',$item_id);
    }       
    foreach ($old_physical_detail as $old_physical) {
      if($old_physical['physical_descriptions'] !== ''){
        $val = $old_physical['physical_descriptions'];
        $order= $old_physical['physical_descriptions_order']+1;
        $rc=  $this->insert_any($ng_physical_array, 
                                $item_id, 
                                $val,
                                $order);
        if($rc === FALSE){
          return -errmsg(APP_MIGRATE, 'E3216',"item_id=${item_id} val=${val} order=${order}");
        }
      }
    }
    return 0;
  }
  
  /**
   *jtitle migrate
   * 
   * @param integer $item_id
   * @param array $item_detail
   * @return integer 0:OK,less than 0:NG
   */
  protected function migrate_jtitle($item_id,$item_detail){
    $ng_jtitle_array = $this->get_table_column_by_group('jtitle');
    if($ng_jtitle_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E3218',$item_id);
    }     
    foreach ($ng_jtitle_array as $ng_jtitle) {
      if($ng_jtitle['xml'] === 'name'){
        $val = $item_detail['jtitle'];
      }else{
        $val = $item_detail[$ng_jtitle['xml']];
      }
      if($val !== ''){
        $rc = $this->insert_any($ng_jtitle,$item_id,$val);
        if($rc === FALSE){
          return -errmsg(APP_MIGRATE, 'E3219',"item_id=${item_id} val=${val}");
        }
      }
    }
    return 0;
  }
  
  /**
   * Migrate abstract
   * 
   * @param integer $item_id
   * @param array $item_detail
   * @return integer 0:OK,less than 0:NG
   */
  protected function migrate_abstract($item_id,$item_detail) {
    $ng_abstract = $this->get_table_column_by_group('abstract');
    
    if($item_detail['abstract'] !== ''){
      $val = $item_detail['abstract'];
      if($val !== ''){
        $rc = $this->insert_any($ng_abstract,$item_id,$val);
        if($rc === FALSE){
          return -errmsg(APP_MIGRATE, 'E3220',"item_id=${item_id} val=${val}");
        }      
      }
    }
    
    return 0;
  }
  
  /**
   * Migrate table_of_contents
   * 
   * @param integer $item_id
   * @param array $item_detail
   * @return integer 0:OK,less than 0:NG 
   */
  protected function migrate_table_of_contents($item_id,$item_detail) {
    $ng_table_of_contents = $this->get_table_column_by_group('table_of_contents');
    if($item_detail['table_of_contents'] !== ''){
      $val = $item_detail['table_of_contents'];
      $rc = $this->insert_any($ng_table_of_contents,$item_id,$val);
      if($rc === FALSE){
        return -errmsg(APP_MIGRATE, 'E3221',"item_id=${item_id} val=${val}");
      }      
    }
  }
  
  /**
   * keyword
   * 
   * @param integer $item_id
   * @return integer 0:OK,less than 0:NG
   */
  protected function migrate_keywords($item_id)
  {
    $tbl = get_tbl('xoonips_item_keyword');
    $wktbl = get_WK_tbl('xnparticle_item_detail_child_keywords');
      $sql = "insert into {$tbl} (item_id,keyword_id,keyword)".
      " select article_id,keywords_order+1,keywords from {$wktbl} where article_id={$item_id}";
    $result_array = $this->db->query($sql);
    if($result_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E3222',$item_id);
    }
    return 0;
  }

  /**
   * Migrate ndc_classification
   * 
   * @param integer $item_id
   * @return integer 0:OK,less than 0:NG
   */
  protected function migrate_ndc_classifications($item_id) {
    $old_classifications_detail = $this->get_xnparticle_item_detail_child_ndc_classifications($item_id);
    if($old_classifications_detail === FALSE){
      return 0;
    }elseif($old_classifications_detail === null){
      return -errmsg(APP_MIGRATE, 'E3223',$item_id);
    }
    $ng_ndc_classification = $this->get_table_column_by_group('ndc_classifications');
    if($ng_ndc_classification === FALSE){
      return -errmsg(APP_MIGRATE, 'E3224',$item_id);
    }
    
    foreach ($old_classifications_detail as $old_classification) {
        $classfication = $old_classification['ndc_classifications'];
        $classfication_order = $old_classification['ndc_classifications_order']+1;
        $rc = $this->insert_any($ng_ndc_classification,
                                $item_id,
                                $classfication,
                                $classfication_order);
        if($rc === FALSE){
          return -errmsg(APP_MIGRATE, 'E3225',"item_id=${item_id} val=${classfication} order=${classfication_order}");
        }
    }
    return 0;
  }
  
  /**
   * Migrate type_of_resourc
   * 
   * @param integer $item_id
   * @return integer 0:OK,less than 0:NG
   */
  protected function migrate_type_of_resource($item_id,$item_detail) {
    $ng_abstract = $this->get_table_column_by_group('type_of_resource');
    if($ng_abstract === FALSE){
      return -errmsg(APP_MIGRATE, 'E3227',$item_id);
    }
    
    if($item_detail['type_of_resource'] !== ''){
      $val = $item_detail['type_of_resource'];
      if($val !== ''){
        $rc = $this->insert_any($ng_abstract,$item_id,$val);
        if($rc === FALSE){
          return -errmsg(APP_MIGRATE, 'E3226',"item_id=${item_id} val=${val}");
        }      
      }
    }
    
    return 0;
  }

  /**
   * Migrate genre
   * 
   * @param integer $item_id
   * @param array $item_detail
   * @return integer 0:OK,less than 0:NG 
   */
  protected function migrate_genre($item_id,$item_detail) {
    $ng_genre = $this->get_table_column_by_group('genre');
    if($ng_genre === FALSE){
      return -errmsg(APP_MIGRATE, 'E3228',$item_id);
    }
    if($item_detail['genre'] !== ''){
      $val = $item_detail['genre'];
      if($val !== ''){
        $rc = $this->insert_any($ng_genre,$item_id,$val);
        if($rc === FALSE){
          return -errmsg(APP_MIGRATE, 'E3229',"item_id=${item_id} val=${val}");
        }      
      }
    }
    return 0;
  }
  
  /**
   * Migrate access_condition
   * 
   * @param integer $item_id
   * @param array $item_detail
   * @return integer 0:OK,less than 0:NG 
   */
  protected function migrate_access_condition($item_id,$item_detail) {
    $ng_access_condition = $this->get_table_column_by_group('access_condition');
    if($ng_access_condition === FALSE){
      return -errmsg(APP_MIGRATE, 'E3230',$item_id);
    }
    if($item_detail['access_condition'] !== ''){
      $val = $item_detail['access_condition'];
      if($val !== ''){
        $rc = $this->insert_any($ng_access_condition,$item_id,$val);
        if($rc === FALSE){
          return -errmsg(APP_MIGRATE, 'E3231',"item_id=${item_id} val=${val}");
        }      
      }
    }
    return 0;
  }
  
  /**
   * migrate_id_locals sub function.
   * 
   * @param array $old_detail
   * @param array $ng_id_local
   * @param string $val_key
   * @param string $order_key
   * @param integer $item_id
   * @return integer 0:OK,less than 0:NG  
   */
  protected function migrate_id_locals_to_ng($old_detail,$ng_id_local,$val_key,$order_key,$item_id){
    foreach ($old_detail as $detail) {
      $val = $detail[$val_key];
      $order = $detail[$order_key]+1;
      $rc = $this->insert_any($ng_id_local,$item_id,$val,$order);
      if($rc === FALSE){
        return -errmsg(APP_MIGRATE, 'E3238',"item_id=${item_id} key=${val_key} order=${order}");
      }
    }
    return 0;
  }
  
  /**
   * Migrate from old XooNips issn,isbn,doi,uri and local  to Next Generation XooNips id_locals;
   * 
   * @param integer $item_id
   * @return integer 0:OK,less than 0:NG  
   */
  protected function migrate_id_locals($item_id) {
    #They get old XooNips related tables.
    $old_issns_detail = $this->get_xnparticle_item_detail_child_id_issns($item_id);
    if($old_issns_detail === null){
      return -errmsg(APP_MIGRATE, 'E3232',$item_id);
    }
    
    $old_isbns_detail = $this->get_xnparticle_item_detail_child_id_isbns($item_id);
    if($old_isbns_detail === null){
      return -errmsg(APP_MIGRATE, 'E3233',$item_id);
    }
    
    $old_id_dois_detail = $this->get_xnparticle_item_detail_child_id_dois($item_id);
    if($old_id_dois_detail === null){
      return -errmsg(APP_MIGRATE, 'E3234',$item_id);
    }
    
    $old_uris_detail  = $this->get_xnparticle_item_detail_child_id_uris($item_id);
    if($old_uris_detail === null){
      return -errmsg(APP_MIGRATE, 'E3235',$item_id);
    }
    
    $old_local_detail = $this->get_xnparticle_item_detail_child_id_locals($item_id);
    if($old_local_detail === null){
      return -errmsg(APP_MIGRATE, 'E3236',$item_id);
    }

    $ng_id_locals_array = $this->get_table_column_by_group('id_locals');
    if($ng_id_locals_array === FALSE){
      return -errmsg(APP_MIGRATE, 'E3237',$item_id);
    }
    foreach ($ng_id_locals_array as $ng_id_local) {
      $rc = 0;
      switch ($ng_id_local['xml']) {
        case 'issn':
          if(is_array($old_issns_detail)){
            $rc = $this->migrate_id_locals_to_ng($old_issns_detail,$ng_id_local,'id_issns','id_issns_order',$item_id);
          }
          break;
        case 'id_locals_isbn':
          if(is_array($old_isbns_detail)){
            $rc = $this->migrate_id_locals_to_ng($old_isbns_detail,$ng_id_local,'id_isbns','id_isbns_order',$item_id);
          }
          break;
        case 'uri':
          if(is_array($old_uris_detail)){
            $rc = $this->migrate_id_locals_to_ng($old_uris_detail,$ng_id_local,'id_uris','id_uris_order',$item_id);
          }
          break;
        case 'id_dois':
          if(is_array($old_id_dois_detail)){
            $rc = $this->migrate_id_locals_to_ng($old_id_dois_detail,$ng_id_local,'id_dois','id_dois_order',$item_id);
          }
          break;
        case 'etc':
          if(is_array($old_local_detail)){
            $rc = $this->migrate_id_locals_to_ng($old_local_detail,$ng_id_local,'id_locals','id_locals_order',$item_id);
          }
          break;
      }
      if($rc < 0)return $rc;
    }
    
    return 0;
  }
  
  /**
   * Migrate from uris
   * 
   * @param integer $item_id
   * @return integer 0:OK,less than 0:NG  
   */
  protected function migrate_uris($item_id) {
    $old_uris_detail = $this->get_xnparticle_item_detail_child_uris($item_id);
    if($old_uris_detail === FALSE){
      return 0;
    }elseif($old_uris_detail === null){
      return -errmsg(APP_MIGRATE, 'E3239',$item_id);
    }
    $ng_uris = $this->get_table_column_by_group('uris');
    if($ng_uris === FALSE){
      return -errmsg(APP_MIGRATE, 'E3240',$item_id);
    }
    
    foreach ($old_uris_detail as $old_uris) {
      $val = $old_uris['uris'];
      $uris_order = $old_uris['uris_order']+1;
      $rc = $this->insert_any($ng_uris, $item_id, $val,$uris_order);
      if($rc === FALSE){
        return -errmsg(APP_MIGRATE, 'E3241',"item_id=${item_id} val=${val} uris_order=${uris_order}");
      }
    }
    return 0;
  }

  /**
   * Migrate download_limitation
   * 
   * @param integer $item_id
   * @param array $item_detail
   * @return integer 0:OK,less than 0:NG
   */
  protected function migrate_download_limitation($item_id,$item_detail) {
    $val = $item_detail['access_condition'];
    $ng_download_limitation = $this->get_table_column_by_group('download_limitation');
    if($ng_download_limitation === FALSE){
      return -errmsg(APP_MIGRATE, 'E3242',$item_id);
    }
    $rc = $this->insert_any($ng_download_limitation, $item_id, $val);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E3243',"item_id=${item_id} val=${val}");
    }    
    return 0;
  }
  
  /**
   * Set download notification
   * 
   * @param integer $item_id
   * @return integer 0:OK,less than 0:NG 
   */
  protected function set_download_notification($item_id){
    $ng_download_notification = $this->get_table_column_by_group('download_notification');
    if($ng_download_notification === FALSE){
      return -errmsg(APP_MIGRATE, 'E3244',$item_id);
    }
    $rc = $this->insert_any($ng_download_notification, $item_id, 0);
    if($rc === FALSE){
      return -errmsg(APP_MIGRATE, 'E3245',$item_id);
    }
    
    return 0;
  }

  /**
   * Migrate langs
   * 
   * @param integer $item_id
   * @return integer 0:OK,less than 0:NG
   */
  protected function migrate_lang($item_id) {
    $old_langs_detail = $this->get_xnparticle_item_detail_child_langs($item_id);
    if($old_langs_detail === FALSE){
      return 0;
    }elseif($old_langs_detail === null){
      return -errmsg(APP_MIGRATE, 'E3246',$item_id);
    }
    $ng_lang = $this->get_table_column_by_group('langs');
    if($ng_lang === FALSE){
      return -errmsg(APP_MIGRATE, 'E3247',$item_id);
    }
    foreach ($old_langs_detail as $old_lang) {
      $val = $old_lang['langs'];
      $order = $old_lang['langs_order']+1;
      $rc = $this->insert_any($ng_lang, $item_id, $val, $order);
      if($rc === FALSE){
        return -errmsg(APP_MIGRATE, 'E3248',"item_id=${item_id} val=${val} uris_order=${order}");
      }
    }
    return 0;
  }


  /*
   * 2.Implimentation junii2(Version 3.0)
   * Here,You must migrate xnparticle tables data from adding table or colmun to next generation
   * XooNips its.
   * 
   * I will summarize to implemnt migration subrouine.
   * 
   * (1)You must call that your xnparticle tables data get function.
   * (2)For next generation XooNips ,get_table_column_by_group call to get XooNIps table infomations.
   * (3)You call insert_any function.it apply to store xnparticle datas.
   */
  
  /*************************************************************************/
  /**
   * Main function migrate from xnparticle to next generation Xonnips.
   * 
   * @param type $item 
   */
  public function migrate($item){
    $item_id = $item['item_id']; //item_id means article_id in xnparticle.
    $item_detail = $this->get_xnparticle_item_detail($item_id);
    if($item_detail === FALSE || $item_detail === null){
      return -errmsg(APP_MIGRATE, 'E3201',$item_id);
    }
    
    #subtitle
    if(($rc = $this->migrate_subtitle($item_id))<0){
      return $rc;
    }
    
    #author
    if(($rc = $this->migrate_author($item_id))<0){
      return $rc;
    }
    
    #edition
    $edition_array = $this->get_table_column_by_group('edition');
    if($edition_array === null){
      return -errmsg(APP_MIGRATE, 'E3208',$item_id);
    }
    
    if(is_array($edition_array)){
      $edition_val = $item_detail['edition'];
      $rc = $this->insert_any($edition_array,$item_id,$edition_val);
      if($rc === FALSE){
        return -errmsg(APP_MIGRATE, 'E3209',"item_id=${item_id} val=${edition_val}");
      }
    }
    
    #publish_place
    $publish_place_array = $this->get_table_column_by_group('publish_place');
    if($publish_place_array === null){
      return -errmsg(APP_MIGRATE, 'E3210',$item_id);
    }
    
    if(is_array($publish_place_array)){
      $publish_val = $item_detail['publish_place'];
      $rc = $this->insert_any($publish_place_array,$item_id,$publish_val);
      if($rc === FALSE){
        return -errmsg(APP_MIGRATE, 'E3211',"item_id=${item_id} val=${publish_val}");
      }
    }
    
    #publisher
    if(($rc = $this->migrate_publisher($item_id,$item_detail)) < 0){
      return $rc;
    }
    
    #article_date
    if(($rc = $this->migrate_article_date($item_id,$item_detail)) < 0){
      return $rc;
    }
    
    #physical description
    if(($rc = $this->migrate_physical_descriptions($item_id)) < 0){
      return $rc;
    }
    
    #jtitle
    if(($rc = $this->migrate_jtitle($item_id,$item_detail)) < 0){
      return $rc;
    }
    
    #abstruct
    if(($rc = $this->migrate_abstract($item_id,$item_detail)) < 0){
      return $rc;
    }

    #table_of_contents
    if(($rc = $this->migrate_table_of_contents($item_id,$item_detail)) < 0){
      return $rc;
    }
    
    #keywords
    if(($rc = $this->migrate_keywords($item_id)) < 0){
      return $rc;
    }
    
    #ndc_classifications
    if(($rc = $this->migrate_ndc_classifications($item_id)) < 0){
      return $rc;
    }

    #type_of_resource
    if(($rc = $this->migrate_type_of_resource($item_id,$item_detail)) < 0){
      return $rc;
    }
    
    #migrate_genre
    if(($rc = $this->migrate_genre($item_id,$item_detail)) < 0){
      return $rc;
    }
    #access_condition
    if(($rc = $this->migrate_access_condition($item_id,$item_detail)) < 0){
      return $rc;
    }

    #id_locals
    if(($rc = $this->migrate_id_locals($item_id)) < 0){
      return $rc;
    }
    
    #uris
    if(($rc = $this->migrate_uris($item_id,$item_detail)) < 0){
      return $rc;
    }
    
    #download_limitation
    if(($rc = $this->migrate_download_limitation($item_id,$item_detail))<0){
      return $rc;
    }
      
    #download_notification
    if(($rc = $this->set_download_notification($item_id)) < 0){
      return $rc;
    }
    
    #langs
    if(($rc = $this->migrate_lang($item_id)) < 0){
      return $rc;
    }
    
     /*
      * 3.Implimentation junii2(Version 3.0)
      * 
      * Migrate functon above implimented call here.
      * 
      */
    return 0;
    
  }
  
};
?>
