<?php

require_once XOOPS_TRUST_PATH . '/libs/xoonips/class/core/BeanBase.class.php';
/**
 * @brief operate user_complement table 
 *
 */
class User_ComplementBean extends Xoonips_BeanBase {

	/**
	 * Constructor
	 **/
	public function User_ComplementBean($dirname, $trustDirname) {
		$this->Xoonips_BeanBase($dirname, $trustDirname);
		$this->setTableName('complement', true);
	}

	/**
	 * 
	 * get complementInfo
	 *
	 * @param
	 * @return array
	 */
	public function getComplementInfo() {
		$sql = "SELECT * FROM $this->table";
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		$ret = array();
		while ($row = $this->fetchArray($result)) {
			$ret[] = $row;
		}

		$this->freeRecordSet($result);
		return $ret;
	}

	/**
	 * 
	 * get complement detail info
	 *
	 * @param int $id complement_id
	 * @return array
	 */
	public function getComplementDetailInfo($id = NULL) {
		$table = $this->prefix($this->modulePrefix('complement_detail'));
		if (!is_null($id)) {
			$id = Xoonips_Utils::convertSQLNum($id);
			$sql = "SELECT * FROM $table WHERE complement_id=$id ORDER BY complement_detail_id";
		} else {
			$sql = "SELECT * FROM $table ORDER BY complement_detail_id";
		}
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		$ret = array();
		while ($row = $this->fetchArray($result)) {
			$ret[] = $row;
		}

		$this->freeRecordSet($result);
		return $ret;
	}

	/**
	 * 
	 * get complement list
	 *
	 * @return array
	 */
	public function getComplementList() {
		$groupTable = $this->prefix($this->modulePrefix('user_field_group'));
		$detailTable = $this->prefix($this->modulePrefix('user_field_detail'));
		$sql = "SELECT rt.complement_id, dt.user_detail_id, dt.name as detail_name, gt.name as group_name "
			. " FROM $this->table rt, $detailTable dt, $groupTable gt "
			. " WHERE rt.view_type_id=dt.view_type_id AND dt.group_id=gt.group_id";
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		$ret = array();
		while ($row = $this->fetchArray($result)) {
			$ret[] = $row;
		}

		$this->freeRecordSet($result);
		return $ret;
	}

	/**
	 * insert complement
	 *
	 * @param array $complement
	 * @param int $insertId
	 * @return bool true:success,false:failed
	 */
	public function insert($complement, &$insertId) {
		$viewTypeId = Xoonips_Utils::convertSQLNum($complement['view_type_id']);
		$title = Xoonips_Utils::convertSQLStr($complement['title']);
		$module = Xoonips_Utils::convertSQLStr($complement['module']);
		$sql = "INSERT INTO $this->table (view_type_id, title, module)";	
		$sql .= " VALUES( $viewTypeId , $title , $module )";
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		$insertId = $this->getInsertId();
		return true;
	}

	/**
	 * insert complement detail
	 *
	 * @param array $detail
	 * @param int $insertId
	 * @return bool true:success,false:failed
	 */
	public function insertDetail($detail, &$insertId) {
		$detailTable = $this->prefix($this->modulePrefix('complement_detail'));
		$complement_id = Xoonips_Utils::convertSQLNum($detail['complement_id']);
		$code = Xoonips_Utils::convertSQLStr($detail['code']);
		$title = Xoonips_Utils::convertSQLStr($detail['title']);
		$sql = "INSERT INTO $detailTable (complement_id, code, title)";	
		$sql .= " VALUES( $complement_id , $code , $title )";
		$result = $this->execute($sql);
		if (!$result) {
			return false;
		}
		$insertId = $this->getInsertId();
		return true;
	}
}

