package lib.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.Matcher;

import lib.io.ExtendFile;

/**
 * XMLp[T[
 * @version 0.03.10
 */
public class XMLParser {
	public static final String TEXT_NODE = "textNode";
    // TODO ꎞIpublic
    public ArrayList<XMLParser> nodeList = null;

    public String nodeName = null;

    public String innerText = null;

    public HashMap<String, String> attributes = null;

    public void setFile(File file) {

    }
    public void setNodeName(String name) {
        this.nodeName = name;
    }

    public String getNodeName() {
        return nodeName;
    }

    /**
     * RXgN^
     */
    public XMLParser() {
    	nodeList = new ArrayList<XMLParser>();
    	attributes = new HashMap<String, String>();
    }

    /**
     * RXgN^
     * @param nodeName
     */
    public XMLParser(String nodeName) {
    	this();
    	this.nodeName = nodeName;
    }
    /**
     * GNZt@Cw
     * GNZt@C̃pXw肵͂n߂܂
     * @param filePath
     * @throws FileNotFoundException
     */
    public void setFilePath(String filePath) throws FileNotFoundException{

        String xmlData = null;
        FileInputStream fis = null;
        String encoding = "UTF-8";
        byte[] byteData;
        try {
            File file = new File(filePath);
            fis = new FileInputStream(filePath);
            byteData = new byte[(int)file.length()];
            fis.read(byteData);

            byte[] head = new byte[5];
            for(int i = 0;i < 5;i++) {
                head[i] = byteData[i];
            }
            String headStr = new String(head);
            if("<?xml".equals(headStr)) {
                for(int i = 2;i < 100;i++) {
                    if(byteData[i] == '?') {
                        headStr = new String(byteData, 0, i);
                        break;
                    }
                }
                // wb_蕶R[h擾
                String str = setAttributes(headStr).get("encoding");
                if(str != null) {
                    encoding = str;
                }
            }
            // w蕶R[hŃoCg𕶎ɕϊ
            xmlData = new String(byteData, encoding);

            nodeList = new ArrayList<XMLParser>();
            nodeName = "document";
            setInnerText(xmlData);

        } catch (FileNotFoundException e) {
            e.printStackTrace();
            throw e;
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if(fis != null) {
                    fis.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * XML^ÕeLXgႢ͂
     *
     * @param objText
     * @return
     * @throws FileDataInvalidException
     */
    public int setInnerText(String objText) throws FileDataInvalidException{
        nodeList = new ArrayList<XMLParser>();
        int start = 0;
        int end = 0;
        while(true) {
            start = objText.indexOf("<",end);
            if(start < 0) {
                break;
            }
            if((start - end) > 0) {
                String text = objText.substring(end, start);
                XMLParser obj = new XMLParser();
                obj.nodeName = TEXT_NODE;
                obj.innerText = text;
                nodeList.add(obj);
            }
            if(objText.charAt(start + 1) == '/') {
                innerText = objText.substring(0, start);
                end = objText.indexOf(">", start);
                break;
            } else {
                start++;
                int endB = objText.indexOf(">", start);
                String inTag = objText.substring(start, endB);
                if(inTag.charAt(inTag.length() - 1) == '/') {
                    inTag = inTag.substring(0, inTag.length() - 1);
                }

                XMLParser obj = new XMLParser();
                obj.attributes = setAttributes(inTag);
                obj.nodeName = obj.attributes.get("nodeName");

                // ^O
                if(objText.charAt(endB - 1) == '/') {
                    end = endB + 1;
                    obj.innerText = "";
                } else {
                    endB++;
                    // TODO obt@͏
                    String buff = objText.substring(endB);
                    end = obj.setInnerText(buff) + endB + 1;
                }
                nodeList.add(obj);
            }
        }
        return end;
    }

    /**
     * ^ȎHashMapɕϊ
     * @param tagText
     * @return
     */
    private HashMap<String, String> setAttributes(String tagText) {
    	// TODO ɉsĂꍇ񂪂
        HashMap<String, String> map = new HashMap<String, String>();
        String[] buff = tagText.split("\\ ");

        map.put("nodeName", buff[0]);
        for(int i = 1;i < buff.length;i++) {
            String[] att = buff[i].split("\\=");
            if(att.length == 2) {
                String attr_1 = att[1];
                //att[1] = att[1].replaceAll("\"", "");
                char quote = attr_1.charAt(0);
                if(quote == '"' || quote == '\'') {
                    attr_1 = attr_1.substring(1);
                }
                quote = attr_1.charAt(attr_1.length() - 1);
                if(quote == '"' || quote == '\'') {
                    attr_1 = attr_1.substring(0, attr_1.length() - 1);
                }
                attr_1 = attr_1.replaceAll("\\&nbsp\\;", " ");
                map.put(att[0], attr_1);
            }
        }

        return map;
    }


    /**
     * ̒ǉ
     * @param key
     * @param value
     */
    public void setAttribute(String key, String value) {
    	this.attributes.put(key, value);
    }

    /**
     * l擾
     * @param key
     * @return
     */
    public String getAttribute(String key) {
    	return attributes.get(key);
    }

    /**
     * w肵^ÕIuWFNg擾
     * @param tagName ^O
     * @return 擾^OXg
     */
    public XMLParser getTag(String tagName) {
        XMLParser xmlObj = new XMLParser();
        xmlObj.nodeList = new ArrayList<XMLParser>();
        xmlObj.nodeName = tagName;
        // KwwXy[Xŋ؂
        String[] tagNames = tagName.split(" ");
        searchTag(this, tagNames, xmlObj, 0);
        return xmlObj;
    }
    /**
     * getTagŎw肵^O擾
     * @param src Ώۂ̃IuWFNg
     * @param tagNames ^OiXy[X؂Őeq֌Wj
     * @param xmlObj 擾IuWFNgi[
     * @param depth ̐[ieq֌W̊Kwj
     */
    private void searchTag(XMLParser src, String[] tagNames,
            XMLParser xmlObj, int depth) {
        if(depth == 0) {
            if(tagNames[0].equals(src.nodeName)) {
                int crtDepth = depth + 1;
                if(crtDepth == tagNames.length) {
                    if(xmlObj.nodeList==null) {
                        xmlObj.nodeList=new ArrayList<XMLParser>();
                    }
                    xmlObj.nodeList.add(src);
                }else{
                    for(XMLParser child:src.nodeList) {
                        searchTag(child, tagNames, xmlObj, crtDepth);
                    }
                }
            }
            if(src.nodeList != null) {
                for(XMLParser child:src.nodeList) {
                    searchTag(child, tagNames, xmlObj, depth);
                }
            }
        } else {
            if(tagNames[depth].equals(src.nodeName)) {
                int crtDepth = depth + 1;
                if(crtDepth == tagNames.length) {
                    if(xmlObj.nodeList == null) {
                        xmlObj.nodeList=new ArrayList<XMLParser>();
                    }
                    xmlObj.nodeList.add(src);
                } else {
                    for(XMLParser child:src.nodeList) {
                        searchTag(child, tagNames, xmlObj, crtDepth);
                    }
                }
            }
        }
    }

    /**
     * t@C
     * ݂̕ێĂc[f[^xmlt@Cɏo͂
     *
     * @param filePath
     * @throws IOException
     * @throws FileNotFoundException
     */
    public void xmlFileWrite(String filePath) throws IOException,
            FileNotFoundException{
    	// ^O̓q̐[
        int depth = 0;
        StringBuffer xml_file_buff = new StringBuffer();
        XMLParser root = nodeList.get(0);
        String encoding = root.attributes.get("encoding");
        if(encoding == null) {
            encoding = "UTF-8";
        }
        // wb_[o
        xml_file_buff.append("<?xml version=\"1.0\" encoding=\""
                + encoding + "\" standalone=\"yes\" ?> ");
        for(XMLParser child:root.nodeList) {
        	// eLXgm[ĥ͖o͂Ȃ
            if(!TEXT_NODE.equals(child.nodeName)){
                xml_file_buff.append(spaces(depth) + "<" + child.nodeName + " ");
            }
            bufferWrite(xml_file_buff, child, depth);
        }

        // svȉsE󔒕
        Pattern pattern = Pattern.compile("\r\n *\r\n");
        Matcher matcher = pattern.matcher(xml_file_buff.toString());
        String buff = matcher.replaceAll("\r\n");

        // obt@[ׂăt@Cɏ
        ExtendFile.FileWrite(buff, filePath, encoding);
    }
    /**
     * obt@
     * t@Co͗p̃obt@Ƀc[f[^
     * @param str_buff obt@
     * @param xmlList
     * @param depth
     */
    private void bufferWrite(StringBuffer str_buff, XMLParser xmlList,
            int depth) {

    	// ^Ȏlo͂
        List<String> keyList = getKeyList(xmlList.attributes);
        if(keyList.size() != 0) {
            for(String key :keyList) {
                if("nodeName".equals(key)) {
                    continue;
                }
                str_buff.append(" ");
                String value = xmlList.attributes.get(key);
                str_buff.append(key + "=\"" + value + "\"");
            }
        }
        // eLXĝ݂̃m[h
        if(TEXT_NODE.equals(xmlList.nodeName)) {
            str_buff.append(xmlList.innerText);

        // qvfێĂꍇċNĂяo
        } else if(xmlList.nodeList != null) {
            str_buff.append(">");
            depth++;
            for(XMLParser childList :xmlList.nodeList) {
            	// qvfeLXgm[h̏ꍇm[ho͂ȂB
                if(TEXT_NODE.equals(childList.nodeName)) {
                    bufferWrite(str_buff, childList, depth);
                } else {
                    str_buff.append("\r\n");
                    str_buff.append(spaces(depth) + "<" + childList.nodeName);
                    bufferWrite(str_buff, childList, depth);
                    str_buff.append(spaces(depth - 1));
                }
            }
            // ^Oo
            str_buff.append("</" + xmlList.nodeName + ">\r\n");
            depth--;
        } else {
            // ^O
            str_buff.append(" />\r\n");
        }
    }

    /**
     * w肵̃Xy[X쐬
     * @param depth
     * @return 쐬Xy[X
     */
    private String spaces(int depth) {
        String space = "";
        if(depth > 0) {
            for(int i = 0;i < depth;i++) {
                space += "  ";
            }
        }
        return space;
    }
    /**
     * MapkeỹXg쐬
     * @param map
     * @return keyXg
     */
    public List<String> getKeyList(Map<String, String> map) {
        List<String> keyList = new ArrayList<String>();
        if(map == null) {
            return keyList;
        }
        Set<String> keySet = map.keySet();
        Iterator<String> hash = keySet.iterator();
        while(hash.hasNext()) {
            String key = (String)hash.next();

            keyList.add(key);
        }
        return keyList;
    }

    /**
     * qvf̒ǉ
     * @param child
     */
    public void appendChild(XMLParser child) {
    	this.nodeList.add(child);
    }

    /**
     * eLXgm[h̃CX^X쐬eLXg}
     * @param innerText
     * @return
     */
    static public XMLParser createTextNode(String innerText) {
    	XMLParser textNode = new XMLParser();
    	textNode.nodeName = TEXT_NODE;
    	textNode.innerText = innerText;
    	textNode.nodeList = null;
    	return textNode;
    }


    /**
     * fobO\pɕϊ
     */
    public String toString() {
        String str = innerText;
        if(str == null) {
            str = "[null]";
        }
        str = str.replaceAll("\\r", "\\\\r");
        str = str.replaceAll("\\n", "\\\\n");
        return "[" + nodeName + "->\"" + innerText + "\"]";
    }

}
