package lib.xlsx.reader;

import java.util.ArrayList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

import lib.io.ExtendFile;
import lib.xml.XMLParser;

public class XlsxReader {
	/** ΏۃGNZt@C̐΃pX */
    private String filePath = null;
    /** ΃pXt@C̎擾 */
    private String fileName = null;
    /** gq ƗptH_ */
    private String tempName = null;

    /**
     * RXgN^.
     * t@CpXt@CAƃtH_쐬B
     *
     * @param filePath
     */
    public XlsxReader(String filePath) {
        this.filePath = filePath;
        File file = new File(filePath);
        if(file.exists()) {
            fileName = file.getName();
            int index = fileName.lastIndexOf(".");
            tempName = fileName.substring(0, index);
        }
    }
    /**
     * t@C̃Qb^[.
     * @return t@C
     */
    public String getFileName() {
        return fileName;
    }
    /**
     * ΏۃGNZt@C݂邩
     * @return
     */
    public boolean exists() {
        File file = new File(filePath);
        return file.exists();
    }

    /**
     * ΏۃGNZt@C̒gǂݍ
     * @param tempPath Ɨp̃fBNg
     * @throws IOException
     */
    public void load(String tempPath) throws IOException{

        tempPath += "/" + tempName + "/";
        // GNZZIP𓀂
        XLSX_UNZIP:{
            File tempFolder = new File(tempPath);
            if(!tempFolder.exists()) {
                tempFolder.mkdir();
            }
            ExtendFile xlsx = new ExtendFile(tempPath);
            ArrayList<String> fileList = xlsx.unzip(filePath, tempPath);
            System.out.println(fileList.size());
            break XLSX_UNZIP;
        }

        // "xl/worksheets"fBNgV[gǂݍ
        READ_SHEETS:{
            // ʃf[^XMLǂݍ
            String sharedStringPath = tempPath + "xl/sharedStrings.xml";
            String sheetsPath = tempPath + "xl/worksheets";
            ExtendFile xlsx = new ExtendFile(tempPath);
            ArrayList<File> fileList = new ArrayList<File>();
            xlsx.dirSearch(sheetsPath, fileList);

            // ʂ̃Zf[^i[
            String[] sharedString = null;
            READ_SHARED_STR:{
                XMLParser sharedStringObj = new XMLParser();
                try{
                    sharedStringObj.setFilePath(sharedStringPath);

                    // xmlt@C𐮌`ړÎߏo
                    sharedStringObj.xmlFileWrite("./xml/sharedStrings.xml");
                } catch(FileNotFoundException e) {
                    break READ_SHARED_STR;
                }

                // SI^OT^O擾
                sharedStringObj = sharedStringObj.getTag("si t");
                ArrayList<XMLParser> nodeList = sharedStringObj.nodeList;
                if(nodeList != null) {
                    sharedString = new String[nodeList.size()];
                    for(int i = 0;i < nodeList.size();i++) {
                        sharedString[i] = nodeList.get(i).innerText;
                    }
                }
                break READ_SHARED_STR;
            }
            // V[g1t@Cǂݍ
            for(File sheetFile: fileList) {
                StringBuffer text = new StringBuffer();
                XMLParser sheetXml = new XMLParser();
                sheetXml.setFilePath(sheetFile.getAbsolutePath());

                // row^Os擾
                XMLParser rowsObj = sheetXml.getTag("row");
                if(rowsObj.nodeList != null) {
                    for(XMLParser row:rowsObj.nodeList) {
                        XMLParser cells = row.getTag("c");
                        for(XMLParser cell_c:cells.nodeList) {
                            String strType = cell_c.getAttribute("t");

                            String cellStr = "";
                            XMLParser cell_v;
                            if("inlineStr".equals(strType)) {
                                cell_v = cell_c.getTag("is t");
                                cellStr = cell_v.nodeList.get(0).innerText;
                            } else {
                                cell_v = cell_c.getTag("v");
                                if(cell_v.nodeList.size() == 0) {
                                    cell_v.innerText = "";
                                } else {
                                    cell_v = cell_v.nodeList.get(0);
                                }
                                try{
                                    int index = Integer.parseInt(cell_v.innerText);
                                    cellStr = sharedString[index];
                                } catch(Exception e) {
                                    cellStr = cell_v.innerText;
                                    e.printStackTrace();
                                }
                            }

                            text.append(cellStr).append("\t");
                        }
                        text.append("\r\n");
                    }
                }
                System.out.println(sheetFile.getName());
                System.out.println(text);

                // xmlt@C𐮌`ړÎߏo
                sheetXml.xmlFileWrite("./xml/" + sheetFile.getName());
            }
            break READ_SHEETS;
        }
    }
}
