/*--------------------------------------------------------------------------
 *  Copyright 2009 Taro L. Saito
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *--------------------------------------------------------------------------*/
//--------------------------------------
// XerialJ
//
// RelationAttribute.java
// Since: Oct 13, 2009 12:21:23 PM
//
// $URL$
// $Author$
//--------------------------------------
package org.xerial.lens.relation.lang;

import org.xerial.lens.relation.NodeBase;

public class RelationAttribute extends NodeBase<RelationAttribute> {

    public static class Compare {
        public String operator;
        public String operand;
    }

    public static class PatternMatch {
        public String operand;
    }

    public String name;
    public String alias;
    public String nodeValue;
    public Compare compare;
    public PatternMatch patternMatch;

    @Override
    public String toString() {
        return String.format("%s%s%s", name, alias != null ? " as " + alias : "",
                nodeValue != null ? ":" + nodeValue : "");
    }

}
