/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.index;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import org.xerial.XerialException;
import org.xerial.util.StringUtil;
import org.xerial.util.XMLParserException;
import org.xerial.util.cui.OptionParser;
import org.xerial.util.cui.OptionParserException;
import org.xerial.util.graph.AdjacencyList;
import org.xerial.util.graph.GraphException;
import org.xerial.util.xml.SinglePath;
import org.xerial.util.xml.XMLException;
import org.xerial.util.xml.pullparser.PullParserUtil;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrongDataGuide {
    private AdjacencyList _graph = new AdjacencyList();
    private TreeMap<SinglePath, Integer> _path2idMap = new TreeMap();
    private HashMap<Integer, SinglePath> _id2pathMap = new HashMap();
    private int _currentPathID = 0;
    private Stack<Integer> _cursorHistory = new Stack();
    private SinglePath _currentPath = new SinglePath(SinglePath.PathType.AbsolutePath);

    public StrongDataGuide() {
        this._currentPathID = this._graph.addVertex();
        SinglePath root = new SinglePath(SinglePath.PathType.AbsolutePath);
        this._path2idMap.put(root, this._currentPathID);
        this._id2pathMap.put(this._currentPathID, root);
    }

    public void generateFrom(String xmlFile) throws FileNotFoundException, XMLParserException, XMLException, IOException, XerialException {
        BufferedReader reader = new BufferedReader(new FileReader(xmlFile));
        this.generateFrom(reader);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateFrom(Reader xmlReader) throws XMLParserException, XMLException, IOException, XerialException {
        parser = PullParserUtil.newParser(xmlReader);
        try {
            block8: while (true) lbl-1000:
            // 5 sources

            {
                if ((state = parser.next()) == 1) {
                    return;
                }
                switch (state) {
                    case 2: {
                        pathID = this.getPathID(parser.getName());
                        this.moveCursor(pathID);
                        i = 0;
                        while (true) {
                            if (i >= parser.getAttributeCount()) continue block8;
                            attributeID = this.getPathID("@" + parser.getAttributeName(i));
                            this.moveCursor(attributeID);
                            this.traceBack();
                            ++i;
                        }
                    }
                    case 3: {
                        this.traceBack();
                        ** break;
                    }
                    case 4: {
                        ** break;
                    }
                }
            }
        }
        catch (XmlPullParserException e) {
            throw new XMLException(e);
        }
        catch (GraphException e) {
            throw new XerialException(e);
        }
    }

    private void moveCursor(int pathID) throws GraphException {
        Set<Integer> destNodeID = this._graph.destNodeSet(this._currentPathID);
        if (!destNodeID.contains(pathID)) {
            this._graph.addEdge(this._currentPathID, pathID);
        }
        this._cursorHistory.push(this._currentPathID);
        this._currentPathID = pathID;
        this._currentPath = this._id2pathMap.get(pathID);
    }

    private void traceBack() {
        assert (!this._cursorHistory.empty());
        this._currentPathID = this._cursorHistory.pop();
        this._currentPath = this._id2pathMap.get(this._currentPathID);
    }

    private int getPathID(String tagName) {
        SinglePath path = new SinglePath(this._currentPath, tagName);
        Integer pathID = this._path2idMap.get(path);
        if (pathID == null) {
            pathID = this._graph.addVertex();
            this._path2idMap.put(path, pathID);
            this._id2pathMap.put(pathID, path);
        }
        return pathID;
    }

    public void outputGraphviz(OutputStream out) {
        PrintWriter gout = new PrintWriter(out);
        gout.println("digraph G {");
        for (int pathID : this._graph.vertexSet()) {
            SinglePath path = this._id2pathMap.get(pathID);
            gout.println(String.valueOf(pathID) + " [label=" + StringUtil.quote(path.getLeaf(), "\"") + "];");
        }
        for (int pathID : this._graph.vertexSet()) {
            try {
                Set<Integer> destNodeIDSet = this._graph.destNodeSet(pathID);
                for (int destNodeID : destNodeIDSet) {
                    gout.println(String.valueOf(pathID) + " -> " + destNodeID + ";");
                }
            }
            catch (GraphException e) {
                System.err.println(e.getMessage());
            }
        }
        gout.println("}");
        gout.flush();
    }

    public static void main(String[] args) throws OptionParserException {
        OptionParser<Opt> opt = new OptionParser<Opt>();
        opt.addOption(Opt.help, "h", "help", "display help messages");
        opt.parse(args);
        if (opt.isSet(Opt.help) || opt.getArgumentLength() < 1) {
            StrongDataGuide.printHelpMessage(opt);
            return;
        }
        StrongDataGuide sdg = new StrongDataGuide();
        try {
            sdg.generateFrom(opt.getArgument(0));
            sdg.outputGraphviz(System.out);
        }
        catch (XerialException e) {
            System.err.println(e.getMessage());
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    private static void printHelpMessage(OptionParser<Opt> opt) {
        System.out.println("usage: > java -jar StrongDataGuide.jar [option] xml_file");
        System.out.println(opt.helpMessage());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Opt {
        help;

    }
}

