/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.xml.dom;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xerial.util.StringUtil;
import org.xerial.util.xml.XMLException;
import org.xerial.util.xml.dom.IterableNodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMUtil {
    private DOMUtil() {
    }

    public static String getTextContent(Element parentElement, String tagName) {
        NodeList tagList = parentElement.getElementsByTagName(tagName);
        return null;
    }

    public static HashMap<String, String> getTextContentMap(InputStream xmlStream) throws XMLException, IOException {
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = docBuilder.parse(xmlStream);
            Element rootElem = doc.getDocumentElement();
            return DOMUtil.getTextContentMap(rootElem);
        }
        catch (ParserConfigurationException e) {
            throw new XMLException(e);
        }
        catch (SAXException e) {
            throw new XMLException(e);
        }
    }

    public static HashMap<String, String> getTextContentMap(Element element) {
        String currentPath = "";
        DOMReadProcess readProcess = new DOMReadProcess();
        readProcess.traceSubTree(element);
        return readProcess.getContentMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DOMReadProcess {
        LinkedList<String> _relativePath = new LinkedList();
        HashMap<String, String> _path2contentMap = new HashMap();

        public void traceSubTree(Element subtreeRoot) {
            String tagName = subtreeRoot.getTagName();
            this._relativePath.add(tagName);
            if (subtreeRoot.hasAttributes()) {
                String currentPath = this.getCurrentPath();
                NamedNodeMap attribMap = subtreeRoot.getAttributes();
                int i = 0;
                while (i < attribMap.getLength()) {
                    Attr attrib = (Attr)attribMap.item(i);
                    String attribPath = String.valueOf(currentPath) + "/@" + attrib.getName();
                    this._path2contentMap.put(attribPath, attrib.getValue());
                    ++i;
                }
            }
            StringBuilder contentBuffer = new StringBuilder();
            IterableNodeList childNodes = new IterableNodeList(subtreeRoot.getChildNodes());
            for (Node node : childNodes) {
                switch (node.getNodeType()) {
                    case 1: {
                        this.traceSubTree((Element)node);
                        break;
                    }
                    case 3: {
                        Text text = (Text)node;
                        contentBuffer.append(text.getData());
                        break;
                    }
                    case 4: {
                        CDATASection cdata = (CDATASection)node;
                        contentBuffer.append(cdata.getData());
                    }
                }
            }
            String textContent = contentBuffer.toString();
            if (!StringUtil.isWhiteSpace(textContent)) {
                this._path2contentMap.put(this.getCurrentPath(), contentBuffer.toString());
            }
            this._relativePath.removeLast();
        }

        public HashMap<String, String> getContentMap() {
            return this._path2contentMap;
        }

        String getCurrentPath() {
            StringBuilder pathExprBuilder = new StringBuilder();
            for (String tag : this._relativePath) {
                pathExprBuilder.append("/");
                pathExprBuilder.append(tag);
            }
            return pathExprBuilder.substring(1);
        }
    }
}

