/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.xml.analyzer;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.TreeMap;
import java.util.TreeSet;
import org.xerial.XerialException;
import org.xerial.util.cui.OptionParser;
import org.xerial.util.cui.OptionParserException;
import org.xerial.util.xml.SinglePath;
import org.xerial.util.xml.XMLException;
import org.xerial.util.xml.pullparser.PullParserUtil;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XMLNodeRelationAnalyzer {
    private OptionParser<Opt> _opt = new OptionParser();

    public XMLNodeRelationAnalyzer() throws OptionParserException {
        this._opt.addOption(Opt.help, "h", "help", "display help message");
    }

    public static void main(String[] args) {
        try {
            XMLNodeRelationAnalyzer instance = new XMLNodeRelationAnalyzer();
            instance.perform(args);
        }
        catch (XerialException e) {
            System.err.println(e.getMessage());
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    public void perform(String[] args) throws OptionParserException, IOException, XerialException {
        this._opt.parse(args);
        if (this._opt.isSet(Opt.help) || this._opt.getArgumentLength() < 1) {
            this.printHelpMessage();
            return;
        }
        String xmlFile = this._opt.getArgument(0);
        FileReader xmlFileReader = new FileReader(xmlFile);
        XmlPullParser parser = PullParserUtil.newParser(xmlFileReader);
        ParseProcess parseProcess = new ParseProcess(parser);
        parseProcess.parse();
        for (String tag : parseProcess.tag2relatedTagNames.keySet()) {
            System.out.print(String.valueOf(tag) + ":\t");
            for (String related : parseProcess.tag2relatedTagNames.get(tag)) {
                System.out.print(String.valueOf(related) + " ");
            }
            System.out.println();
        }
        ((Reader)xmlFileReader).close();
    }

    private void printHelpMessage() {
        System.out.println("usage: > java XMLNodeRelationAnalyzer.jar [option] xml_file");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Opt {
        help;

    }

    class NodeRelation {
        NodeRelation() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ParseProcess {
        XmlPullParser parser;
        SinglePath currentPath = new SinglePath(SinglePath.PathType.AbsolutePath);
        TreeMap<String, TreeSet<String>> tag2relatedTagNames = new TreeMap();
        int pathCount = 0;

        ParseProcess(XmlPullParser parser) {
            this.parser = parser;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void parse() throws IOException, XMLException {
            try lbl-1000:
            // 2 sources

            {
                while (true) {
                    if ((state = this.parser.next()) == 1) {
                        return;
                    }
                    switch (state) {
                        case 2: {
                            currentTag = this.parser.getName();
                            this.currentPath.addChild(currentTag);
                            relatedTagSet = this.getRelatedTagSet(currentTag);
                            var5_7 = this.currentPath.iterator();
                            while (true) {
                                if (var5_7.hasNext()) ** GOTO lbl15
                                i = 0;
                                if (true) ** GOTO lbl33
lbl15:
                                // 1 sources

                                t = var5_7.next();
                                if (t.equals(currentTag)) continue;
                                relatedTagSet.add(t);
                                relatedTagSet2 = this.getRelatedTagSet(t);
                                relatedTagSet2.add(currentTag);
                            }
                        }
                        case 3: {
                            this.currentPath.removeLastChild();
                            break;
                        }
                        case 0: {
                            break;
                        }
                    }
                    continue;
                    break;
                }
            }
            catch (XmlPullParserException e) {
                throw new XMLException(e);
            }
            do {
                ++i;
lbl33:
                // 2 sources

            } while (i < this.parser.getAttributeCount());
            ** while (true)
        }

        private TreeSet<String> getRelatedTagSet(String tag) {
            TreeSet<String> s = this.tag2relatedTagNames.get(tag);
            if (s == null) {
                s = new TreeSet();
                this.tag2relatedTagNames.put(tag, s);
            }
            return s;
        }
    }
}

