/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.cui;

import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.xerial.util.cui.Option;
import org.xerial.util.cui.OptionDescriptionContainer;
import org.xerial.util.cui.OptionGroup;
import org.xerial.util.cui.OptionParserException;
import org.xerial.util.cui.OptionWithArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionParser<OptionID extends Comparable> {
    private OptionGroup<OptionID> _rootOptionGroup = new OptionGroup("");
    private Vector<String> _argumentList = new Vector();
    private TreeSet<String> _activeGroupSet = new TreeSet();
    private TreeSet<OptionID> _optionIDSet = new TreeSet();

    public void addOption(OptionID optionID, String shortOptionName, String longOptionName, String description) throws OptionParserException {
        this.addNewOptionID(optionID);
        this._rootOptionGroup.addOption(optionID, shortOptionName, longOptionName, description);
    }

    public void addOption(OptionID optionID, String shortOptionName, String longOptionName, String description, boolean presetValue) throws OptionParserException {
        this.addNewOptionID(optionID);
        this._rootOptionGroup.addOption(optionID, shortOptionName, longOptionName, description, presetValue);
    }

    public void addOptionWithArgument(OptionID optionID, String shortOptionName, String longOptionName, String argumentName, String description) throws OptionParserException {
        this.addNewOptionID(optionID);
        this._rootOptionGroup.addOptionWithArgment(optionID, shortOptionName, longOptionName, argumentName, description);
    }

    public void addOptionWithArgument(OptionID optionID, String shortOptionName, String longOptionName, String argumentName, String description, Object defaultValue) throws OptionParserException {
        this.addNewOptionID(optionID);
        this._rootOptionGroup.addOptionWithArgment(optionID, shortOptionName, longOptionName, argumentName, description, defaultValue);
    }

    public void addOptionGroup(OptionGroup<OptionID> optionGroup) throws OptionParserException {
        LinkedList optionIDList = new LinkedList();
        optionGroup.collectOptionID(optionIDList);
        for (Comparable optID : optionIDList) {
            this.addNewOptionID(optID);
        }
        this._rootOptionGroup.addOptionGroup(optionGroup);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(String[] args) throws OptionParserException {
        int index = 0;
        while (index < args.length) {
            OptionWithArgument optWithArg;
            Option<OptionID> opt;
            String arg = args[index];
            if (arg.startsWith("--")) {
                int splitPos = arg.indexOf(61);
                if (splitPos == -1) {
                    String longOptionName = arg.substring(2);
                    opt = this._rootOptionGroup.findByLongOptionName(longOptionName);
                    if (opt == null) {
                        throw new OptionParserException("unknown option --" + longOptionName);
                    }
                    if (opt.takeArgument()) {
                        throw new OptionParserException("parameter value is required for --" + longOptionName);
                    }
                    opt.set();
                } else {
                    String longOptionName = arg.substring(2, splitPos);
                    String value = arg.substring(splitPos + 1);
                    opt = this._rootOptionGroup.findByLongOptionName(longOptionName);
                    if (opt == null) {
                        throw new OptionParserException("unknown option --" + longOptionName);
                    }
                    if (!(opt instanceof OptionWithArgument)) throw new OptionParserException("syntax error --" + longOptionName);
                    optWithArg = (OptionWithArgument)opt;
                    optWithArg.set();
                    optWithArg.setArgumentValue(value);
                }
            } else if (arg.startsWith("-")) {
                String shortOptionList = arg.substring(1);
                int i = 0;
                while (i < shortOptionList.length()) {
                    String shortOption = shortOptionList.substring(i, i + 1);
                    opt = this._rootOptionGroup.findByShortOptionName(shortOption);
                    if (opt == null) {
                        throw new OptionParserException("unknown option -" + shortOption);
                    }
                    if (opt.takeArgument()) {
                        if (shortOptionList.length() != 1) {
                            throw new OptionParserException("options with argument must be isolated: -" + shortOption);
                        }
                        if (opt instanceof OptionWithArgument) {
                            optWithArg = (OptionWithArgument)opt;
                            if (++index >= args.length) throw new OptionParserException("parameter value is required for -" + shortOption);
                            optWithArg.setArgumentValue(args[index]);
                        }
                    }
                    opt.set();
                    ++i;
                }
            } else {
                this._argumentList.add(arg);
            }
            ++index;
        }
        this._rootOptionGroup.validateExclusiveness();
    }

    public List<String> getArgument() {
        return this._argumentList;
    }

    public String getArgument(int index) {
        return this._argumentList.get(index);
    }

    public int getArgumentLength() {
        return this._argumentList.size();
    }

    public boolean isSet(OptionID optionID) throws OptionParserException {
        Option<OptionID> option = this.findOption(optionID);
        if (option == null) {
            throw new OptionParserException("unknown option ", optionID);
        }
        return option.isSet();
    }

    public int getIntValue(OptionID optionID) throws OptionParserException {
        try {
            return Integer.parseInt(this.getValue(optionID));
        }
        catch (NumberFormatException e) {
            throw new OptionParserException(e);
        }
    }

    public double getDoubleValue(OptionID optionID) throws OptionParserException {
        try {
            return Double.parseDouble(this.getValue(optionID));
        }
        catch (NumberFormatException e) {
            throw new OptionParserException(e);
        }
    }

    public float getFloatValue(OptionID optionID) throws OptionParserException {
        try {
            return Float.parseFloat(this.getValue(optionID));
        }
        catch (NumberFormatException e) {
            throw new OptionParserException(e);
        }
    }

    public String getValue(OptionID optionID) throws OptionParserException {
        Option<OptionID> targetOption = this._rootOptionGroup.findOption(optionID);
        if (targetOption == null) {
            throw new OptionParserException("unknown option: ", optionID);
        }
        if (!(targetOption instanceof OptionWithArgument)) {
            throw new OptionParserException("option ", optionID, " cannot take any argument");
        }
        OptionWithArgument optWithArg = (OptionWithArgument)targetOption;
        return optWithArg.getArgumentValue();
    }

    public String helpMessage() {
        OptionDescriptionContainer container = new OptionDescriptionContainer();
        this._rootOptionGroup.collectOptionDescriptions(container);
        return container.toString();
    }

    private Option<OptionID> findOption(OptionID optionID) {
        return this._rootOptionGroup.findOption(optionID);
    }

    private void addNewOptionID(OptionID newOptionID) throws OptionParserException {
        if (this._optionIDSet.contains(newOptionID)) {
            throw new OptionParserException("duplicate addition of OptionID ", newOptionID);
        }
        this._optionIDSet.add(newOptionID);
    }
}

