/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.cui;

import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.xerial.util.cui.Option;
import org.xerial.util.cui.OptionComposite;
import org.xerial.util.cui.OptionDescriptionContainer;
import org.xerial.util.cui.OptionParserException;
import org.xerial.util.cui.OptionWithArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionGroup<OptionID extends Comparable>
extends OptionComposite<OptionID> {
    LinkedList<OptionComposite<OptionID>> _contents = new LinkedList();
    String _groupName;
    boolean _isActive = false;
    boolean _isExclusive = false;

    public OptionGroup(String groupName) {
        super(null);
        this._groupName = groupName;
    }

    public OptionGroup(String groupName, boolean isExclusive) {
        super(null);
        this._groupName = groupName;
        this._isExclusive = isExclusive;
    }

    public void addOption(OptionID optionID, String shortOptionName, String longOptionName, String description) {
        this._contents.add(new Option<OptionID>(this, optionID, shortOptionName, longOptionName, description));
    }

    public void addOption(OptionID optionID, String shortOptionName, String longOptionName, String description, boolean presetValue) {
        this._contents.add(new Option<OptionID>(this, optionID, shortOptionName, longOptionName, description, presetValue));
    }

    public void addOptionWithArgment(OptionID optionID, String shortOptionName, String longOptionName, String argumentName, String description) {
        this._contents.add(new OptionWithArgument<OptionID>(this, optionID, shortOptionName, longOptionName, argumentName, description));
    }

    public void addOptionWithArgment(OptionID optionID, String shortOptionName, String longOptionName, String argumentName, String description, Object defaultValue) {
        this._contents.add(new OptionWithArgument<OptionID>(this, optionID, shortOptionName, longOptionName, argumentName, description, defaultValue));
    }

    public void addOptionGroup(OptionGroup<OptionID> optionGroup) {
        optionGroup.setParent(this);
        this._contents.add(optionGroup);
    }

    @Override
    protected void collectOptionDescriptions(OptionDescriptionContainer container) {
        if (!this._groupName.equals("")) {
            container.addDescription("[" + this._groupName + "]");
        }
        for (OptionComposite<OptionID> opt : this.getChildren()) {
            opt.collectOptionDescriptions(container);
        }
    }

    List<OptionComposite<OptionID>> getChildren() {
        return this._contents;
    }

    @Override
    protected Option<OptionID> findByLongOptionName(String longOption) {
        for (OptionComposite<OptionID> opt : this.getChildren()) {
            Option<OptionID> searchResult = opt.findByLongOptionName(longOption);
            if (searchResult == null) continue;
            return searchResult;
        }
        return null;
    }

    @Override
    protected Option<OptionID> findByShortOptionName(String shortOption) {
        for (OptionComposite<OptionID> opt : this.getChildren()) {
            Option<OptionID> searchResult = opt.findByShortOptionName(shortOption);
            if (searchResult == null) continue;
            return searchResult;
        }
        return null;
    }

    @Override
    protected Option<OptionID> findOption(OptionID optionID) {
        for (OptionComposite<OptionID> opt : this.getChildren()) {
            Option<OptionID> searchResult = opt.findOption(optionID);
            if (searchResult == null) continue;
            return searchResult;
        }
        return null;
    }

    @Override
    protected void collectOptionID(List<OptionID> optionIDList) {
        for (OptionComposite<OptionID> opt : this.getChildren()) {
            opt.collectOptionID(optionIDList);
        }
    }

    public boolean isActive() {
        return this._isActive;
    }

    public void activate() {
        this._isActive = true;
    }

    public String getGroupName() {
        return this._groupName;
    }

    boolean isExclusive() {
        return this._isExclusive;
    }

    void validateExclusiveness() throws OptionParserException {
        TreeSet<String> activeAndIncompatibleGroups = new TreeSet<String>();
        for (OptionComposite optionComposite : this._contents) {
            if (!(optionComposite instanceof OptionGroup)) continue;
            OptionGroup optGroup = (OptionGroup)optionComposite;
            if (optGroup.isExclusive() && optGroup.isActive()) {
                activeAndIncompatibleGroups.add(optGroup.getGroupName());
            }
            optGroup.validateExclusiveness();
        }
        if (activeAndIncompatibleGroups.size() > 1) {
            throw new OptionParserException("options in groups " + activeAndIncompatibleGroups + " cannot be set simultaneously");
        }
    }
}

