/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.xml.pullparser;

import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xerial.util.xml.InvalidXMLException;
import org.xerial.util.xml.XMLException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class DOMBuilder {
    public Element parse(Reader xmlReader) throws XmlPullParserException, IOException, XMLException {
        XmlPullParserFactory parserFactory = XmlPullParserFactory.newInstance();
        XmlPullParser parser = parserFactory.newPullParser();
        parser.setInput(xmlReader);
        parser.next();
        return this.parse(parser);
    }

    public Element parse(XmlPullParser pullParser) throws XMLException, IOException {
        return this.parseSubTree(pullParser);
    }

    protected Element parseSubTree(XmlPullParser pullParser) throws XMLException, IOException {
        Document document = this.createNewDOMDocument();
        try {
            return this.parseElement(pullParser, document);
        }
        catch (XmlPullParserException e) {
            throw new InvalidXMLException(e);
        }
    }

    protected Element parseElement(XmlPullParser pullParser, Document document) throws XmlPullParserException, InvalidXMLException, IOException {
        String tagName;
        pullParser.require(2, null, null);
        String qName = tagName = pullParser.getName();
        Element element = document.createElement(qName);
        int i = 0;
        while (i < pullParser.getAttributeCount()) {
            String attributeName = pullParser.getAttributeName(i);
            String attributeValue = pullParser.getAttributeValue(i);
            element.setAttribute(attributeName, attributeValue);
            ++i;
        }
        while (pullParser.next() != 3) {
            switch (pullParser.getEventType()) {
                case 2: {
                    Element childElement = this.parseElement(pullParser, document);
                    element.appendChild(childElement);
                    break;
                }
                case 4: {
                    String text = pullParser.getText();
                    Text textElement = document.createTextNode(text);
                    element.appendChild(textElement);
                    break;
                }
                default: {
                    throw new InvalidXMLException("line " + pullParser.getLineNumber() + ": tag <" + qName + "> is not closed");
                }
            }
        }
        pullParser.require(3, null, tagName);
        return element;
    }

    protected String createQName(String prefix, String name) {
        return prefix == null ? name : String.valueOf(prefix) + ":" + name;
    }

    protected Document createNewDOMDocument() throws XMLException {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = builderFactory.newDocumentBuilder();
            return docBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new XMLException(e);
        }
    }
}

