/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.xml.bean;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xerial.util.XMLParserException;
import org.xerial.util.xml.InvalidXMLException;
import org.xerial.util.xml.SinglePath;
import org.xerial.util.xml.bean.XMLBeanException;
import org.xerial.util.xml.bean.XMLOutputProcess;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLBeanUtil {
    static String[] _primitiveClassNames = new String[]{"int", "double", "float", "boolean", "String", "Integer", "Double", "Float", "Boolean"};
    private static Pattern _setMethodPattern = Pattern.compile("^set(\\S)(\\S*)");
    private static Pattern _getMethodPattern = Pattern.compile("^get(\\S)(\\S*)");
    private static HashSet<String> _primitiveClassSet = new HashSet();

    static {
        String[] stringArray = _primitiveClassNames;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String s = stringArray[n];
            _primitiveClassSet.add(s);
            ++n;
        }
    }

    private XMLBeanUtil() {
    }

    public static <E> E newInstance(Class<E> xmlBeanClass, InputStream xmlStream) throws IOException, XMLParserException, XMLBeanException, InvalidXMLException {
        XmlPullParser parser;
        try {
            parser = XmlPullParserFactory.newInstance().newPullParser();
            parser.setInput(xmlStream, null);
        }
        catch (XmlPullParserException e) {
            throw new XMLParserException(e);
        }
        return XMLBeanUtil.newInstance(xmlBeanClass, parser);
    }

    public static <E> E newInstance(Class<E> xmlBeanClass, XmlPullParser pullParser) throws IOException, XMLBeanException, InvalidXMLException {
        E obj;
        if (xmlBeanClass == null) {
            throw new XMLBeanException("an invalid class is passed to the poplulate method");
        }
        try {
            obj = xmlBeanClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new XMLBeanException("cannot instantiate the class " + xmlBeanClass.getSimpleName());
        }
        catch (IllegalAccessException e) {
            throw new XMLBeanException("cannot instantiate the class " + xmlBeanClass.getSimpleName());
        }
        XMLBeanUtil.populate(obj, pullParser);
        return obj;
    }

    public static void populate(Object xmlBean, XmlPullParser pullParser) throws IOException, XMLBeanException, InvalidXMLException {
        if (xmlBean == null) {
            throw new XMLBeanException("an invalid instance is passed to the poplulate method");
        }
        BindRuleCreationProcess ruleGenerator = new BindRuleCreationProcess();
        ruleGenerator.createBindRule(new SinglePath(), xmlBean.getClass());
        ParseAndBindProcess parseProcess = new ParseAndBindProcess(pullParser, ruleGenerator.getBindRule());
        parseProcess.parse(xmlBean);
    }

    public static void populate(Object xmlBean, InputStream xmlStream) throws XMLParserException, IOException, XMLBeanException, InvalidXMLException {
        try {
            XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
            parser.setInput(xmlStream, null);
            XMLBeanUtil.populate(xmlBean, parser);
        }
        catch (XmlPullParserException e) {
            throw new XMLParserException(e);
        }
    }

    static String pickPropertyName(String methodName, SetterOrGetter patternType) {
        Matcher m = null;
        switch (patternType.ordinal()) {
            case 0: {
                m = _setMethodPattern.matcher(methodName);
                break;
            }
            case 1: {
                m = _getMethodPattern.matcher(methodName);
                break;
            }
            default: {
                return null;
            }
        }
        if (!m.matches()) {
            return null;
        }
        return String.valueOf(m.group(1).toLowerCase()) + m.group(2);
    }

    static boolean isPrimitive(Class c) {
        String typeName = c.getSimpleName();
        if (typeName.endsWith("[]")) {
            return _primitiveClassSet.contains(typeName.substring(0, typeName.length() - 2));
        }
        return _primitiveClassSet.contains(typeName);
    }

    public static void outputAsXML(Object xmlBean, OutputStream out) throws XMLBeanException, InvalidXMLException {
        XMLOutputProcess outputProcess = new XMLOutputProcess(out);
        outputProcess.outputAsXML(xmlBean);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParseAndBindProcess {
        private XmlPullParser _parser;
        private TreeMap<SinglePath, BindRule> _bindRule;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !ParseAndBindProcess.class.desiredAssertionStatus();
        }

        public ParseAndBindProcess(XmlPullParser pullParser, TreeMap<SinglePath, BindRule> bindRule) {
            this._parser = pullParser;
            this._bindRule = bindRule;
        }

        public void parse(Object currentObject) throws IOException, InvalidXMLException, XMLBeanException {
            try {
                if (this._parser.getEventType() != 2) {
                    while (this._parser.next() != 2) {
                    }
                }
                this.parse(currentObject, new SinglePath());
            }
            catch (XmlPullParserException e) {
                throw new InvalidXMLException(e);
            }
            catch (NumberFormatException e) {
                throw new InvalidXMLException(e);
            }
            catch (IllegalArgumentException e) {
                throw new XMLBeanException(e);
            }
            catch (IllegalAccessException e) {
                throw new XMLBeanException(e);
            }
            catch (InvocationTargetException e) {
                throw new XMLBeanException(e);
            }
        }

        private void parse(Object currentObject, SinglePath currentPath) throws IOException, XmlPullParserException, XMLBeanException, NumberFormatException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            BindRule rule;
            BindRule rule2;
            this._parser.require(2, null, null);
            TreeMap<String, Vector<String>> arrayObjectContainer = new TreeMap<String, Vector<String>>();
            TreeMap beanArrayContainer = new TreeMap();
            TreeMap<String, BindRule> bindRuleContainer = new TreeMap<String, BindRule>();
            int i = 0;
            while (i < this._parser.getAttributeCount()) {
                String attribName = this._parser.getAttributeName(i);
                SinglePath attribPath = new SinglePath(currentPath, attribName);
                rule2 = this._bindRule.get(attribPath);
                if (rule2 != null && rule2.canInvokeSetMethod()) {
                    rule2.bind(currentObject, this._parser.getAttributeValue(i));
                }
                ++i;
            }
            while (this._parser.next() != 3) {
                int state = this._parser.getEventType();
                block1 : switch (state) {
                    case 2: {
                        String tagName = this._parser.getName();
                        tagName = tagName.replace('-', '_');
                        tagName = tagName.toLowerCase();
                        SinglePath childPath = new SinglePath(currentPath, tagName);
                        rule2 = this._bindRule.get(childPath);
                        if (rule2 == null) {
                            while (this._parser.next() != 3) {
                            }
                            break;
                        }
                        switch (rule2.getBindType().ordinal()) {
                            case 0: {
                                String textContent = this._parser.nextText();
                                if (rule2.isArrayType()) {
                                    Vector<String> array = (Vector<String>)arrayObjectContainer.get(tagName);
                                    if (array == null) {
                                        array = new Vector<String>();
                                        bindRuleContainer.put(tagName, rule2);
                                    }
                                    array.add(textContent);
                                    arrayObjectContainer.put(tagName, array);
                                    break block1;
                                }
                                rule2.bind(currentObject, textContent);
                                break block1;
                            }
                            case 1: {
                                try {
                                    Object childObj = rule2.getElementClass().newInstance();
                                    this.parse(childObj, childPath);
                                    if (rule2.isArrayType()) {
                                        Vector beanArray = (Vector)beanArrayContainer.get(tagName);
                                        if (beanArray == null) {
                                            beanArray = new Vector();
                                            bindRuleContainer.put(tagName, rule2);
                                        }
                                        beanArray.add(childObj);
                                        beanArrayContainer.put(tagName, beanArray);
                                        break block1;
                                    }
                                    rule2.bindObject(currentObject, childObj);
                                    break block1;
                                }
                                catch (InstantiationException e) {
                                    throw new XMLBeanException("cannot instantiate the class " + rule2.getElementClass().getSimpleName());
                                }
                                catch (IllegalAccessException e) {
                                    throw new XMLBeanException("cannot instantiate the class " + rule2.getElementClass().getSimpleName());
                                }
                            }
                        }
                    }
                }
            }
            for (String tag : arrayObjectContainer.keySet()) {
                rule = (BindRule)bindRuleContainer.get(tag);
                if (!$assertionsDisabled && rule == null) {
                    throw new AssertionError();
                }
                Vector array = (Vector)arrayObjectContainer.get(tag);
                rule.bindArray(currentObject, array);
            }
            for (String tag : beanArrayContainer.keySet()) {
                rule = (BindRule)bindRuleContainer.get(tag);
                if (!$assertionsDisabled && rule == null) {
                    throw new AssertionError();
                }
                Vector beanArray = (Vector)beanArrayContainer.get(tag);
                rule.bindBeanArray(currentObject, beanArray);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BindType {
        invokeMethod,
        nestedElement;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ArgType {
        p_int,
        p_double,
        p_float,
        p_boolean,
        String,
        Integer,
        Double,
        Float,
        Boolean;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BindRule {
        private static TreeMap<String, ArgType> argMap = new TreeMap();
        private BindType bindType;
        private Method methodForBinding;
        private ArgType argType;
        private Class xmlBeanElementClass;
        private boolean isArrayType = false;

        static {
            ArgType[] argTypeArray = ArgType.values();
            int n = 0;
            int n2 = argTypeArray.length;
            while (n < n2) {
                ArgType t = argTypeArray[n];
                argMap.put(_primitiveClassNames[t.ordinal()], t);
                ++n;
            }
        }

        public BindRule(Method methodForBinding, String argType) {
            this.bindType = BindType.invokeMethod;
            this.methodForBinding = methodForBinding;
            if (argType.endsWith("[]")) {
                this.isArrayType = true;
                this.argType = argMap.get(argType.substring(0, argType.length() - 2));
            } else {
                this.argType = argMap.get(argType);
            }
        }

        public BindRule(Method methodForBinding, Class xmlBeanElementClass) {
            this.bindType = BindType.nestedElement;
            this.methodForBinding = methodForBinding;
            if (xmlBeanElementClass.isArray()) {
                this.isArrayType = true;
                this.xmlBeanElementClass = xmlBeanElementClass.getComponentType();
            } else {
                this.xmlBeanElementClass = xmlBeanElementClass;
            }
        }

        public boolean isArrayType() {
            return this.isArrayType;
        }

        public Class getElementClass() {
            return this.xmlBeanElementClass;
        }

        public BindType getBindType() {
            return this.bindType;
        }

        public boolean canInvokeSetMethod() {
            return this.bindType == BindType.invokeMethod;
        }

        public boolean isForChildElement() {
            return this.bindType == BindType.nestedElement;
        }

        public void bindBeanArray(Object currentObject, Vector<Object> beanVector) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            Object[] beanArray = (Object[])Array.newInstance(this.xmlBeanElementClass, beanVector.size());
            int i = 0;
            for (Object bean : beanVector) {
                beanArray[i++] = bean;
            }
            this.methodForBinding.invoke(currentObject, new Object[]{beanArray});
        }

        public void bindObject(Object obj, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (this.bindType != BindType.nestedElement) {
                return;
            }
            this.methodForBinding.invoke(obj, value);
        }

        public void bindArray(Object obj, Vector<String> textContent) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (!this.isArrayType) {
                return;
            }
            int i = 0;
            switch (this.argType.ordinal()) {
                case 0: {
                    int[] a = new int[textContent.size()];
                    for (String s : textContent) {
                        a[i++] = Integer.parseInt(s);
                    }
                    this.methodForBinding.invoke(obj, new Object[]{a});
                    break;
                }
                case 1: {
                    double[] d = new double[textContent.size()];
                    for (String s : textContent) {
                        d[i++] = Double.parseDouble(s);
                    }
                    this.methodForBinding.invoke(obj, new Object[]{d});
                    break;
                }
                case 2: {
                    float[] f = new float[textContent.size()];
                    for (String s : textContent) {
                        f[i++] = Float.parseFloat(s);
                    }
                    this.methodForBinding.invoke(obj, new Object[]{f});
                    break;
                }
                case 3: {
                    boolean[] b = new boolean[textContent.size()];
                    for (String s : textContent) {
                        b[i++] = Boolean.parseBoolean(s);
                    }
                    this.methodForBinding.invoke(obj, new Object[]{b});
                    break;
                }
                case 4: {
                    String[] sa = new String[textContent.size()];
                    for (String s : textContent) {
                        sa[i++] = s;
                    }
                    this.methodForBinding.invoke(obj, new Object[]{sa});
                    break;
                }
                case 5: {
                    Integer[] a2 = new Integer[textContent.size()];
                    for (String s : textContent) {
                        a2[i++] = Integer.parseInt(s);
                    }
                    this.methodForBinding.invoke(obj, new Object[]{a2});
                    break;
                }
                case 6: {
                    Double[] d2 = new Double[textContent.size()];
                    for (String s : textContent) {
                        d2[i++] = Double.parseDouble(s);
                    }
                    this.methodForBinding.invoke(obj, new Object[]{d2});
                    break;
                }
                case 7: {
                    Float[] f2 = new Float[textContent.size()];
                    for (String s : textContent) {
                        f2[i++] = Float.valueOf(Float.parseFloat(s));
                    }
                    this.methodForBinding.invoke(obj, new Object[]{f2});
                    break;
                }
                case 8: {
                    Boolean[] b2 = new Boolean[textContent.size()];
                    for (String s : textContent) {
                        b2[i++] = Boolean.parseBoolean(s);
                    }
                    this.methodForBinding.invoke(obj, new Object[]{b2});
                }
            }
        }

        public void bind(Object obj, String value) throws NumberFormatException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (this.bindType != BindType.invokeMethod) {
                return;
            }
            switch (this.argType.ordinal()) {
                case 0: {
                    this.methodForBinding.invoke(obj, Integer.parseInt(value));
                    break;
                }
                case 1: {
                    this.methodForBinding.invoke(obj, Double.parseDouble(value));
                    break;
                }
                case 2: {
                    this.methodForBinding.invoke(obj, Float.valueOf(Float.parseFloat(value)));
                    break;
                }
                case 3: {
                    this.methodForBinding.invoke(obj, Boolean.parseBoolean(value));
                    break;
                }
                case 4: {
                    this.methodForBinding.invoke(obj, value);
                    break;
                }
                case 5: {
                    this.methodForBinding.invoke(obj, new Integer(value));
                    break;
                }
                case 6: {
                    this.methodForBinding.invoke(obj, new Double(value));
                    break;
                }
                case 7: {
                    this.methodForBinding.invoke(obj, new Float(value));
                    break;
                }
                case 8: {
                    this.methodForBinding.invoke(obj, new Boolean(value));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BindRuleCreationProcess {
        private TreeMap<SinglePath, BindRule> _bindRule = new TreeMap();

        BindRuleCreationProcess() {
        }

        void createBindRule(SinglePath currentPath, Class c) {
            Method[] method;
            Method[] methodArray = method = c.getDeclaredMethods();
            int n = 0;
            int n2 = methodArray.length;
            while (n < n2) {
                String tagOrAttributeName;
                Class<?>[] parameterType;
                Method m = methodArray[n];
                String methodName = m.getName();
                if (methodName.startsWith("set") && methodName.length() > 3 && (parameterType = m.getParameterTypes()).length == 1 && (tagOrAttributeName = XMLBeanUtil.pickPropertyName(methodName, SetterOrGetter.set)) != null) {
                    SinglePath newPath = new SinglePath(currentPath, tagOrAttributeName.toLowerCase());
                    if (XMLBeanUtil.isPrimitive(parameterType[0])) {
                        this._bindRule.put(newPath, new BindRule(m, parameterType[0].getSimpleName()));
                    } else {
                        this._bindRule.put(newPath, new BindRule(m, parameterType[0]));
                        if (parameterType[0].isArray()) {
                            this.createBindRule(newPath, parameterType[0].getComponentType());
                        } else {
                            this.createBindRule(newPath, parameterType[0]);
                        }
                    }
                }
                ++n;
            }
        }

        public TreeMap<SinglePath, BindRule> getBindRule() {
            return this._bindRule;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SetterOrGetter {
        set,
        get;

    }
}

