/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.xml.bean;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import junit.framework.TestCase;
import org.xerial.util.XMLParserException;
import org.xerial.util.xml.InvalidXMLException;
import org.xerial.util.xml.bean.Book;
import org.xerial.util.xml.bean.Booklist;
import org.xerial.util.xml.bean.Item_list;
import org.xerial.util.xml.bean.XMLBeanException;
import org.xerial.util.xml.bean.XMLBeanUtil;
import org.xerial.util.xml.pullparser.PullParserUtil;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XMLBeanTest
extends TestCase {
    Reader fin;
    InputStream fst;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    protected void setUp() throws Exception {
        this.fin = null;
        this.fst = null;
    }

    protected void tearDown() throws Exception {
        if (this.fin != null) {
            this.fin.close();
        }
        if (this.fst != null) {
            this.fst.close();
        }
    }

    public void validateBooklist(Booklist booklist) {
        Book[] book = booklist.getBook();
        XMLBeanTest.assertEquals((int)2, (int)book.length);
        XMLBeanTest.assertEquals((String)"Mining The Web", (String)book[0].getTitle());
        XMLBeanTest.assertEquals((String)"Morgan Kaufmann", (String)book[0].getPublisher());
        XMLBeanTest.assertEquals((int)1, (int)book[0].getAuthor().length);
        XMLBeanTest.assertEquals((String)"Soument Chakrabarti", (String)book[0].getAuthor()[0]);
        XMLBeanTest.assertEquals((int)2002, (int)book[0].getYear());
        XMLBeanTest.assertEquals((String)"1558607544", (String)book[0].getIsbn());
        XMLBeanTest.assertEquals((String)"Learning XML", (String)book[1].getTitle());
        XMLBeanTest.assertEquals((int)2, (int)book[1].getAuthor().length);
        XMLBeanTest.assertEquals((String)"Erik T. Ray", (String)book[1].getAuthor()[0]);
        XMLBeanTest.assertEquals((String)"Someone Who", (String)book[1].getAuthor()[1]);
        XMLBeanTest.assertEquals((int)2004, (int)book[1].getYear());
    }

    public void testTagreading() throws XmlPullParserException, XMLBeanException, InvalidXMLException, IOException {
        XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
        this.fin = new FileReader("sample/sample1.xml");
        parser.setInput(this.fin);
        Item_list itemlist = new Item_list();
        XMLBeanUtil.populate((Object)itemlist, parser);
        XMLBeanTest.assertNotNull((Object)itemlist);
        XMLBeanTest.assertEquals((int)2, (int)itemlist.getItem().length);
        XMLBeanTest.assertEquals((int)1, (int)itemlist.getItem()[0]);
        XMLBeanTest.assertEquals((int)2, (int)itemlist.getItem()[1]);
    }

    public void testIsPrimitive() {
        Class[] classes;
        Class[] classArray = classes = new Class[]{Integer.TYPE, Integer.class, Double.TYPE, Double.class, String.class, String[].class};
        int n = 0;
        int n2 = classArray.length;
        while (n < n2) {
            Class c = classArray[n];
            XMLBeanTest.assertTrue((boolean)XMLBeanUtil.isPrimitive(c));
            ++n;
        }
    }

    public void testBindRuleGeneration() throws FileNotFoundException, IOException, XmlPullParserException, InvalidXMLException, XMLBeanException {
        XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
        this.fin = new FileReader("sample/booklist.xml");
        parser.setInput(this.fin);
        Booklist booklist = new Booklist();
        if (PullParserUtil.parseUntil("booklist", parser)) {
            XMLBeanUtil.populate((Object)booklist, parser);
            this.validateBooklist(booklist);
        } else {
            XMLBeanTest.fail((String)"invalid xml document: cannot find any booklist tag");
        }
    }

    public void testBind() {
        try {
            this.fst = new FileInputStream("sample/booklist.xml");
            Booklist booklist = XMLBeanUtil.newInstance(Booklist.class, this.fst);
            this.validateBooklist(booklist);
        }
        catch (XMLParserException e) {
            XMLBeanTest.fail((String)e.getMessage());
        }
        catch (XMLBeanException e) {
            XMLBeanTest.fail((String)e.getMessage());
        }
        catch (InvalidXMLException e) {
            XMLBeanTest.fail((String)e.getMessage());
        }
        catch (IOException e) {
            XMLBeanTest.fail((String)e.getMessage());
        }
    }

    public void testXMLOut() throws XMLBeanException, InvalidXMLException {
        Book book = new Book();
        book.setAuthor(new String[]{"author A", "author B"});
        book.setTitle("Zip-A-Dee-Doo-Dah");
        book.setIsbn("234098");
        book.setPublisher("Walt Disney");
        XMLBeanUtil.outputAsXML(book, System.out);
    }

    public void testNestedBeanOutput() throws XMLBeanException, InvalidXMLException, XMLParserException, FileNotFoundException, IOException {
        this.fst = new FileInputStream("sample/booklist.xml");
        Booklist booklist = XMLBeanUtil.newInstance(Booklist.class, this.fst);
        XMLBeanUtil.outputAsXML(booklist, System.out);
    }
}

