/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.xml;

import java.util.Iterator;
import java.util.Vector;
import org.xerial.algorithm.Algorithm;
import org.xerial.util.MinMax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinglePath
implements Comparable<SinglePath>,
Iterable<String> {
    Vector<String> _path = new Vector();
    PathType _pathType = PathType.AbsolutePath;

    public SinglePath() {
        this._pathType = PathType.RelativePath;
    }

    public SinglePath(PathType pathType) {
        this._pathType = pathType;
    }

    public SinglePath(String pathExpression) {
        String[] pathComponent;
        if (!pathExpression.startsWith("/")) {
            this._pathType = PathType.RelativePath;
        }
        String[] stringArray = pathComponent = pathExpression.split("/");
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String tag = stringArray[n];
            this.addChild(tag);
            ++n;
        }
    }

    public SinglePath(SinglePath path, String childTag) {
        this._pathType = path._pathType;
        for (String e : path._path) {
            this._path.add(e);
        }
        this.addChild(childTag);
    }

    public String getTag(int index) {
        return this._path.get(index);
    }

    public String getLeaf() {
        if (this._path.size() < 1) {
            return "";
        }
        return this._path.lastElement();
    }

    public void addChild(String tagName) {
        this._path.add(tagName);
    }

    public void removeLastChild() {
        assert (this._path.size() > 0);
        this._path.remove(this._path.size() - 1);
    }

    public Integer size() {
        return this._path.size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String tag : this._path) {
            builder.append("/");
            builder.append(tag);
        }
        if (!this.isAbsolutePath() && builder.length() > 0) {
            return builder.substring(1);
        }
        return builder.toString();
    }

    @Override
    public int compareTo(SinglePath other) {
        MinMax<Integer> pathLengthMinMax = Algorithm.minmax(this.size(), other.size());
        int cmp = Algorithm.boolToInt(!this.isAbsolutePath()) - Algorithm.boolToInt(!other.isAbsolutePath());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Algorithm.lexicographicalCompare(this.getPath(), other.getPath());
        return cmp;
    }

    public boolean equals(Object obj) {
        SinglePath other = (SinglePath)obj;
        if (obj == null) {
            return false;
        }
        return this.compareTo(other) == 0;
    }

    public boolean isAbsolutePath() {
        return this._pathType == PathType.AbsolutePath;
    }

    private Vector<String> getPath() {
        return this._path;
    }

    protected Object clone() throws CloneNotSupportedException {
        SinglePath newPath = new SinglePath(this._pathType);
        newPath._path = (Vector)this._path.clone();
        return newPath;
    }

    @Override
    public Iterator<String> iterator() {
        return this._path.iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PathType {
        AbsolutePath,
        RelativePath;

    }
}

