#ifndef _XERCESC_UTILS_XMLCH_TO_CHAR_HPP_
#define _XERCESC_UTILS_XMLCH_TO_CHAR_HPP_

#include <iostream>

#include <xercesc/util/XMLString.hpp>

namespace xercesc_utils {

/**
 * XMLCh*  char* ֕ϊ邽߂̃bp[NXłD
 * ̃NX͕ϊʂ̃obt@̊mہEbsO܂B
 *
 * @author Yutaka ITO
 */
class XMLCh2Char {
private:
  /**
   * ϊʂƂȂ镶obt@ւ̃|C^łD
   */
  char* buffer_;

public:
  /**
   * XMLCh2Char\z܂D
   *
   * @param buffer ϊƂȂ镶ւ̃|C^w肵܂D
   */
  explicit XMLCh2Char(const XMLCh* const buffer) {
    buffer_=xercesc::XMLString::transcode(buffer);
  }

  /**
   * XMLCh2Charj܂D
   */
  ~XMLCh2Char() {
    xercesc::XMLString::release(&buffer_);
  }

  /**
   * char*ւ̃LXgZqłB
   */
  operator const char* const () const {
    return buffer_;
  }

private:
  // Rs[Ƒ֎~܂B
  explicit XMLCh2Char(const XMLCh2Char& ch);
  XMLCh2Char& operator=(const XMLCh2Char& ch);

public:
  /**
   * Xg[֕o͂܂B
   */
  friend static std::ostream& operator<<(std::ostream& stream, const XMLCh2Char& buffer) {
    return stream << (const char* const)buffer;
  }
};

}  // namespace xercesc_utils

#endif
