﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace com.dnetopen.MsOffice.MODIWSetting
{
    public class RegstSettingValues
    {

        public RegstSettingValues()
        {
            _OpenInMODI = 0;
            _PrivateFlags = 0;
            _TIFDPI = 0;
            _COMPIMGEMF = 0;
            _Public_Orientation = 0;
            _Public_PaperSize = 0;
            _DefaultFolder = string.Empty;
        }

        private int _OpenInMODI;
        /// <summary>
        /// [OpenInMODI]
        /// 出力後に出力ファイルを開くかどうかのフラグ、開くAPPは、拡張子で関連付けさたAPPぽい
        /// プリンタドライバのオプションからは設定不可な項目
        /// 1：出力後にアプリケーション起動する（デフォルト）
        /// 0：出力後にアプリケーション起動しない
        /// </summary>
        public int PrintAfterAppStart
        {
            get { return _OpenInMODI; }
            set { _OpenInMODI = value; }
        }

        public enum OutputFileTypes
        {
            MDI = 0,
            TIFF = 16
        }
        private OutputFileTypes _PrivateFlags;
        /// <summary>
        /// [PrivateFlags]
        /// 出力形式するファイル形式
        /// 0：MDI出力
        /// 10：Tiff出力
        /// </summary>
        public OutputFileTypes OutputFileType
        {
            get { return _PrivateFlags; }
            set { _PrivateFlags = value; }
        }

        private int _TIFDPI;
        /// <summary>
        /// [TIFDPI]
        /// Tiff出力時の解像度
        /// 64： 100dpi
        /// C8： 200dpi
        /// 12C：300dpi
        /// 258：600dpi(プリンタドライバのオプションからは設定不可な値)
        /// 600dpiも出た
        /// </summary>
        public int TiffDpi
        {
            get { return _TIFDPI; }
            set { _TIFDPI = value; }
        }

        public enum MdiCompImgValue
        {
            COMPRESS_IMAGE = 0,
            NONE_COMPRESS_IMAGE = 1
        }
        private MdiCompImgValue _COMPIMGEMF;
        /// <summary>
        /// [COMPIMGEMF]
        /// MDIのドキュメント内でイメージを圧縮するかの設定
        /// 0：圧縮しない
        /// 1：圧縮する
        /// </summary>
        public MdiCompImgValue MdiCompImg
        {
            get { return _COMPIMGEMF; }
            set { _COMPIMGEMF = value; }
        }

        private int _Public_Orientation;
        /// <summary>
        /// [Public_Orientation]
        /// 用紙の向き
        /// 1：縦
        /// 2：横
        /// </summary>
        public int PaperOrientation
        {
            get { return _Public_Orientation; }
            set { _Public_Orientation = value; }
        }

        private int _Public_PaperSize;
        /// <summary>
        /// [Public_PaperSize]
        /// 9：A4
        /// 8：A3
        /// </summary>
        public int PaperSize
        {
            get { return _Public_PaperSize; }
            set { _Public_PaperSize = value; }
        }

        private string _DefaultFolder;
        /// <summary>
        /// [DefaultFolder]
        /// デフォルト出力先のフォルダパス
        /// </summary>
        public string DefaultFolder
        {
            get { return _DefaultFolder; }
            set { _DefaultFolder = value; }
        }



    }
}
