﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace com.dnetopen.MsOffice.MODIWSetting
{
    public class RegstSettingReader
    {
        public static RegstSettingValues ReadRegistry()
        {
            string key = RegstChecker.GetLatestRegistryKey();
            if (key == null)
            {
                throw new ApplicationException("MODI関連のRegistryが見つかりません。");
            }
            return ReadRegistry(key);
        }

        public static RegstSettingValues ReadRegistry(string regKey)
        {
            
            RegstSettingValues val = new RegstSettingValues();
            object regValue = null;
            regValue = Microsoft.Win32.Registry.GetValue(regKey, "COMPIMGEMF", null);
            if (regValue == null)
            {
                val.MdiCompImg = RegstSettingValues.MdiCompImgValue.NONE_COMPRESS_IMAGE;
            }
            else
            {
                val.MdiCompImg = (RegstSettingValues.MdiCompImgValue)regValue;
            }
            
            val.DefaultFolder = (string)Microsoft.Win32.Registry.GetValue(regKey, "DefaultFolder", null);

            regValue = Microsoft.Win32.Registry.GetValue(regKey, "PrivateFlags", null);
            if (regValue == null)
            {
                val.OutputFileType = RegstSettingValues.OutputFileTypes.MDI;
            }
            else
            {
                val.OutputFileType = (RegstSettingValues.OutputFileTypes)Microsoft.Win32.Registry.GetValue(regKey, "PrivateFlags", null);
            }
            
            val.PaperOrientation = (int)Microsoft.Win32.Registry.GetValue(regKey, "Public_Orientation", null);
            val.PaperSize = (int)Microsoft.Win32.Registry.GetValue(regKey, "Public_PaperSize", null);
            val.TiffDpi = (int)Microsoft.Win32.Registry.GetValue(regKey, "TIFDPI", null);
            val.PrintAfterAppStart = (int)Microsoft.Win32.Registry.GetValue(regKey, "OpenInMODI", null);

            return val;
        }
    }
}
