﻿using System;
using System.Windows.Forms;
using System.IO;
using System.Net;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Drawing.Imaging;
using System.Drawing.Text;
using System.Reflection;
using com.dnetopen.MsOffice.MsWord2007;
using System.Printing;

namespace WindowsFormsApplication1
{
    public partial class MainF : Form
    {
        private bool IsInstallWrod = false;
        private bool IsInstallWrodOverVer11 = false;
        private bool IsInstallMODI = false;
        private bool IsInstallMODIRegistry = false;
        private string LocalMODIPrinterWName = "";


        public MainF()
        {
            InitializeComponent();
        }     

        private void Form1_Load(object sender, EventArgs e)
        {
            
        }

        private void MainF_Shown(object sender, EventArgs e)
        {
            //初期値設定
            this.Text = System.Windows.Forms.Application.ProductName + " " + System.Windows.Forms.Application.ProductVersion;
            txtWordPath.Text = appConfigData.DefaultInputPath;
            txtOutputPath.Text = appConfigData.DefaultOutputPath;
            cmbImgType.SelectedText = "jpg";

            //ローカルマシン環境チェック
            if (checkLoaclEnvironment() == false)
            {
                this.btnConvert.Enabled = false;
            }
            
        }

        /// <summary>
        /// 環境チェック
        /// </summary>
        /// <returns></returns>
        private bool checkLoaclEnvironment()
        {
            if (com.dnetopen.MsOffice.Check.LocalInstall.IsInstallWord() == false)
            {
                MessageBox.Show("Wordがインストールされていません。", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
                return false;
            }
            IsInstallWrod = true;

            decimal wordVersion = System.Convert.ToDecimal(com.dnetopen.MsOffice.Check.LocalInstall.GetInstallWordVersion());
            if (wordVersion < 11)
            {
                MessageBox.Show("Office2003以上が必須です。", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
                return false;
            }
            IsInstallWrodOverVer11 = true;

            if (com.dnetopen.MsOffice.Check.LocalInstall.IsInstallMODI() == false)
            {
                MessageBox.Show("Microsoft Office Document Imaging がインストールされていません。\nOfficeの追加セットアップで、インストールして下さい。", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
                return false;
            }
            IsInstallMODI = true;
            LocalMODIPrinterWName = com.dnetopen.MsOffice.Printer.MODIWPrinter.GetMODIWName();

            if (com.dnetopen.MsOffice.Check.LocalInstall.IsRegstMODIRegistry() == false)
            {
                MessageBox.Show("Microsoft Office Document Imaging のプロパティ設定がされていません。\n環境設定を実行して下さい。", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
                return false;
            }
            IsInstallMODIRegistry = true;

            return true;
        }

        /// <summary>
        /// 変換処理
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnConvert_Click(object sender, EventArgs e)
        {
            WordToJpeg.SettingValue settings = new WordToJpeg.SettingValue();
            settings.wordDocPath = txtWordPath.Text;
            settings.outputFolderPath = txtOutputPath.Text;
            settings.OutputImgType = GetImgType();
            settings.ConvMethodType = appConfigData.OutputLogicType;
            settings.MdiCompImgType = appConfigData.MdiCompImg;

            WordToJpeg conv = new WordToJpeg();
            try
            {
                this.Cursor = Cursors.WaitCursor;
                btnConvert.Enabled = false;
                WordToJpeg.ResultValue ret = conv.Excecute(settings);
                MessageBox.Show(ret.outputFilePath.Count.ToString() + "個のファイルを出力しました。", this.Text,MessageBoxButtons.OK,MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
               
                    MessageBox.Show("変換に失敗しました。\n" + ex.Message, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            finally
            {
                btnConvert.Enabled = true;
                this.Cursor = Cursors.Default;
            }
        }

        /// <summary>
        /// コンボボックス値をWordToJpeg.OutputImageTypeに変換
        /// </summary>
        /// <returns></returns>
        private WordToJpeg.OutputImageType GetImgType()
        {
            switch (cmbImgType.Text)
            {
                case "Bmp":
                    return WordToJpeg.OutputImageType.Bmp;
                case "Emf":
                    return WordToJpeg.OutputImageType.Emf;
                case "Exif":
                    return WordToJpeg.OutputImageType.Exif;
                case "Gif":
                    return WordToJpeg.OutputImageType.Gif;
                case "Icon":
                    return WordToJpeg.OutputImageType.Icon;
                case "Jpeg":
                    return WordToJpeg.OutputImageType.Jpeg;
                case "Png":
                    return WordToJpeg.OutputImageType.Png;
                case "Tiff":
                    return WordToJpeg.OutputImageType.Tiff;
                case "Wmf":
                    return WordToJpeg.OutputImageType.Wmf;
                default:
                    return WordToJpeg.OutputImageType.Jpeg;
            }
        }

        /// <summary>
        /// ワードDocパス選択ダイアログ表示
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnWordPath_Click(object sender, EventArgs e)
        {
            using (OpenFileDialog di = new OpenFileDialog())
            {
                di.Title = "変換対象WordDocument選択";
                di.Multiselect = false;
                di.InitialDirectory = txtWordPath.Text;
                di.Filter = "Word Documentファイル(*.doc;*.docx)|*.doc;*.docx|すべてのファイル(*.*)|*.*";
                di.FilterIndex = 0;
                if (di.ShowDialog() == DialogResult.OK)
                {
                    txtWordPath.Text = di.FileName;
                }
            }
        }

        /// <summary>
        /// 変換先パス選択ダイアログ表示
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnFolderPath_Click(object sender, EventArgs e)
        {
            using (FolderBrowserDialog di = new FolderBrowserDialog())
            {
                di.Description = "出力先フォルダを指定";
                di.SelectedPath = txtOutputPath.Text;
                di.ShowNewFolderButton = true;
                
                if (di.ShowDialog() == DialogResult.OK)
                {
                    txtOutputPath.Text = di.SelectedPath;
                }
            }
        }

        
        /// <summary>
        /// メニュー：ファイル→終了メニュー
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void TSMenuFileExit_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        /// <summary>
        /// メニュー：環境設定→MODIのプロパティ設定
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void TSMenuEnvironmentMODIProperty_Click(object sender, EventArgs e)
        {
            if (IsInstallMODI == false)
            {
                MessageBox.Show("Microsoft Office Document Imaging がインストールされていません。\nOfficeの追加セットアップで、インストールして下さい。", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }
            if (string.IsNullOrEmpty(LocalMODIPrinterWName))
            {
                MessageBox.Show("Microsoft Office Document Imaging が見つかりません。", this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }
            System.Drawing.Printing.PrinterSettings ps = new System.Drawing.Printing.PrinterSettings();
            ps.PrinterName = LocalMODIPrinterWName;
            bool retValue = com.dnetopen.MsOffice.Printer.PrinterSettingDialog.ShowProperties(Handle, ps);
            if (retValue)
            {
                //ローカルマシン環境チェック
                if (checkLoaclEnvironment() == true)
                {
                    this.btnConvert.Enabled = true;
                }
                else
                {
                    this.btnConvert.Enabled = false;
                }
            }
        }

        private void tSMenuToolOptionToolStripMenuItem_Click(object sender, EventArgs e)
        {
            using (Options frmOption  = new Options())
            {
                frmOption.ShowDialog();
            }
        }

        private void TSMenuEnvironment_Click(object sender, EventArgs e)
        {

        }

       

    }
}
