package hiro.yoshioka.sql.util;

import hiro.yoshioka.sql.params.PropetiesChangeType;
import hiro.yoshioka.sql.params.SSHProperties;
import hiro.yoshioka.sql.util.SSHTunnelingConfigDialog.MODE;
import hiro.yoshioka.util.StringUtil;

import java.util.AbstractCollection;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class SSHTunnelingDefineEditor implements SelectionListener {

	TableViewer tableViewer;

	Button addButton;

	Button editButton;

	Button cloneButton;

	Button delButton;

	ConnectionSettingDialog dialog;
	private static String[] HEADER = { StringUtil.HALF_SPACE__STRING,
			Messages.getString("SSHTunnelingDefineEditor.definition"), Messages.getString("SSHTunnelingDefineEditor.hostname"), Messages.getString("SSHTunnelingDefineEditor.user"), "local port", "host to connect", //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
			"port to connect", "bind addr", "bind port" }; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	private static int[] HEADER_WIDTH = { 25, 100, 90, 70, 50, 70, 50, 70, 50 };

	private Button createButton(Composite parent, String text, int style) {
		Button ret = new Button(parent, style);
		ret.setText(text);
		return ret;
	}

	public void doEdit(Shell shell) {

		SSHProperties p = (SSHProperties) ((IStructuredSelection) tableViewer
				.getSelection()).getFirstElement();
		if (p == null) {
			return;
		}
		SSHTunnelingConfigDialog dialog2 = new SSHTunnelingConfigDialog(shell,
				p, MODE.EDIT);
		if (dialog2.open() == dialog2.OK) {
			dialog.sshSet.remove(p);
			dialog.sshSet.add(dialog2.getSSHProperties());
			dialog.changedType = PropetiesChangeType.CHANGE;
			refreshTable();
		}

	}

	protected SSHTunnelingDefineEditor(ConnectionSettingDialog c_dialog,
			Composite parent) {
		this.dialog = c_dialog;

		tableViewer = getTableViewer(parent);
		if (this.dialog.fConnectionSettingBean != null) {
			Composite btnComposite = new Composite(parent, SWT.NONE);
			btnComposite.setLayout(new RowLayout(SWT.VERTICAL));

			addButton = createButton(btnComposite,
					Messages.getString("DBDefineTableEditor.add"), SWT.NONE); //$NON-NLS-1$
			addButton.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					SSHTunnelingConfigDialog dialog2 = new SSHTunnelingConfigDialog(
							e.display.getActiveShell(), new SSHProperties(),
							MODE.ADD);
					if (dialog2.open() == dialog2.OK) {
						dialog.sshSet.add(dialog2.getSSHProperties());
						refreshTable();
					}
				}
			});
			editButton = createButton(btnComposite,
					Messages.getString("DBDefineTableEditor.edit"), SWT.NONE); //$NON-NLS-1$
			editButton.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					doEdit(e.display.getActiveShell());
				}
			});

			cloneButton = createButton(btnComposite,
					Messages.getString("DBDefineTableEditor.clone"), SWT.NONE); //$NON-NLS-1$
			cloneButton.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					SSHProperties p = (SSHProperties) ((IStructuredSelection) tableViewer
							.getSelection()).getFirstElement();
					if (p == null) {
						return;
					}
					SSHTunnelingConfigDialog dialog2;
					try {
						dialog2 = new SSHTunnelingConfigDialog(e.display
								.getActiveShell(), (SSHProperties) p.clone(),
								MODE.CLONE);
						if (dialog2.open() == dialog2.OK) {
							dialog.sshSet.add(dialog2.getSSHProperties());
							dialog.changedType = PropetiesChangeType.ADD;
							refreshTable();
						}
					} catch (CloneNotSupportedException e1) {
						e1.printStackTrace();
					}
				}
			});
			delButton = createButton(btnComposite,
					Messages.getString("DBDefineTableEditor.del"), SWT.NONE); //$NON-NLS-1$
			delButton.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					int delIndex = tableViewer.getTable().getSelectionIndex();
					if (delIndex >= 0) {
						SSHProperties ssh_prop = (SSHProperties) tableViewer
								.getTable().getItem(delIndex).getData();
						dialog.changedType = PropetiesChangeType.DELETE;
						dialog.sshSet.remove(ssh_prop);
					}
					refreshTable();
				}
			});

		}
	}

	public TableViewer getTableViewer(Composite parent) {

		Table table = new Table(parent, SWT.SINGLE | SWT.H_SCROLL
				| SWT.V_SCROLL | SWT.FULL_SELECTION | SWT.BORDER);

		tableViewer = new TableViewer(table);

		TableWrapData layoutData = new TableWrapData();
		layoutData.maxHeight = 130;
		layoutData.heightHint = 130;
		table.setLayoutData(layoutData);

		table.setLinesVisible(true);
		table.setHeaderVisible(true);
		table.addSelectionListener(this);

		for (int i = 0; i < HEADER.length; i++) {
			TableColumn column = new TableColumn(table, SWT.NONE);
			column.setText(HEADER[i]);
			column.setWidth(HEADER_WIDTH[i]);
		}
		tableViewer.setColumnProperties(HEADER);
		tableViewer.setContentProvider(new MyTableContentsProvider());
		tableViewer.setLabelProvider(new MyLabelProvider());
		tableViewer.setInput(dialog.sshSet);

		// TableColumn[] columns = table.getColumns();
		// for (int i = 0; i < columns.length; i++) {
		// columns[i].pack();
		// }

		return tableViewer;
	}

	private void refreshTable() {
		tableViewer.setInput(dialog.sshSet);
		tableViewer.refresh();
	}

	public void select(SSHProperties sshProperties) {
		tableViewer.setSelection(new StructuredSelection(sshProperties));
		resetButtonEnabled();
	}

	public void widgetDefaultSelected(SelectionEvent e) {

	}

	private void resetButtonEnabled() {
		if (this.dialog.fConnectionSettingBean != null) {
			int index = tableViewer.getTable().getSelectionIndex();
			int size = tableViewer.getTable().getItemCount();
			boolean en = index >= 0 && size > 0;
			editButton.setEnabled(en);
			cloneButton.setEnabled(en);
			delButton.setEnabled(en);
		}
	}

	public void widgetSelected(SelectionEvent e) {

		if (this.dialog.fConnectionSettingBean == null) {
			Object o = ((IStructuredSelection) tableViewer.getSelection())
					.getFirstElement();
			// this.dialog.setSelection((SSHProperties) o);
		} else {
			resetButtonEnabled();
		}
	}

	class MyTableContentsProvider implements IStructuredContentProvider {
		public Object[] getElements(Object element) {
			AbstractCollection<SSHProperties> set = (AbstractCollection<SSHProperties>) element;
			return (SSHProperties[]) set.toArray(new SSHProperties[set.size()]);
		}

		public void dispose() {
		}

		public void inputChanged(Viewer viewer, Object old_object,
				Object new_object) {
		}
	}

	class MyLabelProvider extends LabelProvider implements ITableLabelProvider {

		public Image getColumnImage(Object element, int columnIndex) {
			SSHProperties item = (SSHProperties) element;
			String result = StringUtil.EMPTY_STRING;
			// switch (columnIndex) {
			// case 0:
			// if (item.isConnected()) {
			// return ImageUtil.getImage(ImageUtil.ACTION_32_CONNECT);
			// } else {
			// return ImageUtil.getImage(ImageUtil.ACTION_33_DISCONNECT);
			// }
			// }
			return null;
		}

		public String getColumnText(Object element, int columnIndex) {
			SSHProperties item = (SSHProperties) element;
			String result = StringUtil.EMPTY_STRING;
			switch (columnIndex) {
			case 0:
				result = StringUtil.HALF_SPACE__STRING;
				break;
			case 1:
				result = item.getDefinition_name();
				break;
			case 2:
				result = item.hostname;
				break;
			case 3:
				result = item.username;
				break;
			case 4:
				result = String.valueOf(item.local_port);
				break;
			case 5:
				result = item.host_to_connect;
				break;
			case 6:
				result = String.valueOf(item.port_to_connect);
				break;
			case 7:
				result = item.bindAddress;
				break;
			case 8:
				result = String.valueOf(item.bindPort);
				break;

			default:
				break;
			}

			return result;
		}
	}

}
