package hiro.yoshioka.sql.util;

import hiro.yoshioka.chart.ChartInfo;
import hiro.yoshioka.chart.PieChartInfo;
import hiro.yoshioka.chart.TimeChartInfo;
import hiro.yoshioka.sdh.DefaultHyperLinkAction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class CommentInfo {
	public CommentInfo(boolean supportChartResultSet) {
		this.supportChartResultSet = supportChartResultSet;
	}

	public boolean supportBarGraph;
	public int supportMultiLine = 1;
	public boolean supportChartResultSet;
	private List<ChartInfo> chartList;
	private Set<Integer> onLoadProgramLaunchIdxSet;
	private Set<Integer> onClickProgramLaunchIdxSet;
	private List<String> interceptorsList;

	@Override
	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("supportBarGraph:" + supportBarGraph);
		buf.append(" supportMultiLine:" + supportMultiLine);
		buf.append(" supportChartResultSet:" + supportChartResultSet);
		buf.append("\n chartList:" + chartList);
		buf.append("\n interceptorList:" + interceptorsList);

		return buf.toString();
	}

	public List<ChartInfo> getChartList() {
		if (chartList == null) {
			return Collections.EMPTY_LIST;
		}
		return chartList;
	}

	public boolean hasOnClickEvent() {
		return onClickProgramLaunchIdxSet != null
				&& onClickProgramLaunchIdxSet.size() > 0;
	}

	public DefaultHyperLinkAction createHyperLinkToProgramLaunchAction() {
		return new DefaultHyperLinkAction(onClickProgramLaunchIdxSet);
	}

	public void add(String kind, String info) {
		String[] param = info.split(":");
		if (chartList == null) {
			chartList = new ArrayList<ChartInfo>();
		}
		if ("PIE".equalsIgnoreCase(kind)) {
			chartList.add(new PieChartInfo(param));
		} else if ("TIME".equalsIgnoreCase(kind)) {
			chartList.add(new TimeChartInfo(param));
		}
	}

	public void addLink(int colIdx, LaunchTimingType timing) {
		if (LaunchTimingType.onLoad.equals(timing)) {
			if (onLoadProgramLaunchIdxSet == null) {
				onLoadProgramLaunchIdxSet = new LinkedHashSet<Integer>();
			}
			onLoadProgramLaunchIdxSet.add(colIdx);
		} else {
			if (onClickProgramLaunchIdxSet == null) {
				onClickProgramLaunchIdxSet = new LinkedHashSet<Integer>();
			}
			onClickProgramLaunchIdxSet.add(colIdx);
		}
	}

	public void addInterceptorComment(String interceptorComment) {
		if (interceptorsList == null) {
			interceptorsList = new ArrayList<String>();
		}
		interceptorsList.add(interceptorComment);
	}

	public List<String> getInterceptorCommentList() {
		if (interceptorsList == null) {
			return Collections.EMPTY_LIST;
		}
		return interceptorsList;
	}
}
