package hiro.yoshioka.sql.twitter;

import hiro.yoshioka.sdh.BindObject;
import hiro.yoshioka.sql.ResultSetUtil;
import hiro.yoshioka.sql.resource.twitter.TwitterColumnType;
import hiro.yoshioka.sql.resource.twitter.TwitterSchemaType;
import hiro.yoshioka.sql.resource.twitter.TwitterTableType;
import hiro.yoshioka.util.SQLUtil;
import hiro.yoshioka.util.StringUtil;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import twitter4j.DirectMessage;
import twitter4j.IDs;
import twitter4j.Location;
import twitter4j.Paging;
import twitter4j.ResponseList;
import twitter4j.Status;
import twitter4j.Trends;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.User;

//setHttpConnectionTimeout()

public class TwitterResultSet implements ResultSet {
	Twitter twitter;
	TwitterSchemaType schemaType;
	TwitterTableType tableType;
	List<TwitterColumnType> selectColumnList;
	ResultSetMetaData meta;
	Object targetObject;
	ResponseList<Status> responseList;
	List<DirectMessage> directMessageList;
	Trends locationTrends;
	ResponseList<Location> locationTrendList;
	List<Object> targetRowObjectList;
	private Map<String, Method> methodCacheMap = new HashMap<String, Method>();
	private long cursor = -1;
	private Map<String, BindObject> params;
	private long whomUserId = -1;
	private long id = -1;
	private List<String> inputNameList;
	private int woeid = 23424738;
	private long limitNum = -1;
	private java.util.Date date;
	private boolean exclude;
	private String search_query;
	List<User> resultUserList;
	List<Long> followersIdList;
	List<Long> blockingUserIdList;
	List<Long> inputParamIdList;

	protected String formatBuildTimeStamp = ResultSetUtil.FORMAT_TIME;
	protected String formatBuildDate = ResultSetUtil.FORMAT_DAY;

	/**
	 * 
	 * @param twitter
	 * @param schemaType
	 * @param tableType
	 * @param selectColumnList
	 * @param params
	 * @throws TwitterException
	 * 
	 *             params: Followers: long whomUserId, long limitNum
	 *             RetweetedByUser: long whomUserId, long limitNum
	 */
	public TwitterResultSet(Twitter twitter, TwitterSchemaType schemaType,
			TwitterTableType tableType,
			List<TwitterColumnType> selectColumnList,
			Map<String, BindObject> params) throws TwitterException {
		this.twitter = twitter;
		this.selectColumnList = selectColumnList;
		this.meta = new MyMeta();
		this.schemaType = schemaType;
		this.tableType = tableType;
		if (params == null) {
			this.params = Collections.EMPTY_MAP;
		} else {
			this.params = params;
		}
		init();
	}

	public void setBuildTimeStamp(String format) {
		formatBuildTimeStamp = format;
	}

	public void setBuildDate(String format) {
		formatBuildDate = format;
	}

	private void init() throws TwitterException {
		initParams();
		int count = 10;
		int pageCount;
		Paging paging;
		switch (schemaType) {
		case Account:
			switch (tableType) {
			case AccountSettings:
				if (selectColumnList == null || selectColumnList.size() == 0) {
					selectColumnList = TwitterColumnType.ACCOUNT_SETTINGS_LIST;
				}
				break;
			case AccountTotals:
				if (selectColumnList == null || selectColumnList.size() == 0) {
					selectColumnList = TwitterColumnType.ACCOUNT_TOTALS;
				}
				break;
			}
			break;
		case DirectMessage:
			if (selectColumnList == null || selectColumnList.size() == 0) {
				selectColumnList = TwitterColumnType.DIRECT_MESSAGE_LIST;
			}
			if (limitNum < count) {
				count = (int) limitNum;
			}
			pageCount = (int) (limitNum / count);
			if (pageCount * count < limitNum) {
				pageCount++;
			}
			paging = new Paging(1, count);

			if (TwitterTableType.DirectMessages.equals(tableType)) {
				directMessageList = twitter.getDirectMessages(paging);
			} else if (TwitterTableType.SentDirectMessages.equals(tableType)) {
				directMessageList = twitter.getSentDirectMessages(paging);
			}
			for (int i = 2; i <= pageCount; i++) {
				paging = new Paging(i, count);
				if (TwitterTableType.DirectMessages.equals(tableType)) {
					directMessageList.addAll(twitter.getDirectMessages(paging));
				} else if (TwitterTableType.SentDirectMessages
						.equals(tableType)) {
					directMessageList.addAll(twitter
							.getSentDirectMessages(paging));
				}
			}
			break;
		case Timeline:
			if (selectColumnList == null || selectColumnList.size() == 0) {
				selectColumnList = TwitterColumnType.TIMELINE_LIST;
			}
			switch (tableType) {
			case HomeTimeline:
				responseList = twitter.getHomeTimeline();
				break;
			case Mentions:
				responseList = twitter.getMentions();
				break;
			case PublicTimeline:
				responseList = twitter.getPublicTimeline();
				break;
			case RetweetedByMe:
				responseList = twitter.getRetweetedByMe();
				break;
			case RetweetedByUser:
			case RetweetedToUser:
				initParams();
				if (limitNum < count) {
					count = (int) limitNum;
				}
				pageCount = (int) (limitNum / count);
				if (pageCount * count < limitNum) {
					pageCount++;
				}
				paging = new Paging(1, count);
				if (tableType.equals(TwitterTableType.RetweetedByUser)) {
					responseList = twitter.getRetweetedByUser(whomUserId,
							paging);
				} else {
					responseList = twitter.getRetweetedToUser(whomUserId,
							paging);
				}
				for (int i = 2; i <= pageCount; i++) {
					paging = new Paging(i, count);
					if (tableType.equals(TwitterTableType.RetweetedByUser)) {
						responseList.addAll(twitter.getRetweetedByUser(
								whomUserId, paging));
					} else {
						responseList = twitter.getRetweetedToUser(whomUserId,
								paging);
					}
				}
				break;
			case RetweetedToMe:
				responseList = twitter.getRetweetedToMe();
				break;

			case RetweetsOfMe:
				responseList = twitter.getRetweetsOfMe();
				break;
			case UserTimeline:
				responseList = twitter.getUserTimeline();
				break;
			}
			this.targetObject = responseList;
			break;
		case LocalTrends:
			switch (tableType) {
			case AvailableTrends:
				if (selectColumnList == null || selectColumnList.size() == 0) {
					selectColumnList = TwitterColumnType.LOCATION_LIST;
				}
				locationTrendList = twitter.getAvailableTrends();
				break;
			case LocationTrends:
				if (selectColumnList == null || selectColumnList.size() == 0) {
					selectColumnList = TwitterColumnType.TREND_LIST;
				}
				locationTrends = twitter.getLocationTrends(woeid);
				break;
			}
			break;

		case Followers:
			if (selectColumnList == null || selectColumnList.size() == 0) {
				selectColumnList = TwitterColumnType.USER_LIST;
			}
			long lc = -1;
			IDs ids = null;
			followersIdList = new ArrayList<Long>();
			out: do {
				ids = twitter.getFollowersIDs(whomUserId, lc);
				for (long id : ids.getIDs()) {
					if (followersIdList.size() < limitNum) {
						followersIdList.add(id);
					} else {
						break out;
					}
				}
			} while ((lc = ids.getNextCursor()) != 0);

			break;

		case User:
			if (selectColumnList == null || selectColumnList.size() == 0) {
				selectColumnList = TwitterColumnType.USER_LIST;
			}
			User user = null;
			switch (tableType) {
			case ShowUser:
				resultUserList = new ArrayList<User>();
				if (this.inputNameList != null && this.inputNameList.size() > 0) {
					user = twitter.showUser(this.inputNameList.get(0));
				} else {
					user = twitter.showUser(this.inputParamIdList.get(0));
				}
				if (user != null) {
					resultUserList.add(user);
				}
				break;
			case LookupUsers:
				if (this.inputNameList != null && this.inputNameList.size() > 0) {
					resultUserList = twitter.lookupUsers(this.inputNameList
							.toArray(new String[inputNameList.size()]));
				} else {
					long[] inputs = new long[this.inputParamIdList.size()];
					for (int q = 0; q < inputs.length; q++) {
						inputs[q] = this.inputParamIdList.get(q);
					}
					resultUserList = twitter.lookupUsers(inputs);
				}
				break;
			case SearchUsers:
				resultUserList = twitter.searchUsers(this.search_query, 1);
				for (int j = 2; j <= 10; j++) {
					ResponseList<User> list = twitter.searchUsers(
							this.search_query, j);
					if (list == null || list.size() == 0) {
						break;
					}
					resultUserList.addAll(list);
				}
				break;
			case BlockingUsers:
				if (selectColumnList == null || selectColumnList.size() == 0) {
					selectColumnList = TwitterColumnType.USER_LIST;
				}
				ids = null;
				blockingUserIdList = new ArrayList<Long>();

				ids = twitter.getBlockingUsersIDs();
				for (long id : ids.getIDs()) {
					if (blockingUserIdList.size() < limitNum) {
						blockingUserIdList.add(id);
					} else {
						break;
					}
				}

				break;
			}
			break;
		}
	}

	private void initParams() throws IllegalStateException, TwitterException {
		if (this.params.containsKey(TwitterColumnType.whomUserId.name())) {
			BindObject bo = this.params
					.get(TwitterColumnType.whomUserId.name());
			Object o = bo.target;
			if (o instanceof Long) {
				whomUserId = (Long) o;
			} else if (o instanceof Integer) {
				whomUserId = (Integer) o;
			} else if (o instanceof String) {
				whomUserId = Long.parseLong((String) o);
			}
		}
		if (this.params.containsKey(TwitterColumnType.limitNum.name())) {
			BindObject bo = this.params.get(TwitterColumnType.limitNum.name());
			Object o = bo.target;
			if (o instanceof Long) {
				limitNum = (Long) o;
			} else if (o instanceof Integer) {
				limitNum = (Integer) o;
			}
		}
		if (whomUserId < 0) {
			whomUserId = twitter.getId();
		}
		if (limitNum < 0) {
			limitNum = Long.MAX_VALUE;
		}
		if (this.params.containsKey(TwitterColumnType.woeid.name())) {
			BindObject bo = this.params.get(TwitterColumnType.woeid.name());
			Integer woeid2 = SQLUtil.getInteger(bo.target);
			if (woeid2 != null) {
				woeid = woeid2;
			}
		}
		if (this.params.containsKey(TwitterColumnType.date.name())) {
			BindObject bo = this.params.get(TwitterColumnType.date.name());
			date = SQLUtil.getDateOfUtil(bo.target);
		}
		if (this.params.containsKey(TwitterColumnType.exclude.name())) {
			BindObject bo = this.params.get(TwitterColumnType.exclude.name());
			Object o = bo.target;
			if (o instanceof Boolean) {
				exclude = (Boolean) o;
			} else {
				exclude = Boolean.parseBoolean(o.toString());
			}
		}
		if (this.params.containsKey(TwitterColumnType.id.name())) {
			BindObject bo = this.params.get(TwitterColumnType.id.name());
			this.inputParamIdList = StringUtil
					.parseLongListNoneException(bo.target);
		}
		if (this.params.containsKey(TwitterColumnType.name.name())) {
			BindObject bo = this.params.get(TwitterColumnType.name.name());
			this.inputNameList = StringUtil.split(bo.target);
		}
		if (this.params.containsKey(TwitterColumnType.search_query.name())) {
			BindObject bo = this.params.get(TwitterColumnType.search_query
					.name());
			this.search_query = (String) bo.target;
		}
	}

	@Override
	public boolean next() throws SQLException {
		cursor++;

		boolean ret = false;
		int sum = 0;
		switch (this.schemaType) {
		case Account:
			ret = (cursor <= 0);
			break;
		case DirectMessage:
			ret = directMessageList.size() > cursor;
			break;
		case Timeline:
			ret = responseList.size() > cursor;
			break;
		case LocalTrends:
			switch (tableType) {
			case AvailableTrends:
				ret = locationTrendList.size() > cursor;
				break;
			case LocationTrends:
				ret = locationTrends.getTrends().length > cursor;
				break;
			}
			break;
		case Followers:
			ret = followersIdList.size() > cursor;
			break;
		case User:
			switch (tableType) {
			case BlockingUsers:
				ret = this.blockingUserIdList.size() > cursor;
				break;
			default:
				ret = this.resultUserList.size() > cursor;
				break;
			}
			break;
		}

		if (ret) {
			try {
				resetTargetRowObject();
			} catch (TwitterException e) {
				e.printStackTrace();
			}
		}

		return ret;
	}

	private int getTargetObjectIdx(String columnName) throws SQLException {
		int idx = 1;
		for (TwitterColumnType column : selectColumnList) {
			if (column.name().equalsIgnoreCase(columnName)) {
				return idx;
			}
			idx++;
		}
		System.err.println("no such column[" + columnName + "]");
		throw new SQLException("no such column[" + columnName + "]");
	}

	private Object getTargetObjectData(String columnName) throws SQLException {
		int idx = 1;
		for (TwitterColumnType column : selectColumnList) {
			if (column.name().equalsIgnoreCase(columnName)) {
				return getTargetObjectData(idx);
			}
			idx++;
		}
		System.err.println("no such column[" + columnName + "]");
		throw new SQLException("no such column[" + columnName + "]");
	}

	private Object getTargetObjectData(int idx) {
		if (targetRowObjectList == null) {
			return new SQLException("no data");
		}
		if (targetRowObjectList.size() <= (idx - 1)) {
			return new SQLException("no data");
		}
		return targetRowObjectList.get(idx - 1);
	}

	private void resetTargetRowObject() throws TwitterException {
		Object valueObject = null;
		Status status = null;

		switch (this.schemaType) {
		case Account:
			switch (tableType) {
			case AccountSettings:
				valueObject = twitter.getAccountSettings();
				break;
			case AccountTotals:
				valueObject = twitter.getAccountTotals();
				break;
			}
			break;
		case DirectMessage:
			valueObject = directMessageList.get((int) cursor);
			break;
		case Followers:
			Long id = followersIdList.get((int) cursor);
			valueObject = twitter.showUser(id);
			break;
		case Timeline:
			valueObject = responseList.get((int) cursor);
			break;
		case LocalTrends:
			switch (tableType) {
			case AvailableTrends:
				Location location = locationTrendList.get((int) cursor);
				valueObject = location;
				break;
			case LocationTrends:
				valueObject = locationTrends.getTrends()[(int) cursor];
				break;
			}
			break;
		case User:
			switch (tableType) {
			case ShowUser:
				valueObject = resultUserList.get(0);
				break;
			case BlockingUsers:
				Long ln = this.blockingUserIdList.get((int) cursor);
				valueObject = twitter.showUser(ln);
				break;
			case LookupUsers:
			case SearchUsers:
				valueObject = resultUserList.get((int) cursor);
				break;
			}
			break;
		}
		targetRowObjectList = new ArrayList<Object>();
		Method method = null;
		for (int i = 0; i < selectColumnList.size(); i++) {
			TwitterColumnType selectColumn = selectColumnList.get(i);
			try {
				switch (this.schemaType) {
				case LocalTrends:
					switch (this.tableType) {
					case AvailableTrends:
						if (TwitterColumnType.url.equals(selectColumn)) {
							Location loc = (Location) valueObject;
							targetRowObjectList.add(loc.getURL());
							continue;
						}
					}
				default:
					break;
				}
				String key = selectColumn + "/" + valueObject.getClass();
				method = methodCacheMap.get(key);
				if (method == null) {
					method = valueObject.getClass().getDeclaredMethod(
							selectColumn.getValueMethod());
					method.setAccessible(true);
					methodCacheMap.put(key, method);
				}
				switch (selectColumn.getColumnType()) {
				case Types.DATE:
					targetRowObjectList.add(method.invoke(valueObject));
					break;
				default:
					targetRowObjectList.add(method.invoke(valueObject));
					break;
				}
			} catch (Exception e) {
				System.err.println("================================");
				System.out.println("selectColumn=" + selectColumn);
				System.out.println("method=" + method);
				e.printStackTrace();
			}
		}
	}

	class MyMeta implements ResultSetMetaData {

		@Override
		public boolean isWrapperFor(Class<?> iface) throws SQLException {
			// TODO Auto-generated method stub
			return false;
		}

		@Override
		public <T> T unwrap(Class<T> iface) throws SQLException {
			// TODO Auto-generated method stub
			return null;
		}

		@Override
		public String getCatalogName(int column) throws SQLException {
			return null;
		}

		@Override
		public String getColumnClassName(int column) throws SQLException {
			return selectColumnList.get(column - 1).getDataTypeString();
		}

		@Override
		public int getColumnCount() throws SQLException {
			if (TwitterResultSet.this.selectColumnList == null) {
				return 0;
			}
			return selectColumnList.size();
		}

		@Override
		public int getColumnDisplaySize(int column) throws SQLException {
			return selectColumnList.get(column - 1).name().length();
		}

		@Override
		public String getColumnLabel(int column) throws SQLException {
			return selectColumnList.get(column - 1).name();
		}

		@Override
		public String getColumnName(int column) throws SQLException {
			return selectColumnList.get(column - 1).name();
		}

		@Override
		public int getColumnType(int column) throws SQLException {
			return selectColumnList.get(column - 1).getColumnType();
		}

		@Override
		public String getColumnTypeName(int column) throws SQLException {
			return selectColumnList.get(column - 1).getDataTypeString();
		}

		@Override
		public int getPrecision(int column) throws SQLException {
			return 0;
		}

		@Override
		public int getScale(int column) throws SQLException {
			return 0;
		}

		@Override
		public String getSchemaName(int column) throws SQLException {
			// TODO Auto-generated method stub
			return null;
		}

		@Override
		public String getTableName(int column) throws SQLException {
			// TODO Auto-generated method stub
			return null;
		}

		@Override
		public boolean isAutoIncrement(int column) throws SQLException {
			return false;
		}

		@Override
		public boolean isCaseSensitive(int column) throws SQLException {
			return false;
		}

		@Override
		public boolean isCurrency(int column) throws SQLException {
			return false;
		}

		@Override
		public boolean isDefinitelyWritable(int column) throws SQLException {
			return false;
		}

		@Override
		public int isNullable(int column) throws SQLException {
			// TODO Auto-generated method stub
			return 0;
		}

		@Override
		public boolean isReadOnly(int column) throws SQLException {
			// TODO Auto-generated method stub
			return false;
		}

		@Override
		public boolean isSearchable(int column) throws SQLException {
			// TODO Auto-generated method stub
			return false;
		}

		@Override
		public boolean isSigned(int column) throws SQLException {
			// TODO Auto-generated method stub
			return false;
		}

		@Override
		public boolean isWritable(int column) throws SQLException {
			// TODO Auto-generated method stub
			return false;
		}

	}

	@Override
	public boolean isWrapperFor(Class<?> arg0) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public <T> T unwrap(Class<T> arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean absolute(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void afterLast() throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void beforeFirst() throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void cancelRowUpdates() throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void clearWarnings() throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void close() throws SQLException {
		targetObject = null;
		targetRowObjectList = null;
		responseList = null;
		locationTrends = null;
		followersIdList = null;
		blockingUserIdList = null;
		date = null;
	}

	@Override
	public void deleteRow() throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public int findColumn(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public boolean first() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public Array getArray(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Array getArray(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public InputStream getAsciiStream(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public InputStream getAsciiStream(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public BigDecimal getBigDecimal(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public BigDecimal getBigDecimal(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public BigDecimal getBigDecimal(int arg0, int arg1) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public BigDecimal getBigDecimal(String arg0, int arg1) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public InputStream getBinaryStream(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public InputStream getBinaryStream(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Blob getBlob(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Blob getBlob(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean getBoolean(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean getBoolean(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public byte getByte(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public byte getByte(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public byte[] getBytes(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public byte[] getBytes(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Reader getCharacterStream(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Reader getCharacterStream(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Clob getClob(int idx) throws SQLException {
		Object o = getTargetObjectData(idx);
		return SQLUtil.getClobOfSql(o);
	}

	@Override
	public Clob getClob(String columnName) throws SQLException {
		return getClob(getTargetObjectIdx(columnName));
	}

	@Override
	public int getConcurrency() throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public String getCursorName() throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Date getDate(int idx) throws SQLException {
		Object o = getTargetObjectData(idx);
		return SQLUtil.getDateOfSql(o);
	}

	// private java.util.Date cnvDateSqlToUtil(java.sql.Date d) {
	// return new java.util.Date(d.getTime());
	// }
	//
	// private java.sql.Date cnvDateUtilToSql(java.util.Date d) {
	// return new java.sql.Date(d.getTime());
	// }

	@Override
	public Date getDate(String columnName) throws SQLException {
		Object o = getTargetObjectData(columnName);
		return SQLUtil.getDateOfSql(o);
	}

	@Override
	public Date getDate(int arg0, Calendar arg1) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Date getDate(String arg0, Calendar arg1) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public double getDouble(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public double getDouble(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public int getFetchDirection() throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public int getFetchSize() throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public float getFloat(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public float getFloat(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public int getHoldability() throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public int getInt(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public int getInt(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public long getLong(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public long getLong(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public ResultSetMetaData getMetaData() throws SQLException {
		return this.meta;
	}

	@Override
	public Reader getNCharacterStream(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Reader getNCharacterStream(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public NClob getNClob(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public NClob getNClob(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getNString(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getNString(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Object getObject(int idx) throws SQLException {
		return getTargetObjectData(idx);
	}

	@Override
	public Object getObject(String columnName) throws SQLException {
		return getObject(getTargetObjectIdx(columnName));
	}

	@Override
	public Object getObject(int arg0, Map<String, Class<?>> arg1)
			throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Object getObject(String arg0, Map<String, Class<?>> arg1)
			throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Ref getRef(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Ref getRef(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public int getRow() throws SQLException {
		return (int) cursor;
	}

	@Override
	public RowId getRowId(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public RowId getRowId(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public SQLXML getSQLXML(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public SQLXML getSQLXML(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public short getShort(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public short getShort(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public Statement getStatement() throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String getString(int idx) throws SQLException {
		Object o = getTargetObjectData(idx);
		if (o == null) {
			return null;
		}
		if (o instanceof java.util.Date) {
			return String.format(formatBuildDate, o);
		} else if (o instanceof java.sql.Date) {
			java.util.Date ud = SQLUtil.getDateOfUtil(o);
			return String.format(formatBuildDate, ud);
		} else if (o instanceof java.sql.Timestamp) {
			Timestamp ts = (Timestamp) o;
			return String.format(formatBuildTimeStamp,
					new java.util.Date(ts.getTime()));
		} else if (o instanceof Status) {
			return net.arnx.jsonic.JSON.encode(o);
		} else if (o instanceof Object[]) {
			return net.arnx.jsonic.JSON.encode(o);
		}
		String str = String.valueOf(o);
		// TODO: replace
		// replace for mysql
		// Ohh gosh I wish you guys could see how beautiful my mother looks
		// right now 😍😍😍😍😍😍😍
		// java.sql.SQLException: Incorrect string value:
		// '\xF0\x9F\x98\x8D\xF0\x9F...' for column 'text' at row 1
		return str;
	}

	@Override
	public String getString(String columnName) throws SQLException {
		return getString(getTargetObjectIdx(columnName));
	}

	@Override
	public Time getTime(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Time getTime(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Time getTime(int arg0, Calendar arg1) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Time getTime(String arg0, Calendar arg1) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Timestamp getTimestamp(int idx) throws SQLException {
		Object o = getTargetObjectData(idx);
		if (o == null) {
			return null;
		}
		if (o instanceof java.util.Date) {
			java.util.Date d = (java.util.Date) o;
			return new Timestamp(d.getTime());
		} else if (o instanceof Long) {
			Long l = (Long) o;
			if (l == 0) {
				return null;
			}
			return new Timestamp(l);
		} else {
			System.err.println("what is this ? " + o);
		}
		return null;
	}

	@Override
	public Timestamp getTimestamp(String columName) throws SQLException {
		return getTimestamp(getTargetObjectIdx(columName));

	}

	@Override
	public Timestamp getTimestamp(int arg0, Calendar arg1) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Timestamp getTimestamp(String arg0, Calendar arg1)
			throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public int getType() throws SQLException {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public URL getURL(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public URL getURL(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public InputStream getUnicodeStream(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public InputStream getUnicodeStream(String arg0) throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public SQLWarning getWarnings() throws SQLException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void insertRow() throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public boolean isAfterLast() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean isBeforeFirst() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean isClosed() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean isFirst() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean isLast() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean last() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void moveToCurrentRow() throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void moveToInsertRow() throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public boolean previous() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void refreshRow() throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public boolean relative(int arg0) throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean rowDeleted() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean rowInserted() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean rowUpdated() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void setFetchDirection(int arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void setFetchSize(int arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateArray(int arg0, Array arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateArray(String arg0, Array arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateAsciiStream(int arg0, InputStream arg1)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateAsciiStream(String arg0, InputStream arg1)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateAsciiStream(int arg0, InputStream arg1, int arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateAsciiStream(String arg0, InputStream arg1, int arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateAsciiStream(int arg0, InputStream arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateAsciiStream(String arg0, InputStream arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBigDecimal(String arg0, BigDecimal arg1)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBinaryStream(int arg0, InputStream arg1)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBinaryStream(String arg0, InputStream arg1)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBinaryStream(int arg0, InputStream arg1, int arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBinaryStream(String arg0, InputStream arg1, int arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBinaryStream(int arg0, InputStream arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBinaryStream(String arg0, InputStream arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBlob(int arg0, Blob arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBlob(String arg0, Blob arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBlob(int arg0, InputStream arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBlob(String arg0, InputStream arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBlob(int arg0, InputStream arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBlob(String arg0, InputStream arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBoolean(int arg0, boolean arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBoolean(String arg0, boolean arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateByte(int arg0, byte arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateByte(String arg0, byte arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBytes(int arg0, byte[] arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateBytes(String arg0, byte[] arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateCharacterStream(int arg0, Reader arg1)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateCharacterStream(String arg0, Reader arg1)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateCharacterStream(int arg0, Reader arg1, int arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateCharacterStream(String arg0, Reader arg1, int arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateCharacterStream(int arg0, Reader arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateCharacterStream(String arg0, Reader arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateClob(int arg0, Clob arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateClob(String arg0, Clob arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateClob(int arg0, Reader arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateClob(String arg0, Reader arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateClob(int arg0, Reader arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateClob(String arg0, Reader arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateDate(int arg0, Date arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateDate(String arg0, Date arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateDouble(int arg0, double arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateDouble(String arg0, double arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateFloat(int arg0, float arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateFloat(String arg0, float arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateInt(int arg0, int arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateInt(String arg0, int arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateLong(int arg0, long arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateLong(String arg0, long arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateNCharacterStream(int arg0, Reader arg1)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateNCharacterStream(String arg0, Reader arg1)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateNCharacterStream(int arg0, Reader arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateNCharacterStream(String arg0, Reader arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateNClob(int arg0, NClob arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateNClob(String arg0, NClob arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateNClob(int arg0, Reader arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateNClob(String arg0, Reader arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateNClob(int arg0, Reader arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateNClob(String arg0, Reader arg1, long arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateNString(int arg0, String arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateNString(String arg0, String arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateNull(int arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateNull(String arg0) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateObject(int arg0, Object arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateObject(String arg0, Object arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateObject(int arg0, Object arg1, int arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateObject(String arg0, Object arg1, int arg2)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateRef(int arg0, Ref arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateRef(String arg0, Ref arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateRow() throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateRowId(int arg0, RowId arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateRowId(String arg0, RowId arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateSQLXML(int arg0, SQLXML arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateSQLXML(String arg0, SQLXML arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateShort(int arg0, short arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateShort(String arg0, short arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateString(int arg0, String arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateString(String arg0, String arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateTime(int arg0, Time arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateTime(String arg0, Time arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateTimestamp(int arg0, Timestamp arg1) throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public void updateTimestamp(String arg0, Timestamp arg1)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public boolean wasNull() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

}
