package hiro.yoshioka.sql.rss;

import hiro.yoshioka.classmanager.ClassManager;
import hiro.yoshioka.sdh.DatabaseType;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.AbsNoSQL;
import hiro.yoshioka.sql.ITransactionSQL;
import hiro.yoshioka.sql.SQLExecutionStatus;
import hiro.yoshioka.sql.SqlBasicListener;
import hiro.yoshioka.sql.engine.DominoTransactionRequest;
import hiro.yoshioka.sql.engine.GettingResourceRequest;
import hiro.yoshioka.sql.engine.MirroringRequest;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.TransactionRequest;
import hiro.yoshioka.sql.notes.NotesRunnerConnectCheck;
import hiro.yoshioka.sql.notes.NotesRunnerMeta;
import hiro.yoshioka.sql.notes.NotesRunnerSelection;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.params.DBUserPass;
import hiro.yoshioka.sql.resource.DBCrossRefference;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.resource.IDBSchema;
import hiro.yoshioka.sql.resource.IDBSequence;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.util.StringUtil;

import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class RssSQL extends AbsNoSQL {
	
	public static void main(String[] args) {
		RssSQL obj = new RssSQL(null);
		
	}

	public RssSQL(ClassManager classManager) {
		super(classManager);
	}

	public DatabaseType getDatabaseType() {
		return DatabaseType.RSS;
	}

	protected DBRoot getMetaData(GettingResourceRequest request)
			throws InterruptedException, ExecutionException {
		this.capturing = true;

		if (request.canceld()) {
			return null;
		}
		ExecutorService ex = Executors.newSingleThreadExecutor();
		try {
			Future<DBRoot> future = null;
			switch (request.targetType) {
			case ONLY_TABLE:
				IDBTable table = (IDBTable) request.selectionResource;
				future = ex.submit(new NotesRunnerMeta(classManager, request,
						table));
				break;
			case ONLY_SCHEMA:
				IDBSchema schema = (IDBSchema) request.selectionResource;
				future = ex.submit(new NotesRunnerMeta(classManager, request,
						schema));
				break;
			default:
				future = ex.submit(new NotesRunnerMeta(classManager, request));
			}
			DBRoot root = future.get();
			setRoot(root);
			return root;
		} finally {
			ex.shutdown();
			capturing = false;
		}
	}

	@Override
	public boolean canDoOperation(SQLOperationType operation) {
		// TODO Auto-generated method stub
		return false;
	}

 

	public boolean connect(ConnectionProperties properties) throws SQLException {

		this._info = properties;

		properties.setConnected(true);
		return true;
	}

	@Override
	public boolean close() throws SQLException {
		if (fConnectionListenerList != null) {
			for (SqlBasicListener listener : fConnectionListenerList) {
				listener.disconnected();
			}
		}
		this._info.setConnected(false);
		return false;
	}

	@Override
	public void setTableColumns(String schema, IDBTable table)
			throws SQLException {
		// TODO Auto-generated method stub
		
	}

 

}
