package hiro.yoshioka.sql.notes.reflect;

import hiro.yoshioka.classmanager.ClassManager;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;

public class WolfDocumentCollection extends AbsWolfDominoReflection {

	Method getCount;
	Method getFirstDocument;
	Method getNextDocument;

	public WolfDocumentCollection(ClassManager classManager,
			Object targetInstance) throws MalformedURLException,
			ClassNotFoundException, SecurityException, NoSuchMethodException {
		super(classManager, targetInstance);

		getCount = targetInstance.getClass().getMethod("getCount");
		getFirstDocument = targetInstance.getClass().getMethod("getFirstDocument");
		getNextDocument = targetInstance.getClass().getMethod("getNextDocument");

	}

	@Override
	public String getDominoClassName() {
		return "lotus.domino.DocumentCollection";
	}

	public int getCount() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (Integer) getCount.invoke(targetInstance);
	}

	public WolfDocument getFirstDocument() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException,
			MalformedURLException, SecurityException, ClassNotFoundException,
			NoSuchMethodException {
		Object instance = getFirstDocument.invoke(targetInstance);
		if (instance == null) {
			return null;
		}
		return new WolfDocument(classManager, instance);
	}

	public WolfDocument getNextDocument() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException,
			MalformedURLException, SecurityException, ClassNotFoundException,
			NoSuchMethodException {
		Object instance = getNextDocument.invoke(targetInstance);
		if (instance == null) {
			return null;
		}
		return new WolfDocument(classManager, instance);
	}

}
