package hiro.yoshioka.sql.mongo;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Map.Entry;

import com.mongodb.DBCursor;
import com.mongodb.DBObject;

public class MongoResultSet implements ResultSet {
	final DBCursor cursor;
	private final Map<Integer, String> keyMap = new LinkedHashMap<Integer, String>();
	private DBObject cursorObject;
	private int indexOfCursor = 0;
	private boolean closed;

	MongoResultSet(DBCursor cursor) {
		this.cursor = cursor;
		int idx = 1;
		for (String key : cursor.getKeysWanted().keySet()) {
			keyMap.put(idx++, key);
		}
	}

	private Object getCursorObjectByIndex(int columnIndex) {
		return cursorObject.get(keyMap.get(columnIndex));
	}

	private Object getCursorObjectByName(String columnName) {
		return cursorObject.get(columnName);
	}

	public boolean next() {
		if (!cursor.hasNext()) {
			return false;
		}
		cursorObject = cursor.next();
		indexOfCursor++;
		return true;
	}

	@Override
	public void clearWarnings() {
	}

	@Override
	public void close() {
		closed = true;
	}

	@Override
	public boolean isClosed() {
		return closed;
	}

	@Override
	public int getConcurrency() {
		return CONCUR_READ_ONLY;
	}

	@Override
	public int getType() {
		return TYPE_FORWARD_ONLY;
	}

	public void setFetchDirection(int direction) {
		if (direction == getFetchDirection())
			return;
		throw new UnsupportedOperationException();
	}

	public int getFetchDirection() {
		return 1;
	}

	public String getCursorName() {
		return "MongoResultSet: " + cursor.toString();
	}

	public ResultSetMetaData getMetaData() {
		throw new UnsupportedOperationException();
	}

	public SQLWarning getWarnings() {
		throw new UnsupportedOperationException();
	}

	public void setFetchSize(int rows) {
		throw new UnsupportedOperationException();
	}

	public int getFetchSize() {
		throw new UnsupportedOperationException();
	}

	public Statement getStatement() {
		throw new UnsupportedOperationException();
	}

	public int getHoldability() {
		return ResultSet.HOLD_CURSORS_OVER_COMMIT;
	}

	public boolean absolute(int row) {
		throw new UnsupportedOperationException();
	}

	public void afterLast() {
		throw new UnsupportedOperationException();
	}

	public void beforeFirst() {
		throw new UnsupportedOperationException();
	}

	public boolean first() {
		throw new UnsupportedOperationException();
	}

	public int getRow() {
		return indexOfCursor;
	}

	public boolean isAfterLast() {
		throw new UnsupportedOperationException();
	}

	public boolean isBeforeFirst() {
		throw new UnsupportedOperationException();
	}

	public boolean isFirst() {
		throw new UnsupportedOperationException();
	}

	public boolean isLast() {
		throw new UnsupportedOperationException();
	}

	public boolean last() {
		throw new UnsupportedOperationException();
	}

	public void moveToCurrentRow() {
		throw new UnsupportedOperationException();
	}

	public void moveToInsertRow() {
		throw new UnsupportedOperationException();
	}

	public boolean previous() {
		throw new UnsupportedOperationException();
	}

	public void refreshRow() {
		throw new UnsupportedOperationException();
	}

	public boolean relative(int rows) {
		throw new UnsupportedOperationException();
	}

	public boolean rowDeleted() {
		throw new UnsupportedOperationException();
	}

	public boolean rowInserted() {
		throw new UnsupportedOperationException();
	}

	public boolean rowUpdated() {
		throw new UnsupportedOperationException();
	}

	public void insertRow() {
		throw new UnsupportedOperationException();
	}

	public void cancelRowUpdates() {
		throw new UnsupportedOperationException();
	}

	public void deleteRow() {
		throw new UnsupportedOperationException();
	}

	public void updateRow() {
		throw new UnsupportedOperationException();
	}

	public void updateArray(int columnIndex, Array x) {
		throw new UnsupportedOperationException();
	}

	public void updateArray(String columnName, Array x) {
		throw new UnsupportedOperationException();
	}

	public void updateAsciiStream(int columnIndex, InputStream x, int length) {
		throw new UnsupportedOperationException();
	}

	public void updateAsciiStream(String columnName, InputStream x, int length) {
		throw new UnsupportedOperationException();
	}

	public void updateAsciiStream(int columnIndex, InputStream x, long length) {
		throw new UnsupportedOperationException();
	}

	public void updateAsciiStream(String columnName, InputStream x, long length) {
		throw new UnsupportedOperationException();
	}

	public void updateAsciiStream(int columnIndex, InputStream x) {
		throw new UnsupportedOperationException();
	}

	public void updateAsciiStream(String columnName, InputStream x) {
		throw new UnsupportedOperationException();
	}

	public void updateBigDecimal(int columnIndex, BigDecimal x) {
		throw new UnsupportedOperationException();
	}

	public void updateBigDecimal(String columnName, BigDecimal x) {
		throw new UnsupportedOperationException();
	}

	public void updateBinaryStream(int columnIndex, InputStream x, int length) {
		throw new UnsupportedOperationException();
	}

	public void updateBinaryStream(String columnName, InputStream x, int length) {
		throw new UnsupportedOperationException();
	}

	public void updateBinaryStream(int columnIndex, InputStream x, long length) {
		throw new UnsupportedOperationException();
	}

	public void updateBinaryStream(String columnName, InputStream x, long length) {
		throw new UnsupportedOperationException();
	}

	public void updateBinaryStream(int columnIndex, InputStream x) {
		throw new UnsupportedOperationException();
	}

	public void updateBinaryStream(String columnName, InputStream x) {
		throw new UnsupportedOperationException();
	}

	public void updateBlob(int columnIndex, Blob x) {
		throw new UnsupportedOperationException();
	}

	public void updateBlob(String columnName, Blob x) {
		throw new UnsupportedOperationException();
	}

	public void updateBlob(int columnIndex, InputStream x) {
		throw new UnsupportedOperationException();
	}

	public void updateBlob(String columnName, InputStream x) {
		throw new UnsupportedOperationException();
	}

	public void updateBlob(int columnIndex, InputStream x, long l) {
		throw new UnsupportedOperationException();
	}

	public void updateBlob(String columnName, InputStream x, long l) {
		throw new UnsupportedOperationException();
	}

	public void updateBoolean(int columnIndex, boolean x) {
		throw new UnsupportedOperationException();
	}

	public void updateBoolean(String columnName, boolean x) {
		throw new UnsupportedOperationException();
	}

	public void updateByte(int columnIndex, byte x) {
		throw new UnsupportedOperationException();
	}

	public void updateByte(String columnName, byte x) {
		throw new UnsupportedOperationException();
	}

	public void updateBytes(int columnIndex, byte[] x) {
		throw new UnsupportedOperationException();
	}

	public void updateBytes(String columnName, byte[] x) {
		throw new UnsupportedOperationException();
	}

	public void updateCharacterStream(int columnIndex, Reader x, int length) {
		throw new UnsupportedOperationException();
	}

	public void updateCharacterStream(String columnName, Reader reader,
			int length) {
		throw new UnsupportedOperationException();
	}

	public void updateCharacterStream(int columnIndex, Reader x, long length) {
		throw new UnsupportedOperationException();
	}

	public void updateCharacterStream(String columnName, Reader reader,
			long length) {
		throw new UnsupportedOperationException();
	}

	public void updateCharacterStream(int columnIndex, Reader x) {
		throw new UnsupportedOperationException();
	}

	public void updateCharacterStream(String columnName, Reader reader) {
		throw new UnsupportedOperationException();
	}

	public void updateClob(int columnIndex, Clob x) {
		throw new UnsupportedOperationException();
	}

	public void updateClob(String columnName, Clob x) {
		throw new UnsupportedOperationException();
	}

	public void updateClob(int columnIndex, Reader x) {
		throw new UnsupportedOperationException();
	}

	public void updateClob(String columnName, Reader x) {
		throw new UnsupportedOperationException();
	}

	public void updateClob(int columnIndex, Reader x, long l) {
		throw new UnsupportedOperationException();
	}

	public void updateClob(String columnName, Reader x, long l) {
		throw new UnsupportedOperationException();
	}

	public void updateDate(int columnIndex, Date x) {
		throw new UnsupportedOperationException();
	}

	public void updateDate(String columnName, Date x) {
		throw new UnsupportedOperationException();
	}

	public void updateDouble(int columnIndex, double x) {
		throw new UnsupportedOperationException();
	}

	public void updateDouble(String columnName, double x) {
		throw new UnsupportedOperationException();
	}

	public void updateFloat(int columnIndex, float x) {
		throw new UnsupportedOperationException();
	}

	public void updateFloat(String columnName, float x) {
		throw new UnsupportedOperationException();
	}

	public void updateInt(int columnIndex, int x) {
		throw new UnsupportedOperationException();
	}

	public void updateInt(String columnName, int x) {
		throw new UnsupportedOperationException();
	}

	public void updateLong(int columnIndex, long x) {
		throw new UnsupportedOperationException();
	}

	public void updateLong(String columnName, long x) {
		throw new UnsupportedOperationException();
	}

	public void updateNull(int columnIndex) {
		throw new UnsupportedOperationException();
	}

	public void updateNull(String columnName) {
		throw new UnsupportedOperationException();
	}

	public void updateObject(int columnIndex, Object x) {
		throw new UnsupportedOperationException();
	}

	public void updateObject(int columnIndex, Object x, int scale) {
		throw new UnsupportedOperationException();
	}

	public void updateObject(String columnName, Object x) {
		throw new UnsupportedOperationException();
	}

	public void updateObject(String columnName, Object x, int scale) {
		throw new UnsupportedOperationException();
	}

	public void updateRef(int columnIndex, Ref x) {
		throw new UnsupportedOperationException();
	}

	public void updateRef(String columnName, Ref x) {
		throw new UnsupportedOperationException();
	}

	public void updateRowId(int columnIndex, RowId x) {
		throw new UnsupportedOperationException();
	}

	public void updateRowId(String columnName, RowId x) {
		throw new UnsupportedOperationException();
	}

	public void updateShort(int columnIndex, short x) {
		throw new UnsupportedOperationException();
	}

	public void updateShort(String columnName, short x) {
		throw new UnsupportedOperationException();
	}

	public void updateSQLXML(int columnIndex, SQLXML xmlObject) {
		throw new UnsupportedOperationException();
	}

	public void updateSQLXML(String columnName, SQLXML xmlObject) {
		throw new UnsupportedOperationException();
	}

	public void updateString(int columnIndex, String x) {
		throw new UnsupportedOperationException();
	}

	public void updateString(String columnName, String x) {
		throw new UnsupportedOperationException();
	}

	public void updateTime(int columnIndex, Time x) {
		throw new UnsupportedOperationException();
	}

	public void updateTime(String columnName, Time x) {
		throw new UnsupportedOperationException();
	}

	public void updateTimestamp(int columnIndex, Timestamp x) {
		throw new UnsupportedOperationException();
	}

	public void updateTimestamp(String columnName, Timestamp x) {
		throw new UnsupportedOperationException();
	}

	public Array getArray(int columnIndex) {
		return (Array) getCursorObjectByIndex(columnIndex);
	}

	public Array getArray(String columnName) {
		return (Array) getCursorObjectByName(columnName);
	}

	public InputStream getAsciiStream(int columnIndex) {
		throw new UnsupportedOperationException();
	}

	public InputStream getAsciiStream(String columnName) {
		throw new UnsupportedOperationException();
	}

	public BigDecimal getBigDecimal(int columnIndex) {
		return (BigDecimal) getCursorObjectByIndex(columnIndex);
	}

	public BigDecimal getBigDecimal(int columnIndex, int scale) {
		return ((BigDecimal) getCursorObjectByIndex(columnIndex))
				.setScale(scale);
	}

	public BigDecimal getBigDecimal(String columnName) {
		return (BigDecimal) getCursorObjectByName(columnName);
	}

	public BigDecimal getBigDecimal(String columnName, int scale) {
		return ((BigDecimal) getCursorObjectByName(columnName)).setScale(scale);
	}

	public InputStream getBinaryStream(int columnIndex) {
		throw new UnsupportedOperationException();
	}

	public InputStream getBinaryStream(String columnName) {
		throw new UnsupportedOperationException();
	}

	public Blob getBlob(int i) {
		throw new UnsupportedOperationException();
	}

	public Blob getBlob(String colName) {
		throw new UnsupportedOperationException();
	}

	public boolean getBoolean(int columnIndex) {
		return (Boolean) getCursorObjectByIndex(columnIndex);
	}

	public boolean getBoolean(String columnName) {
		return (Boolean) getCursorObjectByName(columnName);
	}

	public byte getByte(int columnIndex) {
		return (Byte) getCursorObjectByIndex(columnIndex);
	}

	public byte getByte(String columnName) {
		return (Byte) getCursorObjectByName(columnName);
	}

	public byte[] getBytes(int columnIndex) {
		throw new UnsupportedOperationException();
	}

	public byte[] getBytes(String columnName) {
		throw new UnsupportedOperationException();
	}

	public Reader getCharacterStream(int columnIndex) {
		throw new UnsupportedOperationException();
	}

	public Reader getCharacterStream(String columnName) {
		throw new UnsupportedOperationException();
	}

	public Clob getClob(int i) {
		throw new UnsupportedOperationException();
	}

	public Clob getClob(String colName) {
		throw new UnsupportedOperationException();
	}

	public Date getDate(int columnIndex) {
		return (Date) getCursorObjectByIndex(columnIndex);
	}

	public Date getDate(int columnIndex, Calendar cal) {
		return (Date) getCursorObjectByIndex(columnIndex);
	}

	public Date getDate(String columnName) {
		return (Date) getCursorObjectByName(columnName);
	}

	public Date getDate(String columnName, Calendar cal) {
		return (Date) getCursorObjectByName(columnName);
	}

	public double getDouble(int columnIndex) {
		return (Double) getCursorObjectByIndex(columnIndex);
	}

	public double getDouble(String columnName) {
		return (Double) getCursorObjectByName(columnName);
	}

	public float getFloat(int columnIndex) {
		return (Float) getCursorObjectByIndex(columnIndex);
	}

	public float getFloat(String columnName) {
		return (Float) getCursorObjectByName(columnName);
	}

	public int getInt(int columnIndex) {
		return (Integer) getCursorObjectByIndex(columnIndex);
	}

	public int getInt(String columnName) {
		return (Integer) getCursorObjectByName(columnName);
	}

	public long getLong(int columnIndex) {
		return (Long) getCursorObjectByIndex(columnIndex);
	}

	public long getLong(String columnName) {
		return (Long) getCursorObjectByName(columnName);
	}

	public short getShort(int columnIndex) {
		return (Short) getCursorObjectByIndex(columnIndex);
	}

	public short getShort(String columnName) {
		return (Short) getCursorObjectByName(columnName);
	}

	public Object getObject(int columnIndex) {
		return getCursorObjectByIndex(columnIndex);
	}

	public Object getObject(String columnName) {
		return getCursorObjectByName(columnName);
	}

	@Override
	public Object getObject(int columnIndex, Map<String, Class<?>> arg1)
			throws SQLException {
		return getCursorObjectByIndex(columnIndex);
	}

	@Override
	public Object getObject(String columnName, Map<String, Class<?>> arg1)
			throws SQLException {
		return getCursorObjectByName(columnName);
	}

	public Ref getRef(int columnIndex) {
		return (Ref) getCursorObjectByIndex(columnIndex);
	}

	public Ref getRef(String columnName) {
		return (Ref) getCursorObjectByName(columnName);
	}

	public RowId getRowId(int columnIndex) {
		return (RowId) getCursorObjectByIndex(columnIndex);
	}

	public RowId getRowId(String columnName) {
		return (RowId) getCursorObjectByName(columnName);
	}

	public SQLXML getSQLXML(int columnIndex) {
		throw new UnsupportedOperationException();
	}

	public SQLXML getSQLXML(String columnName) {
		throw new UnsupportedOperationException();
	}

	public String getString(int columnIndex) {
		return (String) getCursorObjectByIndex(columnIndex);
	}

	public String getString(String columnName) {
		return (String) getCursorObjectByName(columnName);
	}

	public Time getTime(int columnIndex) {
		return (Time) getCursorObjectByIndex(columnIndex);
	}

	public Time getTime(int columnIndex, Calendar cal) {
		return (Time) getCursorObjectByIndex(columnIndex);
	}

	public Time getTime(String columnName) {
		return (Time) getCursorObjectByName(columnName);
	}

	public Time getTime(String columnName, Calendar cal) {
		return (Time) getCursorObjectByName(columnName);
	}

	public Timestamp getTimestamp(int columnIndex) {
		return (Timestamp) getCursorObjectByIndex(columnIndex);
	}

	public Timestamp getTimestamp(int columnIndex, Calendar cal) {
		return (Timestamp) getCursorObjectByIndex(columnIndex);
	}

	public Timestamp getTimestamp(String columnName) {
		return (Timestamp) getCursorObjectByName(columnName);
	}

	public Timestamp getTimestamp(String columnName, Calendar cal) {
		return (Timestamp) getCursorObjectByName(columnName);
	}

	public InputStream getUnicodeStream(int columnIndex) {
		throw new UnsupportedOperationException();
	}

	public InputStream getUnicodeStream(String columnName) {
		throw new UnsupportedOperationException();
	}

	public URL getURL(int columnIndex) throws SQLException {
		return (URL) getCursorObjectByIndex(columnIndex);
	}

	public URL getURL(String columnName) throws SQLException {
		return (URL) getCursorObjectByName(columnName);
	}

	public String getNString(int columnIndex) {
		throw new UnsupportedOperationException();
	}

	public String getNString(String columnName) {
		throw new UnsupportedOperationException();
	}

	public NClob getNClob(int columnIndex) {
		throw new UnsupportedOperationException();
	}

	public NClob getNClob(String columnName) {
		throw new UnsupportedOperationException();
	}

	public Reader getNCharacterStream(int columnIndex) {
		throw new UnsupportedOperationException();
	}

	public Reader getNCharacterStream(String columnName) {
		throw new UnsupportedOperationException();
	}

	public void updateNCharacterStream(int columnIndex, Reader x) {
		throw new UnsupportedOperationException();
	}

	public void updateNCharacterStream(int columnIndex, Reader x, long length) {
		throw new UnsupportedOperationException();
	}

	public void updateNCharacterStream(String columnLabel, Reader reader) {
		throw new UnsupportedOperationException();
	}

	public void updateNCharacterStream(String columnLabel, Reader reader,
			long length) {
		throw new UnsupportedOperationException();
	}

	public void updateNClob(int columnIndex, NClob nClob) {
		throw new UnsupportedOperationException();
	}

	public void updateNClob(int columnIndex, Reader reader) {
		throw new UnsupportedOperationException();
	}

	public void updateNClob(int columnIndex, Reader reader, long length) {
		throw new UnsupportedOperationException();
	}

	public void updateNClob(String columnLabel, NClob nClob) {
		throw new UnsupportedOperationException();
	}

	public void updateNClob(String columnLabel, Reader reader) {
		throw new UnsupportedOperationException();
	}

	public void updateNClob(String columnLabel, Reader reader, long length) {
		throw new UnsupportedOperationException();
	}

	public void updateNString(int columnIndex, String nString) {
		throw new UnsupportedOperationException();
	}

	public void updateNString(String columnLabel, String nString) {
		throw new UnsupportedOperationException();
	}

	public boolean wasNull() {
		throw new UnsupportedOperationException();
	}

	public <T> T unwrap(Class<T> iface) throws SQLException {
		throw new UnsupportedOperationException();
	}

	public boolean isWrapperFor(Class<?> iface) throws SQLException {
		throw new UnsupportedOperationException();
	}

	@Override
	public int findColumn(String columnName) throws SQLException {
		for (Entry<Integer, String> entry : keyMap.entrySet()) {
			if (entry.getValue().equals(columnName)) {
				return entry.getKey();
			}
		}
		return -1;
	}

}
